/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameter;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameters;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symboltable.AbstractJavaScope;
import net.sourceforge.pmd.lang.java.symboltable.Applier;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.SimpleTypedNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class ClassScope
extends AbstractJavaScope {
    private static ThreadLocal<Integer> anonymousInnerClassCounter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    private String className;

    public ClassScope(String className) {
        this.className = className;
        anonymousInnerClassCounter.set(1);
    }

    public ClassScope() {
        int v = anonymousInnerClassCounter.get();
        this.className = "Anonymous$" + v;
        anonymousInnerClassCounter.set(v + 1);
    }

    public Map<ClassNameDeclaration, List<NameOccurrence>> getClassDeclarations() {
        return this.getDeclarations(ClassNameDeclaration.class);
    }

    public Map<MethodNameDeclaration, List<NameOccurrence>> getMethodDeclarations() {
        return this.getDeclarations(MethodNameDeclaration.class);
    }

    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        return this.getDeclarations(VariableNameDeclaration.class);
    }

    public NameDeclaration addNameOccurrence(NameOccurrence occurrence) {
        JavaNameOccurrence javaOccurrence = (JavaNameOccurrence)occurrence;
        NameDeclaration decl = this.findVariableHere(javaOccurrence);
        if (decl != null && (javaOccurrence.isMethodOrConstructorInvocation() || javaOccurrence.isMethodReference())) {
            List<NameOccurrence> nameOccurrences = this.getMethodDeclarations().get(decl);
            if (nameOccurrences != null) {
                nameOccurrences.add(javaOccurrence);
                JavaNode n = javaOccurrence.getLocation();
                if (n instanceof ASTName) {
                    ((ASTName)n).setNameDeclaration(decl);
                }
            }
        } else if (decl != null && !javaOccurrence.isThisOrSuper()) {
            List<NameOccurrence> nameOccurrences = this.getVariableDeclarations().get(decl);
            if (nameOccurrences == null) {
                for (ClassNameDeclaration innerClass : this.getClassDeclarations().keySet()) {
                    Scope innerClassScope = innerClass.getScope();
                    if (!innerClassScope.contains((NameOccurrence)javaOccurrence)) continue;
                    innerClassScope.addNameOccurrence((NameOccurrence)javaOccurrence);
                }
            } else {
                nameOccurrences.add(javaOccurrence);
                JavaNode n = javaOccurrence.getLocation();
                if (n instanceof ASTName) {
                    ((ASTName)n).setNameDeclaration(decl);
                }
            }
        }
        return decl;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    protected NameDeclaration findVariableHere(JavaNameOccurrence occurrence) {
        Map<MethodNameDeclaration, List<NameOccurrence>> methodDeclarations = this.getMethodDeclarations();
        Map<VariableNameDeclaration, List<NameOccurrence>> variableDeclarations = this.getVariableDeclarations();
        if (occurrence.isThisOrSuper() || occurrence.getImage() != null && occurrence.getImage().equals(this.className)) {
            if (variableDeclarations.isEmpty() && methodDeclarations.isEmpty()) {
                return null;
            }
            if (!variableDeclarations.isEmpty()) {
                return (NameDeclaration)variableDeclarations.keySet().iterator().next();
            }
            return (NameDeclaration)methodDeclarations.keySet().iterator().next();
        }
        if (occurrence.isMethodOrConstructorInvocation()) {
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                if (!mnd.getImage().equals(occurrence.getImage())) continue;
                List<TypedNameDeclaration> parameterTypes = this.determineParameterTypes(mnd);
                List<TypedNameDeclaration> argumentTypes = this.determineArgumentTypes(occurrence, parameterTypes);
                if (!mnd.isVarargs() && occurrence.getArgumentCount() == mnd.getParameterCount() && parameterTypes.equals(argumentTypes)) {
                    return mnd;
                }
                if (!mnd.isVarargs()) continue;
                int varArgIndex = parameterTypes.size() - 1;
                TypedNameDeclaration varArgType = parameterTypes.get(varArgIndex);
                if (varArgIndex != 0 && argumentTypes.size() < varArgIndex || !parameterTypes.subList(0, varArgIndex).equals(argumentTypes.subList(0, varArgIndex))) continue;
                boolean sameType = true;
                for (int i = varArgIndex; i < argumentTypes.size(); ++i) {
                    if (varArgType.equals(argumentTypes.get(i))) continue;
                    sameType = false;
                    break;
                }
                if (!sameType) continue;
                return mnd;
            }
            return null;
        }
        if (occurrence.isMethodReference()) {
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                if (!mnd.getImage().equals(occurrence.getImage())) continue;
                return mnd;
            }
            return null;
        }
        ArrayList<String> images = new ArrayList<String>();
        if (occurrence.getImage() != null) {
            images.add(occurrence.getImage());
            if (occurrence.getImage().startsWith(this.className)) {
                images.add(this.clipClassName(occurrence.getImage()));
            }
        }
        ImageFinderFunction finder = new ImageFinderFunction(images);
        Applier.apply(finder, variableDeclarations.keySet().iterator());
        NameDeclaration result = finder.getDecl();
        Map<ClassNameDeclaration, List<NameOccurrence>> classDeclarations = this.getClassDeclarations();
        if (result == null && !classDeclarations.isEmpty()) {
            for (ClassNameDeclaration innerClass : this.getClassDeclarations().keySet()) {
                Applier.apply(finder, innerClass.getScope().getDeclarations().keySet().iterator());
                result = finder.getDecl();
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    private List<TypedNameDeclaration> determineParameterTypes(MethodNameDeclaration mnd) {
        ArrayList<TypedNameDeclaration> parameterTypes = new ArrayList<TypedNameDeclaration>();
        List parameters = mnd.getMethodNameDeclaratorNode().findDescendantsOfType(ASTFormalParameter.class);
        for (ASTFormalParameter p : parameters) {
            Class<?> resolvedType = ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).resolveType(p.getTypeNode().getTypeImage());
            if (resolvedType == null) {
                resolvedType = this.resolveGenericType(p, p.getTypeNode().getTypeImage());
            }
            parameterTypes.add(new SimpleTypedNameDeclaration(p.getTypeNode().getTypeImage(), resolvedType));
        }
        return parameterTypes;
    }

    private List<TypedNameDeclaration> determineArgumentTypes(JavaNameOccurrence occurrence, List<TypedNameDeclaration> parameterTypes) {
        ArrayList<TypedNameDeclaration> argumentTypes = new ArrayList<TypedNameDeclaration>();
        ASTArgumentList arguments = null;
        Node nextSibling = null;
        nextSibling = occurrence.getLocation() instanceof ASTPrimarySuffix ? this.getNextSibling((Node)occurrence.getLocation()) : this.getNextSibling(occurrence.getLocation().jjtGetParent());
        if (nextSibling != null) {
            arguments = (ASTArgumentList)nextSibling.getFirstDescendantOfType(ASTArgumentList.class);
        }
        if (arguments != null) {
            for (int i = 0; i < arguments.jjtGetNumChildren(); ++i) {
                Class<?> typeBound;
                Node argument = arguments.jjtGetChild(i);
                Node child = null;
                if (argument.jjtGetNumChildren() > 0 && argument.jjtGetChild(0).jjtGetNumChildren() > 0 && argument.jjtGetChild(0).jjtGetChild(0).jjtGetNumChildren() > 0) {
                    child = argument.jjtGetChild(0).jjtGetChild(0).jjtGetChild(0);
                }
                TypedNameDeclaration type = null;
                if (child instanceof ASTName) {
                    Scope s;
                    ASTName name = (ASTName)child;
                    for (s = name.getScope(); s != null && !s.contains((NameOccurrence)new JavaNameOccurrence(name, name.getImage())); s = s.getParent()) {
                    }
                    if (s != null) {
                        Map vars = s.getDeclarations(VariableNameDeclaration.class);
                        for (VariableNameDeclaration d : vars.keySet()) {
                            if (!d.getImage().equals(name.getImage())) continue;
                            type = new SimpleTypedNameDeclaration(d.getTypeImage(), ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).resolveType(d.getTypeImage()));
                            break;
                        }
                    }
                } else if (child instanceof ASTLiteral) {
                    ASTLiteral literal = (ASTLiteral)child;
                    if (literal.isCharLiteral()) {
                        type = new SimpleTypedNameDeclaration("char", literal.getType());
                    } else if (literal.isStringLiteral()) {
                        type = new SimpleTypedNameDeclaration("String", literal.getType());
                    } else if (literal.isFloatLiteral()) {
                        type = new SimpleTypedNameDeclaration("float", literal.getType());
                    } else if (literal.isDoubleLiteral()) {
                        type = new SimpleTypedNameDeclaration("double", literal.getType());
                    } else if (literal.isIntLiteral()) {
                        type = new SimpleTypedNameDeclaration("int", literal.getType());
                    } else if (literal.isLongLiteral()) {
                        type = new SimpleTypedNameDeclaration("long", literal.getType());
                    }
                } else if (child instanceof ASTAllocationExpression && child.jjtGetChild(0) instanceof ASTClassOrInterfaceType) {
                    ASTClassOrInterfaceType classInterface = (ASTClassOrInterfaceType)child.jjtGetChild(0);
                    String typeImage = classInterface.getImage();
                    type = new SimpleTypedNameDeclaration(typeImage, ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).resolveType(typeImage));
                }
                if (type == null && parameterTypes.size() > i) {
                    type = parameterTypes.get(i);
                }
                if (type != null && type.getType() == null && (typeBound = this.resolveGenericType(argument, type.getTypeImage())) != null) {
                    type = new SimpleTypedNameDeclaration(type.getTypeImage(), typeBound);
                }
                argumentTypes.add(type);
            }
        }
        return argumentTypes;
    }

    private Class<?> resolveGenericType(Node argument, String typeImage) {
        ArrayList<ASTTypeParameter> types = new ArrayList<ASTTypeParameter>();
        types.addAll(((ASTClassOrInterfaceBodyDeclaration)argument.getFirstParentOfType(ASTClassOrInterfaceBodyDeclaration.class)).findDescendantsOfType(ASTTypeParameter.class));
        ASTClassOrInterfaceDeclaration enclosingClassOrEnum = (ASTClassOrInterfaceDeclaration)argument.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        if (enclosingClassOrEnum == null) {
            argument.getFirstParentOfType(ASTEnumDeclaration.class);
        }
        ASTTypeParameters classLevelTypeParameters = null;
        if (enclosingClassOrEnum != null) {
            classLevelTypeParameters = (ASTTypeParameters)enclosingClassOrEnum.getFirstChildOfType(ASTTypeParameters.class);
        }
        if (classLevelTypeParameters != null) {
            types.addAll(classLevelTypeParameters.findDescendantsOfType(ASTTypeParameter.class));
        }
        return this.resolveGenericType(typeImage, types);
    }

    private Class<?> resolveGenericType(String typeImage, List<ASTTypeParameter> types) {
        for (ASTTypeParameter type : types) {
            if (!typeImage.equals(type.getImage())) continue;
            ASTClassOrInterfaceType bound = (ASTClassOrInterfaceType)type.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
            if (bound != null && bound.getType() != null) {
                return bound.getType();
            }
            if (bound == null) continue;
            return ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).resolveType(bound.getImage());
        }
        return null;
    }

    private Node getNextSibling(Node current) {
        Node nextSibling = null;
        for (int i = 0; i < current.jjtGetParent().jjtGetNumChildren() - 1; ++i) {
            if (current.jjtGetParent().jjtGetChild(i) != current) continue;
            nextSibling = current.jjtGetParent().jjtGetChild(i + 1);
            break;
        }
        return nextSibling;
    }

    public String toString() {
        Map<VariableNameDeclaration, List<NameOccurrence>> variableDeclarations;
        Map<MethodNameDeclaration, List<NameOccurrence>> methodDeclarations;
        StringBuilder res = new StringBuilder("ClassScope (").append(this.className).append("): ");
        Map<ClassNameDeclaration, List<NameOccurrence>> classDeclarations = this.getClassDeclarations();
        if (classDeclarations.isEmpty()) {
            res.append("Inner Classes ").append(this.glomNames(classDeclarations.keySet())).append("; ");
        }
        if (!(methodDeclarations = this.getMethodDeclarations()).isEmpty()) {
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                res.append(mnd.toString());
                int usages = methodDeclarations.get((Object)mnd).size();
                res.append("(begins at line ").append(mnd.getNode().getBeginLine()).append(", ").append(usages).append(" usages)");
                res.append(", ");
            }
        }
        if (!(variableDeclarations = this.getVariableDeclarations()).isEmpty()) {
            res.append("Variables ").append(this.glomNames(variableDeclarations.keySet()));
        }
        return res.toString();
    }

    private String clipClassName(String s) {
        return s.substring(s.indexOf(46) + 1);
    }
}

