/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.conf;

import java.util.Collections;
import java.util.List;
import org.activiti.api.runtime.shared.events.VariableEventListener;
import org.activiti.api.runtime.shared.identity.UserGroupManager;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.api.task.runtime.TaskAdminRuntime;
import org.activiti.api.task.runtime.TaskRuntime;
import org.activiti.api.task.runtime.conf.TaskRuntimeConfiguration;
import org.activiti.api.task.runtime.events.TaskActivatedEvent;
import org.activiti.api.task.runtime.events.TaskAssignedEvent;
import org.activiti.api.task.runtime.events.TaskCancelledEvent;
import org.activiti.api.task.runtime.events.TaskCandidateGroupAddedEvent;
import org.activiti.api.task.runtime.events.TaskCandidateGroupRemovedEvent;
import org.activiti.api.task.runtime.events.TaskCandidateUserAddedEvent;
import org.activiti.api.task.runtime.events.TaskCandidateUserRemovedEvent;
import org.activiti.api.task.runtime.events.TaskCompletedEvent;
import org.activiti.api.task.runtime.events.TaskCreatedEvent;
import org.activiti.api.task.runtime.events.TaskSuspendedEvent;
import org.activiti.api.task.runtime.events.TaskUpdatedEvent;
import org.activiti.api.task.runtime.events.listener.TaskRuntimeEventListener;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.runtime.api.conf.CommonRuntimeAutoConfiguration;
import org.activiti.runtime.api.conf.impl.TaskRuntimeConfigurationImpl;
import org.activiti.runtime.api.event.impl.ToAPITaskAssignedEventConverter;
import org.activiti.runtime.api.event.impl.ToAPITaskCandidateGroupAddedEventConverter;
import org.activiti.runtime.api.event.impl.ToAPITaskCandidateUserAddedEventConverter;
import org.activiti.runtime.api.event.impl.ToAPITaskCreatedEventConverter;
import org.activiti.runtime.api.event.impl.ToAPITaskUpdatedEventConverter;
import org.activiti.runtime.api.event.impl.ToTaskActivatedConverter;
import org.activiti.runtime.api.event.impl.ToTaskCancelledConverter;
import org.activiti.runtime.api.event.impl.ToTaskCandidateGroupRemovedConverter;
import org.activiti.runtime.api.event.impl.ToTaskCandidateUserRemovedConverter;
import org.activiti.runtime.api.event.impl.ToTaskCompletedConverter;
import org.activiti.runtime.api.event.impl.ToTaskSuspendedConverter;
import org.activiti.runtime.api.event.internal.TaskActivatedListenerDelegate;
import org.activiti.runtime.api.event.internal.TaskAssignedListenerDelegate;
import org.activiti.runtime.api.event.internal.TaskCancelledListenerDelegate;
import org.activiti.runtime.api.event.internal.TaskCandidateGroupAddedListenerDelegate;
import org.activiti.runtime.api.event.internal.TaskCandidateGroupRemovedListenerDelegate;
import org.activiti.runtime.api.event.internal.TaskCandidateUserAddedListenerDelegate;
import org.activiti.runtime.api.event.internal.TaskCandidateUserRemovedListenerDelegate;
import org.activiti.runtime.api.event.internal.TaskCompletedListenerDelegate;
import org.activiti.runtime.api.event.internal.TaskCreatedListenerDelegate;
import org.activiti.runtime.api.event.internal.TaskSuspendedListenerDelegate;
import org.activiti.runtime.api.event.internal.TaskUpdatedListenerDelegate;
import org.activiti.runtime.api.impl.TaskAdminRuntimeImpl;
import org.activiti.runtime.api.impl.TaskRuntimeHelper;
import org.activiti.runtime.api.impl.TaskRuntimeImpl;
import org.activiti.runtime.api.model.impl.APITaskCandidateGroupConverter;
import org.activiti.runtime.api.model.impl.APITaskCandidateUserConverter;
import org.activiti.runtime.api.model.impl.APITaskConverter;
import org.activiti.runtime.api.model.impl.APIVariableInstanceConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={CommonRuntimeAutoConfiguration.class})
public class TaskRuntimeAutoConfiguration {
    @Bean
    public TaskRuntime taskRuntime(TaskService taskService, UserGroupManager userGroupManager, SecurityManager securityManager, APITaskConverter taskConverter, APIVariableInstanceConverter variableInstanceConverter, TaskRuntimeConfiguration configuration, TaskRuntimeHelper taskRuntimeHelper) {
        return new TaskRuntimeImpl(taskService, userGroupManager, securityManager, taskConverter, variableInstanceConverter, configuration, taskRuntimeHelper);
    }

    @Bean
    public TaskAdminRuntime taskAdminRuntime(TaskService taskService, APITaskConverter taskConverter, TaskRuntimeHelper taskRuntimeHelper) {
        return new TaskAdminRuntimeImpl(taskService, taskConverter, taskRuntimeHelper);
    }

    @Bean
    public TaskRuntimeHelper taskRuntimeHelper(TaskService taskService, APITaskConverter taskConverter, SecurityManager securityManager, UserGroupManager userGroupManager) {
        return new TaskRuntimeHelper(taskService, taskConverter, securityManager, userGroupManager);
    }

    @Bean
    public APITaskConverter apiTaskConverter() {
        return new APITaskConverter();
    }

    @Bean
    public TaskRuntimeConfiguration taskRuntimeConfiguration(@Autowired(required=false) List<TaskRuntimeEventListener<?>> taskRuntimeEventListeners, @Autowired(required=false) List<VariableEventListener<?>> variableEventListeners) {
        return new TaskRuntimeConfigurationImpl(this.getInitializedTaskRuntimeEventListeners(taskRuntimeEventListeners), this.getInitializedTaskRuntimeEventListeners(variableEventListeners));
    }

    @Bean
    public InitializingBean registerTaskCreatedEventListener(RuntimeService runtimeService, @Autowired(required=false) List<TaskRuntimeEventListener<TaskCreatedEvent>> listeners, ToAPITaskCreatedEventConverter taskCreatedEventConverter) {
        return () -> runtimeService.addEventListener((ActivitiEventListener)new TaskCreatedListenerDelegate(this.getInitializedTaskRuntimeEventListeners(listeners), taskCreatedEventConverter), new ActivitiEventType[]{ActivitiEventType.TASK_CREATED});
    }

    @Bean
    public InitializingBean registerTaskUpdatedEventListener(RuntimeService runtimeService, @Autowired(required=false) List<TaskRuntimeEventListener<TaskUpdatedEvent>> listeners, ToAPITaskUpdatedEventConverter taskCreatedEventConverter) {
        return () -> runtimeService.addEventListener((ActivitiEventListener)new TaskUpdatedListenerDelegate(this.getInitializedTaskRuntimeEventListeners(listeners), taskCreatedEventConverter), new ActivitiEventType[]{ActivitiEventType.ENTITY_UPDATED});
    }

    private <T> List<T> getInitializedTaskRuntimeEventListeners(List<T> taskRuntimeEventListeners) {
        return taskRuntimeEventListeners != null ? taskRuntimeEventListeners : Collections.emptyList();
    }

    @Bean
    public InitializingBean registerTaskAssignedEventListener(RuntimeService runtimeService, @Autowired(required=false) List<TaskRuntimeEventListener<TaskAssignedEvent>> listeners, ToAPITaskAssignedEventConverter taskAssignedEventConverter) {
        return () -> runtimeService.addEventListener((ActivitiEventListener)new TaskAssignedListenerDelegate(this.getInitializedTaskRuntimeEventListeners(listeners), taskAssignedEventConverter), new ActivitiEventType[]{ActivitiEventType.TASK_ASSIGNED});
    }

    @Bean
    public InitializingBean registerTaskCompletedEventListener(RuntimeService runtimeService, @Autowired(required=false) List<TaskRuntimeEventListener<TaskCompletedEvent>> listeners, APITaskConverter taskConverter) {
        return () -> runtimeService.addEventListener((ActivitiEventListener)new TaskCompletedListenerDelegate(this.getInitializedTaskRuntimeEventListeners(listeners), new ToTaskCompletedConverter(taskConverter)), new ActivitiEventType[]{ActivitiEventType.TASK_COMPLETED});
    }

    @Bean
    public InitializingBean registerTaskCancelledEventListener(RuntimeService runtimeService, @Autowired(required=false) List<TaskRuntimeEventListener<TaskCancelledEvent>> taskRuntimeEventListeners, TaskService taskService, APITaskConverter taskConverter) {
        return () -> runtimeService.addEventListener((ActivitiEventListener)new TaskCancelledListenerDelegate(this.getInitializedTaskRuntimeEventListeners(taskRuntimeEventListeners), new ToTaskCancelledConverter(taskConverter, taskService)), new ActivitiEventType[]{ActivitiEventType.ACTIVITY_CANCELLED});
    }

    @Bean
    public InitializingBean registerTaskSuspendedListener(RuntimeService runtimeService, @Autowired(required=false) List<TaskRuntimeEventListener<TaskSuspendedEvent>> listeners, APITaskConverter taskConverter) {
        return () -> runtimeService.addEventListener((ActivitiEventListener)new TaskSuspendedListenerDelegate(this.getInitializedTaskRuntimeEventListeners(listeners), new ToTaskSuspendedConverter(taskConverter)), new ActivitiEventType[]{ActivitiEventType.ENTITY_SUSPENDED});
    }

    @Bean
    public InitializingBean registerTaskActivatedListener(RuntimeService runtimeService, @Autowired(required=false) List<TaskRuntimeEventListener<TaskActivatedEvent>> listeners, APITaskConverter taskConverter) {
        return () -> runtimeService.addEventListener((ActivitiEventListener)new TaskActivatedListenerDelegate(this.getInitializedTaskRuntimeEventListeners(listeners), new ToTaskActivatedConverter(taskConverter)), new ActivitiEventType[]{ActivitiEventType.ENTITY_ACTIVATED});
    }

    @Bean
    public ToAPITaskCreatedEventConverter apiTaskCreatedEventConverter(APITaskConverter taskConverter) {
        return new ToAPITaskCreatedEventConverter(taskConverter);
    }

    @Bean
    public ToAPITaskUpdatedEventConverter apiTaskUpdatedEventConverter(APITaskConverter taskConverter) {
        return new ToAPITaskUpdatedEventConverter(taskConverter);
    }

    @Bean
    public ToAPITaskAssignedEventConverter apiTaskAssignedEventConverter(APITaskConverter taskConverter) {
        return new ToAPITaskAssignedEventConverter(taskConverter);
    }

    @Bean
    public APITaskCandidateUserConverter apiTaskCandidateUserConverter() {
        return new APITaskCandidateUserConverter();
    }

    @Bean
    public ToAPITaskCandidateUserAddedEventConverter toAPITaskCandidateUserAddedEventConverter(APITaskCandidateUserConverter taskCandidateUserConverter) {
        return new ToAPITaskCandidateUserAddedEventConverter(taskCandidateUserConverter);
    }

    @Bean
    public InitializingBean registerTaskCandidateUserAddedEventListener(RuntimeService runtimeService, @Autowired(required=false) List<TaskRuntimeEventListener<TaskCandidateUserAddedEvent>> listeners, ToAPITaskCandidateUserAddedEventConverter taskCandidateUserAddedEventConverter) {
        return () -> runtimeService.addEventListener((ActivitiEventListener)new TaskCandidateUserAddedListenerDelegate(this.getInitializedTaskRuntimeEventListeners(listeners), taskCandidateUserAddedEventConverter), new ActivitiEventType[]{ActivitiEventType.ENTITY_CREATED});
    }

    @Bean
    public InitializingBean registerTaskCandidateUserRemovedEventListener(RuntimeService runtimeService, @Autowired(required=false) List<TaskRuntimeEventListener<TaskCandidateUserRemovedEvent>> listeners, APITaskCandidateUserConverter taskCandidateUserConverter) {
        return () -> runtimeService.addEventListener((ActivitiEventListener)new TaskCandidateUserRemovedListenerDelegate(this.getInitializedTaskRuntimeEventListeners(listeners), new ToTaskCandidateUserRemovedConverter(taskCandidateUserConverter)), new ActivitiEventType[]{ActivitiEventType.ENTITY_DELETED});
    }

    @Bean
    public APITaskCandidateGroupConverter apiTaskCandidateGroupConverter() {
        return new APITaskCandidateGroupConverter();
    }

    @Bean
    public ToAPITaskCandidateGroupAddedEventConverter toAPITaskCandidateGroupAddedEventConverter(APITaskCandidateGroupConverter taskCandidateGroupConverter) {
        return new ToAPITaskCandidateGroupAddedEventConverter(taskCandidateGroupConverter);
    }

    @Bean
    public InitializingBean registerTaskCandidateGroupAddedEventListener(RuntimeService runtimeService, @Autowired(required=false) List<TaskRuntimeEventListener<TaskCandidateGroupAddedEvent>> listeners, ToAPITaskCandidateGroupAddedEventConverter taskCandidateGroupAddedEventConverter) {
        return () -> runtimeService.addEventListener((ActivitiEventListener)new TaskCandidateGroupAddedListenerDelegate(this.getInitializedTaskRuntimeEventListeners(listeners), taskCandidateGroupAddedEventConverter), new ActivitiEventType[]{ActivitiEventType.ENTITY_CREATED});
    }

    @Bean
    public InitializingBean registerTaskCandidateGroupRemovedEventListener(RuntimeService runtimeService, @Autowired(required=false) List<TaskRuntimeEventListener<TaskCandidateGroupRemovedEvent>> listeners, APITaskCandidateGroupConverter taskCandidateGroupConverter) {
        return () -> runtimeService.addEventListener((ActivitiEventListener)new TaskCandidateGroupRemovedListenerDelegate(this.getInitializedTaskRuntimeEventListeners(listeners), new ToTaskCandidateGroupRemovedConverter(taskCandidateGroupConverter)), new ActivitiEventType[]{ActivitiEventType.ENTITY_DELETED});
    }
}

