/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.event.impl;

import java.util.List;
import java.util.Optional;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.impl.TaskImpl;
import org.activiti.api.task.runtime.events.TaskCancelledEvent;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.event.ActivitiActivityCancelledEvent;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.runtime.api.event.impl.EventConverter;
import org.activiti.runtime.api.event.impl.TaskCancelledImpl;
import org.activiti.runtime.api.model.impl.APITaskConverter;

public class ToTaskCancelledConverter
implements EventConverter<TaskCancelledEvent, ActivitiActivityCancelledEvent> {
    private APITaskConverter taskConverter;
    private TaskService taskService;

    public ToTaskCancelledConverter(APITaskConverter taskConverter, TaskService taskService) {
        this.taskConverter = taskConverter;
        this.taskService = taskService;
    }

    public Optional<TaskCancelledEvent> from(ActivitiActivityCancelledEvent internalEvent) {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        if (internalEvent.getProcessInstanceId() != null) {
            taskQuery.processInstanceId(internalEvent.getProcessInstanceId());
            if (internalEvent.getActivityId() != null) {
                taskQuery.taskDefinitionKey(internalEvent.getActivityId());
            }
        } else if (internalEvent.getExecutionId() != null) {
            taskQuery.taskId(internalEvent.getExecutionId());
        }
        List tasks = taskQuery.list();
        TaskCancelledImpl event = null;
        if (tasks.size() == 1) {
            org.activiti.api.task.model.Task task = this.taskConverter.from((Task)tasks.get(0));
            ((TaskImpl)task).setStatus(Task.TaskStatus.CANCELLED);
            event = new TaskCancelledImpl(task);
        }
        return Optional.ofNullable(event);
    }
}

