/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.definition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.activiti.workflow.simple.definition.FeedbackStepDefinition;
import org.activiti.workflow.simple.definition.HumanStepDefinition;
import org.activiti.workflow.simple.definition.ScriptStepDefinition;
import org.activiti.workflow.simple.definition.StepDefinition;
import org.activiti.workflow.simple.definition.StepDefinitionContainer;

public abstract class AbstractStepDefinitionContainer<T>
implements StepDefinitionContainer<T> {
    protected String id;
    protected List<StepDefinition> steps = new ArrayList<StepDefinition>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void addStep(StepDefinition stepDefinition) {
        this.steps.add(stepDefinition);
    }

    @Override
    public List<StepDefinition> getSteps() {
        return this.steps;
    }

    public T addHumanStep(String id, String name, String assignee) {
        return this.addHumanStep(id, name, assignee, false);
    }

    @Override
    public T addHumanStep(String name, String assignee) {
        return this.addHumanStep(null, name, assignee, false);
    }

    public T addHumanStepForWorkflowInitiator(String id, String name) {
        return this.addHumanStep(id, name, null, true);
    }

    @Override
    public T addHumanStepForWorkflowInitiator(String name) {
        return this.addHumanStep(null, name, null, true);
    }

    public T addHumanStepForGroup(String name, List<String> groups) {
        HumanStepDefinition humanStepDefinition = this.createHumanStepDefinition(name);
        humanStepDefinition.setCandidateGroups(groups);
        return (T)this;
    }

    public T addHumanStepForGroup(String id, String name, List<String> groups) {
        HumanStepDefinition humanStepDefinition = this.createHumanStepDefinition(name);
        humanStepDefinition.setCandidateGroups(groups);
        return (T)this;
    }

    public T addHumanStepForGroup(String name, String ... groups) {
        return this.addHumanStepForGroup(name, Arrays.asList(groups));
    }

    protected T addHumanStep(String id, String name, String assignee, boolean initiator) {
        this.createHumanStepDefinition(name, assignee, initiator);
        return (T)this;
    }

    protected HumanStepDefinition createHumanStepDefinition(String name) {
        return this.createHumanStepDefinition(name, null);
    }

    protected HumanStepDefinition createHumanStepDefinition(String name, String assignee) {
        return this.createHumanStepDefinition(name, assignee, false);
    }

    protected HumanStepDefinition createHumanStepDefinition(String name, String assignee, boolean initiator) {
        return this.createHumanStepDefinition(null, name, assignee, initiator);
    }

    protected HumanStepDefinition createHumanStepDefinition(String id, String name, String assignee, boolean initiator) {
        HumanStepDefinition humanStepDefinition = new HumanStepDefinition();
        humanStepDefinition.setId(id);
        humanStepDefinition.setName(name);
        humanStepDefinition.setAssignee(assignee);
        this.addStep(humanStepDefinition);
        return humanStepDefinition;
    }

    public T addFeedbackStep(String name, String initiator) {
        return this.addFeedbackStep(name, initiator, null);
    }

    public T addFeedbackStep(String name, String initiator, List<String> feedbackProviders) {
        FeedbackStepDefinition feedbackStepDefinition = new FeedbackStepDefinition();
        feedbackStepDefinition.setName(name);
        feedbackStepDefinition.setFeedbackInitiator(initiator);
        if (feedbackProviders != null) {
            feedbackStepDefinition.setFeedbackProviders(feedbackProviders);
        }
        this.addStep(feedbackStepDefinition);
        return (T)this;
    }

    public T addScriptStep(String script) {
        return this.addScriptStep(null, script);
    }

    public T addScriptStep(String name, String script) {
        ScriptStepDefinition scriptStepDefinition = new ScriptStepDefinition();
        scriptStepDefinition.setName(name);
        scriptStepDefinition.setScript(script);
        this.addStep(scriptStepDefinition);
        return (T)this;
    }
}

