/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionVertex;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.util.Preconditions;

public class DefaultSchedulingPipelinedRegion
implements SchedulingPipelinedRegion {
    private final Map<ExecutionVertexID, DefaultExecutionVertex> executionVertices;
    private Set<ConsumedPartitionGroup> nonPipelinedConsumedPartitionGroups;
    private Set<ConsumedPartitionGroup> releaseBySchedulerConsumedPartitionGroups;
    private final Function<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionRetriever;

    public DefaultSchedulingPipelinedRegion(Set<DefaultExecutionVertex> defaultExecutionVertices, Function<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionRetriever) {
        Preconditions.checkNotNull(defaultExecutionVertices);
        this.executionVertices = new HashMap<ExecutionVertexID, DefaultExecutionVertex>();
        for (DefaultExecutionVertex executionVertex : defaultExecutionVertices) {
            this.executionVertices.put(executionVertex.getId(), executionVertex);
        }
        this.resultPartitionRetriever = (Function)Preconditions.checkNotNull(resultPartitionRetriever);
    }

    @Override
    public Iterable<DefaultExecutionVertex> getVertices() {
        return Collections.unmodifiableCollection(this.executionVertices.values());
    }

    @Override
    public DefaultExecutionVertex getVertex(ExecutionVertexID vertexId) {
        DefaultExecutionVertex executionVertex = this.executionVertices.get(vertexId);
        if (executionVertex == null) {
            throw new IllegalArgumentException(String.format("Execution vertex %s not found in pipelined region", vertexId));
        }
        return executionVertex;
    }

    private void initializeConsumedPartitionGroups() {
        HashSet<ConsumedPartitionGroup> nonPipelinedConsumedPartitionGroupSet = new HashSet<ConsumedPartitionGroup>();
        HashSet<ConsumedPartitionGroup> releaseBySchedulerConsumedPartitionGroupSet = new HashSet<ConsumedPartitionGroup>();
        for (DefaultExecutionVertex executionVertex : this.executionVertices.values()) {
            for (ConsumedPartitionGroup consumedPartitionGroup : executionVertex.getConsumedPartitionGroups()) {
                SchedulingResultPartition consumedPartition = this.resultPartitionRetriever.apply(consumedPartitionGroup.getFirst());
                if (!consumedPartition.getResultType().mustBePipelinedConsumed()) {
                    nonPipelinedConsumedPartitionGroupSet.add(consumedPartitionGroup);
                }
                if (!consumedPartition.getResultType().isReleaseByScheduler()) continue;
                releaseBySchedulerConsumedPartitionGroupSet.add(consumedPartitionGroup);
            }
        }
        this.nonPipelinedConsumedPartitionGroups = Collections.unmodifiableSet(nonPipelinedConsumedPartitionGroupSet);
        this.releaseBySchedulerConsumedPartitionGroups = Collections.unmodifiableSet(releaseBySchedulerConsumedPartitionGroupSet);
    }

    @Override
    public Iterable<ConsumedPartitionGroup> getAllNonPipelinedConsumedPartitionGroups() {
        if (this.nonPipelinedConsumedPartitionGroups == null) {
            this.initializeConsumedPartitionGroups();
        }
        return this.nonPipelinedConsumedPartitionGroups;
    }

    @Override
    public Iterable<ConsumedPartitionGroup> getAllReleaseBySchedulerConsumedPartitionGroups() {
        if (this.releaseBySchedulerConsumedPartitionGroups == null) {
            this.initializeConsumedPartitionGroups();
        }
        return this.releaseBySchedulerConsumedPartitionGroups;
    }

    @Override
    public boolean contains(ExecutionVertexID vertexId) {
        return this.executionVertices.containsKey(vertexId);
    }
}

