/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spring.boot;

import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.arbiters.Arbiter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.spring.boot.SpringEnvironmentHolder;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.util.StringUtils;

@Plugin(name="SpringProfile", category="Core", elementType="Arbiter", deferChildren=true, printObject=true)
public class SpringProfileArbiter
extends SpringEnvironmentHolder
implements Arbiter {
    private final String[] profileNames;

    private SpringProfileArbiter(String[] profiles) {
        this.profileNames = profiles;
    }

    public boolean isCondition() {
        Environment environment = this.getEnvironment();
        if (environment == null) {
            return false;
        }
        if (this.profileNames.length == 0) {
            return false;
        }
        return environment.acceptsProfiles(Profiles.of((String[])this.profileNames));
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<SpringProfileArbiter> {
        public static final String ATTR_NAME = "name";
        @PluginBuilderAttribute(value="name")
        private String name;
        @PluginConfiguration
        private Configuration configuration;

        public Builder setName(String name) {
            this.name = name;
            return this.asBuilder();
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this.asBuilder();
        }

        private Builder asBuilder() {
            return this;
        }

        public SpringProfileArbiter build() {
            String[] profileNames = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)this.configuration.getStrSubstitutor().replace(this.name)));
            return new SpringProfileArbiter(profileNames);
        }
    }
}

