/*
 * $Id$
 */

package org.apache.maven.plugin.registry;

/**
 * Policy for updating a single plugin.
 * 
 * @version $Revision$ $Date$
 */
public class Plugin extends TrackableBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field lastChecked
     */
    private String lastChecked;

    /**
     * Field useVersion
     */
    private String useVersion;

    /**
     * Field rejectedVersions
     */
    private java.util.List rejectedVersions;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addRejectedVersion
     * 
     * @param string
     */
    public void addRejectedVersion(String string)
    {
        getRejectedVersions().add( string );
    } //-- void addRejectedVersion(String) 

    /**
     * Get null
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get null
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get [format: yyyy-MM-dd.HH:mm:ss Z] Specifies the date/time
     * at which this plugin was last checked.
     */
    public String getLastChecked()
    {
        return this.lastChecked;
    } //-- String getLastChecked() 

    /**
     * Method getRejectedVersions
     */
    public java.util.List getRejectedVersions()
    {
        if ( this.rejectedVersions == null )
        {
            this.rejectedVersions = new java.util.ArrayList();
        }
        
        return this.rejectedVersions;
    } //-- java.util.List getRejectedVersions() 

    /**
     * Get The current version of this plugin, to be used until the
     * appropriate update actions happen.
     */
    public String getUseVersion()
    {
        return this.useVersion;
    } //-- String getUseVersion() 

    /**
     * Method removeRejectedVersion
     * 
     * @param string
     */
    public void removeRejectedVersion(String string)
    {
        getRejectedVersions().remove( string );
    } //-- void removeRejectedVersion(String) 

    /**
     * Set null
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set null
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set [format: yyyy-MM-dd.HH:mm:ss Z] Specifies the date/time
     * at which this plugin was last checked.
     * 
     * @param lastChecked
     */
    public void setLastChecked(String lastChecked)
    {
        this.lastChecked = lastChecked;
    } //-- void setLastChecked(String) 

    /**
     * Set The list of versions for this plugin that the user
     * declined to "install"
     * 
     * @param rejectedVersions
     */
    public void setRejectedVersions(java.util.List rejectedVersions)
    {
        this.rejectedVersions = rejectedVersions;
    } //-- void setRejectedVersions(java.util.List) 

    /**
     * Set The current version of this plugin, to be used until the
     * appropriate update actions happen.
     * 
     * @param useVersion
     */
    public void setUseVersion(String useVersion)
    {
        this.useVersion = useVersion;
    } //-- void setUseVersion(String) 


    public static final String LAST_CHECKED_DATE_FORMAT = "yyyy-MM-dd.HH:mm:ss Z";
    
    public String getKey()
    {
        return getGroupId() + ":" + getArtifactId();
    }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
