/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.GroupVersionAlignment;
import org.apache.maven.plugin.assembly.model.ModuleBinaries;
import org.apache.maven.plugin.assembly.model.ModuleSet;
import org.apache.maven.plugin.assembly.model.ModuleSources;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.model.UnpackOptions;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class AssemblyXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public AssemblyXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public AssemblyXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public Assembly read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict);
    }

    public Assembly read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public Assembly read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in), strict);
    }

    public Assembly read(InputStream in) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in));
    }

    private Assembly parseAssembly(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Assembly assembly = new Assembly();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                assembly.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "formats", null, parsed)) {
                ArrayList<String> formats = new ArrayList<String>();
                assembly.setFormats(formats);
                while (parser.nextTag() == 2) {
                    if ("format".equals(parser.getName())) {
                        formats.add(this.interpolatedTrimmed(parser.nextText(), "formats"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includeBaseDirectory", null, parsed)) {
                assembly.setIncludeBaseDirectory(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "includeBaseDirectory"), "includeBaseDirectory", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "baseDirectory", null, parsed)) {
                assembly.setBaseDirectory(this.interpolatedTrimmed(parser.nextText(), "baseDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includeSiteDirectory", null, parsed)) {
                assembly.setIncludeSiteDirectory(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "includeSiteDirectory"), "includeSiteDirectory", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "containerDescriptorHandlers", null, parsed)) {
                ArrayList<ContainerDescriptorHandlerConfig> containerDescriptorHandlers = new ArrayList<ContainerDescriptorHandlerConfig>();
                assembly.setContainerDescriptorHandlers(containerDescriptorHandlers);
                while (parser.nextTag() == 2) {
                    if ("containerDescriptorHandler".equals(parser.getName())) {
                        containerDescriptorHandlers.add(this.parseContainerDescriptorHandlerConfig(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "moduleSets", null, parsed)) {
                ArrayList<ModuleSet> moduleSets = new ArrayList<ModuleSet>();
                assembly.setModuleSets(moduleSets);
                while (parser.nextTag() == 2) {
                    if ("moduleSet".equals(parser.getName())) {
                        moduleSets.add(this.parseModuleSet(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileSets", null, parsed)) {
                ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
                assembly.setFileSets(fileSets);
                while (parser.nextTag() == 2) {
                    if ("fileSet".equals(parser.getName())) {
                        fileSets.add(this.parseFileSet(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "files", null, parsed)) {
                ArrayList<FileItem> files = new ArrayList<FileItem>();
                assembly.setFiles(files);
                while (parser.nextTag() == 2) {
                    if ("file".equals(parser.getName())) {
                        files.add(this.parseFileItem(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencySets", null, parsed)) {
                ArrayList<DependencySet> dependencySets = new ArrayList<DependencySet>();
                assembly.setDependencySets(dependencySets);
                while (parser.nextTag() == 2) {
                    if ("dependencySet".equals(parser.getName())) {
                        dependencySets.add(this.parseDependencySet(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                assembly.setRepositories(repositories);
                while (parser.nextTag() == 2) {
                    if ("repository".equals(parser.getName())) {
                        repositories.add(this.parseRepository(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "componentDescriptors", null, parsed)) {
                ArrayList<String> componentDescriptors = new ArrayList<String>();
                assembly.setComponentDescriptors(componentDescriptors);
                while (parser.nextTag() == 2) {
                    if ("componentDescriptor".equals(parser.getName())) {
                        componentDescriptors.add(this.interpolatedTrimmed(parser.nextText(), "componentDescriptors"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return assembly;
    }

    private ContainerDescriptorHandlerConfig parseContainerDescriptorHandlerConfig(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig = new ContainerDescriptorHandlerConfig();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "handlerName", null, parsed)) {
                containerDescriptorHandlerConfig.setHandlerName(this.interpolatedTrimmed(parser.nextText(), "handlerName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                containerDescriptorHandlerConfig.setConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return containerDescriptorHandlerConfig;
    }

    private DependencySet parseDependencySet(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DependencySet dependencySet = new DependencySet();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                dependencySet.setOutputDirectory(this.interpolatedTrimmed(parser.nextText(), "outputDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                dependencySet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        includes.add(this.interpolatedTrimmed(parser.nextText(), "includes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                dependencySet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                dependencySet.setFileMode(this.interpolatedTrimmed(parser.nextText(), "fileMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryMode", null, parsed)) {
                dependencySet.setDirectoryMode(this.interpolatedTrimmed(parser.nextText(), "directoryMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useStrictFiltering", null, parsed)) {
                dependencySet.setUseStrictFiltering(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "useStrictFiltering"), "useStrictFiltering", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputFileNameMapping", null, parsed)) {
                dependencySet.setOutputFileNameMapping(this.interpolatedTrimmed(parser.nextText(), "outputFileNameMapping"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "unpack", null, parsed)) {
                dependencySet.setUnpack(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "unpack"), "unpack", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "unpackOptions", null, parsed)) {
                dependencySet.setUnpackOptions(this.parseUnpackOptions(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scope", null, parsed)) {
                dependencySet.setScope(this.interpolatedTrimmed(parser.nextText(), "scope"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useProjectArtifact", null, parsed)) {
                dependencySet.setUseProjectArtifact(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "useProjectArtifact"), "useProjectArtifact", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useProjectAttachments", null, parsed)) {
                dependencySet.setUseProjectAttachments(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "useProjectAttachments"), "useProjectAttachments", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useTransitiveDependencies", null, parsed)) {
                dependencySet.setUseTransitiveDependencies(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "useTransitiveDependencies"), "useTransitiveDependencies", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useTransitiveFiltering", null, parsed)) {
                dependencySet.setUseTransitiveFiltering(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "useTransitiveFiltering"), "useTransitiveFiltering", parser, "false"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return dependencySet;
    }

    private FileItem parseFileItem(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        FileItem fileItem = new FileItem();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "source", null, parsed)) {
                fileItem.setSource(this.interpolatedTrimmed(parser.nextText(), "source"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                fileItem.setOutputDirectory(this.interpolatedTrimmed(parser.nextText(), "outputDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "destName", null, parsed)) {
                fileItem.setDestName(this.interpolatedTrimmed(parser.nextText(), "destName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                fileItem.setFileMode(this.interpolatedTrimmed(parser.nextText(), "fileMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lineEnding", null, parsed)) {
                fileItem.setLineEnding(this.interpolatedTrimmed(parser.nextText(), "lineEnding"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filtered", null, parsed)) {
                fileItem.setFiltered(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "filtered"), "filtered", parser, "false"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return fileItem;
    }

    private FileSet parseFileSet(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        FileSet fileSet = new FileSet();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "useDefaultExcludes", null, parsed)) {
                fileSet.setUseDefaultExcludes(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "useDefaultExcludes"), "useDefaultExcludes", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                fileSet.setOutputDirectory(this.interpolatedTrimmed(parser.nextText(), "outputDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                fileSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        includes.add(this.interpolatedTrimmed(parser.nextText(), "includes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                fileSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                fileSet.setFileMode(this.interpolatedTrimmed(parser.nextText(), "fileMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryMode", null, parsed)) {
                fileSet.setDirectoryMode(this.interpolatedTrimmed(parser.nextText(), "directoryMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directory", null, parsed)) {
                fileSet.setDirectory(this.interpolatedTrimmed(parser.nextText(), "directory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lineEnding", null, parsed)) {
                fileSet.setLineEnding(this.interpolatedTrimmed(parser.nextText(), "lineEnding"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filtered", null, parsed)) {
                fileSet.setFiltered(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "filtered"), "filtered", parser, "false"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return fileSet;
    }

    private GroupVersionAlignment parseGroupVersionAlignment(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        GroupVersionAlignment groupVersionAlignment = new GroupVersionAlignment();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                groupVersionAlignment.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                groupVersionAlignment.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                groupVersionAlignment.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return groupVersionAlignment;
    }

    private ModuleBinaries parseModuleBinaries(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ModuleBinaries moduleBinaries = new ModuleBinaries();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                moduleBinaries.setOutputDirectory(this.interpolatedTrimmed(parser.nextText(), "outputDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                moduleBinaries.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        includes.add(this.interpolatedTrimmed(parser.nextText(), "includes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                moduleBinaries.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                moduleBinaries.setFileMode(this.interpolatedTrimmed(parser.nextText(), "fileMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryMode", null, parsed)) {
                moduleBinaries.setDirectoryMode(this.interpolatedTrimmed(parser.nextText(), "directoryMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "attachmentClassifier", null, parsed)) {
                moduleBinaries.setAttachmentClassifier(this.interpolatedTrimmed(parser.nextText(), "attachmentClassifier"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includeDependencies", null, parsed)) {
                moduleBinaries.setIncludeDependencies(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "includeDependencies"), "includeDependencies", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencySets", null, parsed)) {
                ArrayList<DependencySet> dependencySets = new ArrayList<DependencySet>();
                moduleBinaries.setDependencySets(dependencySets);
                while (parser.nextTag() == 2) {
                    if ("dependencySet".equals(parser.getName())) {
                        dependencySets.add(this.parseDependencySet(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "unpack", null, parsed)) {
                moduleBinaries.setUnpack(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "unpack"), "unpack", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "unpackOptions", null, parsed)) {
                moduleBinaries.setUnpackOptions(this.parseUnpackOptions(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputFileNameMapping", null, parsed)) {
                moduleBinaries.setOutputFileNameMapping(this.interpolatedTrimmed(parser.nextText(), "outputFileNameMapping"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return moduleBinaries;
    }

    private ModuleSet parseModuleSet(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ModuleSet moduleSet = new ModuleSet();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "useAllReactorProjects", null, parsed)) {
                moduleSet.setUseAllReactorProjects(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "useAllReactorProjects"), "useAllReactorProjects", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includeSubModules", null, parsed)) {
                moduleSet.setIncludeSubModules(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "includeSubModules"), "includeSubModules", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                moduleSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        includes.add(this.interpolatedTrimmed(parser.nextText(), "includes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                moduleSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "sources", null, parsed)) {
                moduleSet.setSources(this.parseModuleSources(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "binaries", null, parsed)) {
                moduleSet.setBinaries(this.parseModuleBinaries(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return moduleSet;
    }

    private ModuleSources parseModuleSources(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ModuleSources moduleSources = new ModuleSources();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "useDefaultExcludes", null, parsed)) {
                moduleSources.setUseDefaultExcludes(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "useDefaultExcludes"), "useDefaultExcludes", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                moduleSources.setOutputDirectory(this.interpolatedTrimmed(parser.nextText(), "outputDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                moduleSources.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        includes.add(this.interpolatedTrimmed(parser.nextText(), "includes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                moduleSources.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                moduleSources.setFileMode(this.interpolatedTrimmed(parser.nextText(), "fileMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryMode", null, parsed)) {
                moduleSources.setDirectoryMode(this.interpolatedTrimmed(parser.nextText(), "directoryMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileSets", null, parsed)) {
                ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
                moduleSources.setFileSets(fileSets);
                while (parser.nextTag() == 2) {
                    if ("fileSet".equals(parser.getName())) {
                        fileSets.add(this.parseFileSet(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includeModuleDirectory", null, parsed)) {
                moduleSources.setIncludeModuleDirectory(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "includeModuleDirectory"), "includeModuleDirectory", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludeSubModuleDirectories", null, parsed)) {
                moduleSources.setExcludeSubModuleDirectories(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "excludeSubModuleDirectories"), "excludeSubModuleDirectories", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectoryMapping", null, parsed)) {
                moduleSources.setOutputDirectoryMapping(this.interpolatedTrimmed(parser.nextText(), "outputDirectoryMapping"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return moduleSources;
    }

    private Repository parseRepository(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Repository repository = new Repository();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                repository.setOutputDirectory(this.interpolatedTrimmed(parser.nextText(), "outputDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                repository.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        includes.add(this.interpolatedTrimmed(parser.nextText(), "includes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                repository.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                repository.setFileMode(this.interpolatedTrimmed(parser.nextText(), "fileMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryMode", null, parsed)) {
                repository.setDirectoryMode(this.interpolatedTrimmed(parser.nextText(), "directoryMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includeMetadata", null, parsed)) {
                repository.setIncludeMetadata(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "includeMetadata"), "includeMetadata", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "groupVersionAlignments", null, parsed)) {
                ArrayList<GroupVersionAlignment> groupVersionAlignments = new ArrayList<GroupVersionAlignment>();
                repository.setGroupVersionAlignments(groupVersionAlignments);
                while (parser.nextTag() == 2) {
                    if ("groupVersionAlignment".equals(parser.getName())) {
                        groupVersionAlignments.add(this.parseGroupVersionAlignment(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scope", null, parsed)) {
                repository.setScope(this.interpolatedTrimmed(parser.nextText(), "scope"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return repository;
    }

    private UnpackOptions parseUnpackOptions(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        UnpackOptions unpackOptions = new UnpackOptions();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                unpackOptions.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        includes.add(this.interpolatedTrimmed(parser.nextText(), "includes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                unpackOptions.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filtered", null, parsed)) {
                unpackOptions.setFiltered(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "filtered"), "filtered", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lineEnding", null, parsed)) {
                unpackOptions.setLineEnding(this.interpolatedTrimmed(parser.nextText(), "lineEnding"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useDefaultExcludes", null, parsed)) {
                unpackOptions.setUseDefaultExcludes(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "useDefaultExcludes"), "useDefaultExcludes", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "encoding", null, parsed)) {
                unpackOptions.setEncoding(this.interpolatedTrimmed(parser.nextText(), "encoding"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return unpackOptions;
    }

    private Assembly read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"assembly".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'assembly' but found '" + parser.getName() + "'", parser, null);
                }
                Assembly assembly = this.parseAssembly(parser, strict);
                assembly.setModelEncoding(parser.getInputEncoding());
                return assembly;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException("Expected root element 'assembly' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

