/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ClassAnalyzer;
import org.apache.maven.shared.dependency.analyzer.DependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ProjectDependencyAnalyzer.class)
public class DefaultProjectDependencyAnalyzer
implements ProjectDependencyAnalyzer {
    @Requirement
    private ClassAnalyzer classAnalyzer;
    @Requirement
    private DependencyAnalyzer dependencyAnalyzer;

    @Override
    public ProjectDependencyAnalysis analyze(MavenProject project) throws ProjectDependencyAnalyzerException {
        try {
            Map<Artifact, Set<String>> artifactClassMap = this.buildArtifactClassMap(project);
            Set<String> dependencyClasses = this.buildDependencyClasses(project);
            Set<String> mainDependencyClasses = this.buildMainDependencyClasses(project);
            Set<String> testOnlyDependencyClasses = this.buildTestDependencyClasses(project);
            Set<Artifact> declaredArtifacts = this.buildDeclaredArtifacts(project);
            Map<Artifact, Set<String>> usedArtifacts = this.buildUsedArtifacts(artifactClassMap, dependencyClasses);
            Set<Artifact> mainUsedArtifacts = this.buildUsedArtifacts(artifactClassMap, mainDependencyClasses).keySet();
            Set<Artifact> testArtifacts = this.buildUsedArtifacts(artifactClassMap, testOnlyDependencyClasses).keySet();
            Set<Artifact> testOnlyArtifacts = this.removeAll(testArtifacts, mainUsedArtifacts);
            LinkedHashSet<Artifact> usedDeclaredArtifacts = new LinkedHashSet<Artifact>(declaredArtifacts);
            usedDeclaredArtifacts.retainAll(usedArtifacts.keySet());
            LinkedHashMap<Artifact, Set<String>> usedUndeclaredArtifactsWithClasses = new LinkedHashMap<Artifact, Set<String>>(usedArtifacts);
            Set<Artifact> usedUndeclaredArtifacts = this.removeAll(usedUndeclaredArtifactsWithClasses.keySet(), declaredArtifacts);
            usedUndeclaredArtifactsWithClasses.keySet().retainAll(usedUndeclaredArtifacts);
            Set<Artifact> unusedDeclaredArtifacts = new LinkedHashSet<Artifact>(declaredArtifacts);
            unusedDeclaredArtifacts = this.removeAll(unusedDeclaredArtifacts, usedArtifacts.keySet());
            Set<Artifact> testArtifactsWithNonTestScope = this.getTestArtifactsWithNonTestScope(testOnlyArtifacts);
            return new ProjectDependencyAnalysis(usedDeclaredArtifacts, usedUndeclaredArtifactsWithClasses, unusedDeclaredArtifacts, testArtifactsWithNonTestScope);
        }
        catch (IOException exception) {
            throw new ProjectDependencyAnalyzerException("Cannot analyze dependencies", exception);
        }
    }

    private Set<Artifact> removeAll(Set<Artifact> start, Set<Artifact> remove) {
        LinkedHashSet<Artifact> results = new LinkedHashSet<Artifact>(start.size());
        for (Artifact artifact : start) {
            boolean found = false;
            for (Artifact artifact2 : remove) {
                if (!artifact.getDependencyConflictId().equals(artifact2.getDependencyConflictId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            results.add(artifact);
        }
        return results;
    }

    private Set<Artifact> getTestArtifactsWithNonTestScope(Set<Artifact> testOnlyArtifacts) {
        LinkedHashSet<Artifact> nonTestScopeArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : testOnlyArtifacts) {
            if (!artifact.getScope().equals("compile")) continue;
            nonTestScopeArtifacts.add(artifact);
        }
        return nonTestScopeArtifacts;
    }

    private Map<Artifact, Set<String>> buildArtifactClassMap(MavenProject project) throws IOException {
        LinkedHashMap<Artifact, Set<String>> artifactClassMap = new LinkedHashMap<Artifact, Set<String>>();
        Set dependencyArtifacts = project.getArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            File file = artifact.getFile();
            if (file != null && file.getName().endsWith(".jar")) {
                JarFile jarFile = new JarFile(file);
                Throwable throwable = null;
                try {
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    HashSet<String> classes = new HashSet<String>();
                    while (jarEntries.hasMoreElements()) {
                        String entry = jarEntries.nextElement().getName();
                        if (!entry.endsWith(".class")) continue;
                        String className = entry.replace('/', '.');
                        className = className.substring(0, className.length() - ".class".length());
                        classes.add(className);
                    }
                    artifactClassMap.put(artifact, classes);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jarFile.close();
                    continue;
                }
            }
            if (file == null || !file.isDirectory()) continue;
            URL url = file.toURI().toURL();
            Set<String> classes = this.classAnalyzer.analyze(url);
            artifactClassMap.put(artifact, classes);
        }
        return artifactClassMap;
    }

    private Set<String> buildTestDependencyClasses(MavenProject project) throws IOException {
        HashSet<String> testOnlyDependencyClasses = new HashSet<String>();
        String outputDirectory = project.getBuild().getOutputDirectory();
        HashSet<String> nonTestDependencyClasses = new HashSet<String>(this.buildDependencyClasses(outputDirectory));
        String testOutputDirectory = project.getBuild().getTestOutputDirectory();
        HashSet<String> testDependencyClasses = new HashSet<String>(this.buildDependencyClasses(testOutputDirectory));
        for (String testString : testDependencyClasses) {
            if (nonTestDependencyClasses.contains(testString)) continue;
            testOnlyDependencyClasses.add(testString);
        }
        return testOnlyDependencyClasses;
    }

    private Set<String> buildDependencyClasses(MavenProject project) throws IOException {
        String outputDirectory = project.getBuild().getOutputDirectory();
        HashSet<String> dependencyClasses = new HashSet<String>(this.buildDependencyClasses(outputDirectory));
        String testOutputDirectory = project.getBuild().getTestOutputDirectory();
        dependencyClasses.addAll(this.buildDependencyClasses(testOutputDirectory));
        return dependencyClasses;
    }

    private Set<String> buildMainDependencyClasses(MavenProject project) throws IOException {
        String outputDirectory = project.getBuild().getOutputDirectory();
        HashSet<String> dependencyClasses = new HashSet<String>(this.buildDependencyClasses(outputDirectory));
        return dependencyClasses;
    }

    private Set<String> buildDependencyClasses(String path) throws IOException {
        URL url = new File(path).toURI().toURL();
        return this.dependencyAnalyzer.analyze(url);
    }

    private Set<Artifact> buildDeclaredArtifacts(MavenProject project) {
        Set<Artifact> declaredArtifacts = project.getDependencyArtifacts();
        if (declaredArtifacts == null) {
            declaredArtifacts = Collections.emptySet();
        }
        return declaredArtifacts;
    }

    private Map<Artifact, Set<String>> buildUsedArtifacts(Map<Artifact, Set<String>> artifactClassMap, Set<String> dependencyClasses) {
        HashMap<Artifact, Set<String>> usedArtifacts = new HashMap<Artifact, Set<String>>();
        for (String className : dependencyClasses) {
            Artifact artifact = this.findArtifactForClassName(artifactClassMap, className);
            if (artifact == null) continue;
            HashSet<String> classesFromArtifact = (HashSet<String>)usedArtifacts.get(artifact);
            if (classesFromArtifact == null) {
                classesFromArtifact = new HashSet<String>();
                usedArtifacts.put(artifact, classesFromArtifact);
            }
            classesFromArtifact.add(className);
        }
        return usedArtifacts;
    }

    private Artifact findArtifactForClassName(Map<Artifact, Set<String>> artifactClassMap, String className) {
        for (Map.Entry<Artifact, Set<String>> entry : artifactClassMap.entrySet()) {
            if (!entry.getValue().contains(className)) continue;
            return entry.getKey();
        }
        return null;
    }
}

