/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.maven.surefire.testset.TestSetFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestsToRun
implements Iterable<Class<?>> {
    private final Set<Class<?>> locatedClasses;
    private volatile boolean finished;

    public TestsToRun(Set<Class<?>> locatedClasses) {
        this.locatedClasses = Collections.unmodifiableSet(locatedClasses);
    }

    public static TestsToRun fromClass(Class<?> clazz) throws TestSetFailedException {
        return new TestsToRun(Collections.singleton(clazz));
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return new ClassesIterator();
    }

    public final void markTestSetFinished() {
        this.finished = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TestsToRun: [");
        for (Class<?> clazz : this) {
            sb.append(" ").append(clazz.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean containsAtLeast(int atLeast) {
        return this.containsAtLeast(this.iterator(), atLeast);
    }

    private boolean containsAtLeast(Iterator<Class<?>> it, int atLeast) {
        for (int i = 0; i < atLeast; ++i) {
            if (!it.hasNext()) {
                return false;
            }
            it.next();
        }
        return true;
    }

    public boolean containsExactly(int items) {
        Iterator<Class<?>> it = this.iterator();
        return this.containsAtLeast(it, items) && !it.hasNext();
    }

    public boolean allowEagerReading() {
        return true;
    }

    public Class<?>[] getLocatedClasses() {
        if (!this.allowEagerReading()) {
            throw new IllegalStateException("Cannot eagerly read");
        }
        ArrayList result = new ArrayList();
        for (Class<?> clazz : this) {
            result.add(clazz);
        }
        return result.toArray(new Class[result.size()]);
    }

    public Class<?> getClassByName(String className) {
        for (Class<?> clazz : this) {
            if (!clazz.getName().equals(className)) continue;
            return clazz;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassesIterator
    implements Iterator<Class<?>> {
        private final Iterator<Class<?>> it;
        private Boolean finishCurrentIteration;

        private ClassesIterator() {
            this.it = TestsToRun.this.locatedClasses.iterator();
        }

        @Override
        public boolean hasNext() {
            this.popMarker();
            return this.finishCurrentIteration == false && this.it.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> next() {
            try {
                if (this.popMarker() && this.finishCurrentIteration.booleanValue()) {
                    throw new NoSuchElementException();
                }
                Class<?> clazz = this.it.next();
                return clazz;
            }
            finally {
                this.finishCurrentIteration = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean popMarker() {
            if (this.finishCurrentIteration == null) {
                this.finishCurrentIteration = TestsToRun.this.finished;
                return true;
            }
            return false;
        }
    }
}

