/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.surefire.Surefire;
import org.apache.maven.surefire.booter.Commandline;
import org.apache.maven.surefire.booter.ForkConfiguration;
import org.apache.maven.surefire.booter.IsolatedClassLoader;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.output.FileOutputConsumerProxy;
import org.apache.maven.surefire.booter.output.ForkingStreamConsumer;
import org.apache.maven.surefire.booter.output.OutputConsumer;
import org.apache.maven.surefire.booter.output.StandardOutputConsumer;
import org.apache.maven.surefire.booter.output.SupressFooterOutputConsumerProxy;
import org.apache.maven.surefire.booter.output.SupressHeaderOutputConsumerProxy;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.apache.maven.surefire.util.UrlUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SurefireBooter {
    private List reports = new ArrayList();
    private List classPathUrls = new ArrayList();
    private List surefireClassPathUrls = new ArrayList();
    private List surefireBootClassPathUrls = new ArrayList();
    private List testSuites = new ArrayList();
    private boolean redirectTestOutputToFile = false;
    private boolean useSystemClassLoader = false;
    private ForkConfiguration forkConfiguration;
    private static final int TESTS_SUCCEEDED_EXIT_CODE = 0;
    private static final int TESTS_FAILED_EXIT_CODE = 255;
    private static Method assertionStatusMethod;
    private boolean childDelegation = true;
    private File reportsDirectory;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$apache$maven$surefire$Surefire;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;

    public void addReport(String report) {
        this.addReport(report, null);
    }

    public void addReport(String report, Object[] constructorParams) {
        this.reports.add(new Object[]{report, constructorParams});
    }

    public void addTestSuite(String suiteClassName, Object[] constructorParams) {
        this.testSuites.add(new Object[]{suiteClassName, constructorParams});
    }

    public void addClassPathUrl(String path) {
        if (!this.classPathUrls.contains(path)) {
            this.classPathUrls.add(path);
        }
    }

    public void addSurefireClassPathUrl(String path) {
        if (!this.surefireClassPathUrls.contains(path)) {
            this.surefireClassPathUrls.add(path);
        }
    }

    public void addSurefireBootClassPathUrl(String path) {
        if (!this.surefireBootClassPathUrls.contains(path)) {
            this.surefireBootClassPathUrls.add(path);
        }
    }

    public void setRedirectTestOutputToFile(boolean redirectTestOutputToFile) {
        this.redirectTestOutputToFile = redirectTestOutputToFile;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setForkConfiguration(ForkConfiguration forkConfiguration) {
        this.forkConfiguration = forkConfiguration;
    }

    public void setUseSystemClassLoader(boolean useSystemClassLoader) {
        this.useSystemClassLoader = useSystemClassLoader;
    }

    public boolean run() throws SurefireBooterForkException, SurefireExecutionException {
        boolean result = false;
        if ("never".equals(this.forkConfiguration.getForkMode())) {
            result = this.runSuitesInProcess();
        } else if ("once".equals(this.forkConfiguration.getForkMode())) {
            result = this.runSuitesForkOnce();
        } else if ("always".equals(this.forkConfiguration.getForkMode())) {
            result = this.runSuitesForkPerTestSet();
        } else {
            throw new SurefireExecutionException("Unknown forkmode: " + this.forkConfiguration.getForkMode(), null);
        }
        return result;
    }

    private boolean runSuitesInProcess(String testSet, Properties results) throws SurefireExecutionException {
        if (this.testSuites.size() != 1) {
            throw new IllegalArgumentException("Cannot only specify testSet for single test suites");
        }
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader testsClassLoader = this.useSystemClassLoader ? ClassLoader.getSystemClassLoader() : SurefireBooter.createClassLoader(this.classPathUrls, null, this.childDelegation, true);
            ClassLoader surefireClassLoader = SurefireBooter.createClassLoader(this.surefireClassPathUrls, testsClassLoader, true);
            Class<?> surefireClass = surefireClassLoader.loadClass((class$org$apache$maven$surefire$Surefire == null ? (class$org$apache$maven$surefire$Surefire = SurefireBooter.class$("org.apache.maven.surefire.Surefire")) : class$org$apache$maven$surefire$Surefire).getName());
            Object surefire = surefireClass.newInstance();
            Method run = surefireClass.getMethod("run", class$java$util$List == null ? (class$java$util$List = SurefireBooter.class$("java.util.List")) : class$java$util$List, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = SurefireBooter.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, class$java$lang$String == null ? (class$java$lang$String = SurefireBooter.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SurefireBooter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SurefireBooter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$util$Properties == null ? (class$java$util$Properties = SurefireBooter.class$("java.util.Properties")) : class$java$util$Properties);
            Thread.currentThread().setContextClassLoader(testsClassLoader);
            Boolean result = (Boolean)run.invoke(surefire, this.reports, this.testSuites.get(0), testSet, surefireClassLoader, testsClassLoader, results);
            boolean bl = result;
            return bl;
        }
        catch (InvocationTargetException e) {
            throw new SurefireExecutionException(e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (Exception e) {
            throw new SurefireExecutionException("Unable to instantiate and execute Surefire", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private boolean runSuitesInProcess() throws SurefireExecutionException {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader testsClassLoader = this.useSystemClassLoader ? this.getClass().getClassLoader() : SurefireBooter.createClassLoader(this.classPathUrls, null, this.childDelegation, true);
            ClassLoader surefireClassLoader = SurefireBooter.createClassLoader(this.surefireClassPathUrls, testsClassLoader, true);
            Class<?> surefireClass = surefireClassLoader.loadClass((class$org$apache$maven$surefire$Surefire == null ? (class$org$apache$maven$surefire$Surefire = SurefireBooter.class$("org.apache.maven.surefire.Surefire")) : class$org$apache$maven$surefire$Surefire).getName());
            Object surefire = surefireClass.newInstance();
            Method run = surefireClass.getMethod("run", class$java$util$List == null ? (class$java$util$List = SurefireBooter.class$("java.util.List")) : class$java$util$List, class$java$util$List == null ? (class$java$util$List = SurefireBooter.class$("java.util.List")) : class$java$util$List, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SurefireBooter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SurefireBooter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            Thread.currentThread().setContextClassLoader(testsClassLoader);
            Boolean result = (Boolean)run.invoke(surefire, this.reports, this.testSuites, surefireClassLoader, testsClassLoader);
            boolean bl = result;
            return bl;
        }
        catch (InvocationTargetException e) {
            throw new SurefireExecutionException(e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (Exception e) {
            throw new SurefireExecutionException("Unable to instantiate and execute Surefire", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private boolean runSuitesForkOnce() throws SurefireBooterForkException {
        return this.forkSuites(this.testSuites, true, true);
    }

    private boolean runSuitesForkPerTestSet() throws SurefireBooterForkException {
        ClassLoader surefireClassLoader;
        ClassLoader testsClassLoader;
        try {
            testsClassLoader = SurefireBooter.createClassLoader(this.classPathUrls, null, false, true);
            surefireClassLoader = SurefireBooter.createClassLoader(this.surefireClassPathUrls, testsClassLoader, false, true);
        }
        catch (MalformedURLException e) {
            throw new SurefireBooterForkException("Unable to create classloader to find test suites", e);
        }
        boolean failed = false;
        boolean showHeading = true;
        Properties properties = new Properties();
        Iterator i = this.testSuites.iterator();
        while (i.hasNext()) {
            Object[] testSuite = (Object[])i.next();
            Map testSets = this.getTestSets(testSuite, testsClassLoader, surefireClassLoader);
            Iterator j = testSets.keySet().iterator();
            while (j.hasNext()) {
                boolean showFooter;
                String testSet = (String)j.next();
                boolean result = this.forkSuite(testSuite, testSet, showHeading, showFooter = !j.hasNext() && !i.hasNext(), properties);
                if (!result) {
                    failed = true;
                }
                showHeading = false;
            }
        }
        return !failed;
    }

    private Map getTestSets(Object[] testSuite, ClassLoader testsClassLoader, ClassLoader surefireClassLoader) throws SurefireBooterForkException {
        Map testSets;
        Object suite;
        String className = (String)testSuite[0];
        Object[] params = (Object[])testSuite[1];
        try {
            suite = Surefire.instantiateObject((String)className, (Object[])params, (ClassLoader)surefireClassLoader);
        }
        catch (TestSetFailedException e) {
            throw new SurefireBooterForkException(e.getMessage(), e.getCause());
        }
        catch (ClassNotFoundException e) {
            throw new SurefireBooterForkException("Unable to find class for test suite '" + className + "'", e);
        }
        catch (NoSuchMethodException e) {
            throw new SurefireBooterForkException("Unable to find appropriate constructor for test suite '" + className + "': " + e.getMessage(), e);
        }
        try {
            Method m = suite.getClass().getMethod("locateTestSets", class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SurefireBooter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            testSets = (Map)m.invoke(suite, testsClassLoader);
        }
        catch (IllegalAccessException e) {
            throw new SurefireBooterForkException("Error obtaining test sets", e);
        }
        catch (NoSuchMethodException e) {
            throw new SurefireBooterForkException("Error obtaining test sets", e);
        }
        catch (InvocationTargetException e) {
            throw new SurefireBooterForkException(e.getTargetException().getMessage(), e.getTargetException());
        }
        return testSets;
    }

    private boolean forkSuites(List testSuites, boolean showHeading, boolean showFooter) throws SurefireBooterForkException {
        Properties properties = new Properties();
        this.setForkProperties(testSuites, properties);
        return this.fork(properties, showHeading, showFooter);
    }

    private boolean forkSuite(Object[] testSuite, String testSet, boolean showHeading, boolean showFooter, Properties properties) throws SurefireBooterForkException {
        this.setForkProperties(Collections.singletonList(testSuite), properties);
        properties.setProperty("testSet", testSet);
        return this.fork(properties, showHeading, showFooter);
    }

    private void setForkProperties(List testSuites, Properties properties) {
        String url;
        int i;
        this.addPropertiesForTypeHolder(this.reports, properties, "report.");
        this.addPropertiesForTypeHolder(testSuites, properties, "testSuite.");
        for (i = 0; i < this.classPathUrls.size() && !this.useSystemClassLoader; ++i) {
            url = (String)this.classPathUrls.get(i);
            properties.setProperty("classPathUrl." + i, url);
        }
        for (i = 0; i < this.surefireClassPathUrls.size(); ++i) {
            url = (String)this.surefireClassPathUrls.get(i);
            properties.setProperty("surefireClassPathUrl." + i, url);
        }
        properties.setProperty("childDelegation", String.valueOf(this.childDelegation));
        properties.setProperty("useSystemClassLoader", String.valueOf(this.useSystemClassLoader));
    }

    private File writePropertiesFile(String name, Properties properties) throws IOException {
        File file = File.createTempFile(name, "tmp");
        file.deleteOnExit();
        this.writePropertiesFile(file, name, properties);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertiesFile(File file, String name, Properties properties) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            properties.store(out, name);
        }
        finally {
            IOUtil.close((OutputStream)out);
        }
    }

    private void addPropertiesForTypeHolder(List typeHolderList, Properties properties, String propertyPrefix) {
        for (int i = 0; i < typeHolderList.size(); ++i) {
            Object[] report = (Object[])typeHolderList.get(i);
            String className = (String)report[0];
            Object[] params = (Object[])report[1];
            properties.setProperty(propertyPrefix + i, className);
            if (params == null) continue;
            String paramProperty = params[0].toString();
            String typeProperty = params[0].getClass().getName();
            for (int j = 1; j < params.length; ++j) {
                paramProperty = paramProperty + "|";
                typeProperty = typeProperty + "|";
                if (params[j] == null) continue;
                paramProperty = paramProperty + params[j].toString();
                typeProperty = typeProperty + params[j].getClass().getName();
            }
            properties.setProperty(propertyPrefix + i + ".params", paramProperty);
            properties.setProperty(propertyPrefix + i + ".types", typeProperty);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fork(Properties properties, boolean showHeading, boolean showFooter) throws SurefireBooterForkException {
        int returnCode;
        File surefireProperties;
        File systemProperties = null;
        try {
            surefireProperties = this.writePropertiesFile("surefire", properties);
            if (this.forkConfiguration.getSystemProperties() != null) {
                systemProperties = this.writePropertiesFile("surefire", this.forkConfiguration.getSystemProperties());
            }
        }
        catch (IOException e) {
            throw new SurefireBooterForkException("Error creating properties files for forking", e);
        }
        ArrayList bootClasspath = new ArrayList(this.surefireBootClassPathUrls.size() + this.classPathUrls.size());
        bootClasspath.addAll(this.surefireBootClassPathUrls);
        if (this.useSystemClassLoader) {
            bootClasspath.addAll(this.classPathUrls);
        }
        Commandline cli = this.forkConfiguration.createCommandLine(bootClasspath, this.useSystemClassLoader);
        cli.createArgument().setFile(surefireProperties);
        if (systemProperties != null) {
            cli.createArgument().setFile(systemProperties);
        }
        StreamConsumer out = this.getForkingStreamConsumer(showHeading, showFooter, this.redirectTestOutputToFile);
        StreamConsumer err = this.getForkingStreamConsumer(showHeading, showFooter, this.redirectTestOutputToFile);
        if (this.forkConfiguration.isDebug()) {
            System.out.println("Forking command line: " + (Object)((Object)cli));
        }
        try {
            returnCode = CommandLineUtils.executeCommandLine((org.codehaus.plexus.util.cli.Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
        }
        catch (CommandLineException e) {
            throw new SurefireBooterForkException("Error while executing forked tests.", e);
        }
        if (surefireProperties != null && surefireProperties.exists()) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(surefireProperties);
                properties.load(inStream);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new SurefireBooterForkException("Unable to reload properties file from forked process", e);
                    catch (IOException e2) {
                        throw new SurefireBooterForkException("Unable to reload properties file from forked process", e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(inStream);
                    throw throwable;
                }
            }
            IOUtil.close((InputStream)inStream);
        }
        if (returnCode != 0) return false;
        return true;
    }

    private static ClassLoader createClassLoader(List classPathUrls, ClassLoader parent, boolean assertionsEnabled) throws MalformedURLException {
        return SurefireBooter.createClassLoader(classPathUrls, parent, false, assertionsEnabled);
    }

    private static ClassLoader createClassLoader(List classPathUrls, ClassLoader parent, boolean childDelegation, boolean assertionsEnabled) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator i = classPathUrls.iterator();
        while (i.hasNext()) {
            String url = (String)i.next();
            if (url == null) continue;
            File f = new File(url);
            urls.add(UrlUtils.getURL((File)f));
        }
        IsolatedClassLoader classLoader = new IsolatedClassLoader(parent, childDelegation);
        if (assertionStatusMethod != null) {
            try {
                Object[] args = new Object[]{assertionsEnabled ? Boolean.TRUE : Boolean.FALSE};
                if (parent != null) {
                    assertionStatusMethod.invoke((Object)parent, args);
                }
                assertionStatusMethod.invoke((Object)classLoader, args);
            }
            catch (IllegalAccessException e) {
                throw new NestedRuntimeException("Unable to access the assertion enablement method", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new NestedRuntimeException("Unable to invoke the assertion enablement method", (Throwable)e);
            }
        }
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            classLoader.addURL(url);
        }
        return classLoader;
    }

    private static List processStringList(String stringList) {
        String sl = stringList;
        if (sl.startsWith("[") && sl.endsWith("]")) {
            sl = sl.substring(1, sl.length() - 1);
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = StringUtils.split((String)sl, (String)",");
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(stringArray[i].trim());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File file) throws IOException {
        Properties p = new Properties();
        if (file != null && file.exists()) {
            FileInputStream inStream = new FileInputStream(file);
            try {
                p.load(inStream);
            }
            finally {
                IOUtil.close((InputStream)inStream);
            }
        }
        return p;
    }

    private static void setSystemProperties(File file) throws IOException {
        Properties p = SurefireBooter.loadProperties(file);
        Iterator<Object> i = p.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            System.setProperty(key, p.getProperty(key));
        }
    }

    private static Object[] constructParamObjects(String paramProperty, String typeProperty) {
        Object[] paramObjects = null;
        if (paramProperty != null) {
            String[] params = StringUtils.split((String)StringUtils.replace((String)StringUtils.replace((String)paramProperty, (String)"||", (String)"| |"), (String)"||", (String)"| |"), (String)"|");
            String[] types = StringUtils.split((String)StringUtils.replace((String)StringUtils.replace((String)typeProperty, (String)"||", (String)"| |"), (String)"||", (String)"| |"), (String)"|");
            paramObjects = new Object[params.length];
            for (int i = 0; i < types.length; ++i) {
                if (types[i].trim().length() == 0) {
                    params[i] = null;
                    continue;
                }
                if (types[i].equals((class$java$lang$String == null ? SurefireBooter.class$("java.lang.String") : class$java$lang$String).getName())) {
                    paramObjects[i] = params[i];
                    continue;
                }
                if (types[i].equals((class$java$io$File == null ? SurefireBooter.class$("java.io.File") : class$java$io$File).getName())) {
                    paramObjects[i] = new File(params[i]);
                    continue;
                }
                if (types[i].equals((class$java$util$ArrayList == null ? SurefireBooter.class$("java.util.ArrayList") : class$java$util$ArrayList).getName())) {
                    paramObjects[i] = SurefireBooter.processStringList(params[i]);
                    continue;
                }
                if (types[i].equals((class$java$lang$Boolean == null ? SurefireBooter.class$("java.lang.Boolean") : class$java$lang$Boolean).getName())) {
                    paramObjects[i] = Boolean.valueOf(params[i]);
                    continue;
                }
                if (types[i].equals((class$java$lang$Integer == null ? SurefireBooter.class$("java.lang.Integer") : class$java$lang$Integer).getName())) {
                    paramObjects[i] = Integer.valueOf(params[i]);
                    continue;
                }
                throw new IllegalArgumentException("Unknown parameter type: " + types[i]);
            }
        }
        return paramObjects;
    }

    public static void main(String[] args) throws Throwable {
        try {
            if (args.length > 1) {
                SurefireBooter.setSystemProperties(new File(args[1]));
            }
            File surefirePropertiesFile = new File(args[0]);
            Properties p = SurefireBooter.loadProperties(surefirePropertiesFile);
            SurefireBooter surefireBooter = new SurefireBooter();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String types;
                String params;
                String className;
                String name = (String)e.nextElement();
                if (name.startsWith("report.") && !name.endsWith(".params") && !name.endsWith(".types")) {
                    className = p.getProperty(name);
                    params = p.getProperty(name + ".params");
                    types = p.getProperty(name + ".types");
                    surefireBooter.addReport(className, SurefireBooter.constructParamObjects(params, types));
                    continue;
                }
                if (name.startsWith("testSuite.") && !name.endsWith(".params") && !name.endsWith(".types")) {
                    className = p.getProperty(name);
                    params = p.getProperty(name + ".params");
                    types = p.getProperty(name + ".types");
                    surefireBooter.addTestSuite(className, SurefireBooter.constructParamObjects(params, types));
                    continue;
                }
                if (name.startsWith("classPathUrl.")) {
                    surefireBooter.addClassPathUrl(p.getProperty(name));
                    continue;
                }
                if (name.startsWith("surefireClassPathUrl.")) {
                    surefireBooter.addSurefireClassPathUrl(p.getProperty(name));
                    continue;
                }
                if (name.startsWith("surefireBootClassPathUrl.")) {
                    surefireBooter.addSurefireBootClassPathUrl(p.getProperty(name));
                    continue;
                }
                if ("childDelegation".equals(name)) {
                    surefireBooter.childDelegation = Boolean.valueOf(p.getProperty("childDelegation"));
                    continue;
                }
                if (!"useSystemClassLoader".equals(name)) continue;
                surefireBooter.useSystemClassLoader = Boolean.valueOf(p.getProperty("useSystemClassLoader"));
            }
            String testSet = p.getProperty("testSet");
            boolean result = testSet != null ? surefireBooter.runSuitesInProcess(testSet, p) : surefireBooter.runSuitesInProcess();
            surefireBooter.writePropertiesFile(surefirePropertiesFile, "surefire", p);
            System.exit(result ? 0 : 255);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void setChildDelegation(boolean childDelegation) {
        this.childDelegation = childDelegation;
    }

    private StreamConsumer getForkingStreamConsumer(boolean showHeading, boolean showFooter, boolean redirectTestOutputToFile) {
        OutputConsumer outputConsumer = new StandardOutputConsumer();
        if (redirectTestOutputToFile) {
            outputConsumer = new FileOutputConsumerProxy(outputConsumer, this.getReportsDirectory());
        }
        if (!showHeading) {
            outputConsumer = new SupressHeaderOutputConsumerProxy(outputConsumer);
        }
        if (!showFooter) {
            outputConsumer = new SupressFooterOutputConsumerProxy(outputConsumer);
        }
        return new ForkingStreamConsumer(outputConsumer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            assertionStatusMethod = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SurefireBooter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getMethod("setDefaultAssertionStatus", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            assertionStatusMethod = null;
        }
    }
}

