/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.configurator;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.inject.spi.configurator.BeanConfigurator;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Named;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.GenericsUtil;

public class BeanConfiguratorImpl<T>
implements BeanConfigurator<T> {
    private final WebBeansContext webBeansContext;
    private Class<?> beanClass;
    private String passivationId;
    private Class<? extends Annotation> scope = Dependent.class;
    private String name;
    private boolean alternative;
    private Set<Type> typeClosures = new LinkedHashSet<Type>();
    private Set<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();
    private Set<Annotation> qualifiers = new HashSet<Annotation>();
    private Set<Class<? extends Annotation>> stereotypes = new HashSet<Class<? extends Annotation>>();
    private Function<CreationalContext<?>, ?> createWithCallback;
    private BiConsumer<T, CreationalContext<T>> destroyWithCallback;
    private Function<Instance<Object>, ? extends T> produceWithCallback;
    private BiConsumer<T, Instance<Object>> disposeWithCallback;

    public BeanConfiguratorImpl(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public BeanConfigurator<T> beanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    public BeanConfigurator<T> addInjectionPoint(InjectionPoint injectionPoint) {
        this.injectionPoints.add(injectionPoint);
        return this;
    }

    public BeanConfigurator<T> addInjectionPoints(InjectionPoint ... injectionPoints) {
        this.injectionPoints.addAll(Arrays.asList(injectionPoints));
        return this;
    }

    public BeanConfigurator<T> addInjectionPoints(Set<InjectionPoint> injectionPoints) {
        this.injectionPoints.addAll(injectionPoints);
        return this;
    }

    public BeanConfigurator<T> injectionPoints(InjectionPoint ... injectionPoints) {
        this.injectionPoints.clear();
        this.addInjectionPoints(injectionPoints);
        return this;
    }

    public BeanConfigurator<T> injectionPoints(Set<InjectionPoint> injectionPoints) {
        this.injectionPoints.clear();
        this.addInjectionPoints(injectionPoints);
        return this;
    }

    public BeanConfigurator<T> id(String id) {
        this.passivationId = id;
        return this;
    }

    public <U extends T> BeanConfigurator<U> createWith(Function<CreationalContext<U>, U> callback) {
        this.createWithCallback = callback;
        return this;
    }

    public <U extends T> BeanConfigurator<U> produceWith(Function<Instance<Object>, U> callback) {
        this.produceWithCallback = callback;
        return this;
    }

    public BeanConfigurator<T> destroyWith(BiConsumer<T, CreationalContext<T>> callback) {
        this.destroyWithCallback = callback;
        return this;
    }

    public BeanConfigurator<T> disposeWith(BiConsumer<T, Instance<Object>> callback) {
        this.disposeWithCallback = callback;
        return this;
    }

    public <U extends T> BeanConfigurator<U> read(AnnotatedType<U> type) {
        this.read(BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(type).build());
        return this;
    }

    public BeanConfigurator<T> read(BeanAttributes<?> beanAttributes) {
        this.stereotypes.addAll(beanAttributes.getStereotypes());
        this.scope = beanAttributes.getScope();
        this.name = beanAttributes.getName();
        this.alternative = beanAttributes.isAlternative();
        this.types(beanAttributes.getTypes());
        this.qualifiers(beanAttributes.getQualifiers());
        this.stereotypes(beanAttributes.getStereotypes());
        return this;
    }

    public BeanConfigurator<T> addType(Type type) {
        this.typeClosures.add(type);
        return this;
    }

    public BeanConfigurator<T> addType(TypeLiteral<?> typeLiteral) {
        this.typeClosures.add(typeLiteral.getType());
        return this;
    }

    public BeanConfigurator<T> addTypes(Type ... types) {
        for (Type type : types) {
            this.addType(type);
        }
        return this;
    }

    public BeanConfigurator<T> addTypes(Set<Type> types) {
        for (Type type : types) {
            this.addType(type);
        }
        return this;
    }

    public BeanConfigurator<T> addTransitiveTypeClosure(Type type) {
        Set<Type> typeClosure = GenericsUtil.getTypeClosure(type, type);
        this.addTypes(typeClosure);
        return this;
    }

    public BeanConfigurator<T> types(Type ... types) {
        this.typeClosures.clear();
        this.addTypes(types);
        return this;
    }

    public BeanConfigurator<T> types(Set<Type> types) {
        this.typeClosures.clear();
        this.addTypes(types);
        return this;
    }

    public BeanConfigurator<T> scope(Class<? extends Annotation> scope) {
        this.scope = scope;
        return this;
    }

    public BeanConfigurator<T> addQualifier(Annotation qualifier) {
        this.qualifiers.add(qualifier);
        return this;
    }

    public BeanConfigurator<T> addQualifiers(Annotation ... qualifiers) {
        this.qualifiers.addAll(Arrays.asList(qualifiers));
        return this;
    }

    public BeanConfigurator<T> addQualifiers(Set<Annotation> qualifiers) {
        this.qualifiers.addAll(qualifiers);
        return this;
    }

    public BeanConfigurator<T> qualifiers(Annotation ... qualifiers) {
        this.qualifiers.clear();
        this.addQualifiers(qualifiers);
        return this;
    }

    public BeanConfigurator<T> qualifiers(Set<Annotation> qualifiers) {
        this.qualifiers.clear();
        this.addQualifiers(qualifiers);
        return this;
    }

    public BeanConfigurator<T> addStereotype(Class<? extends Annotation> stereotype) {
        this.stereotypes.add(stereotype);
        return this;
    }

    public BeanConfigurator<T> addStereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.stereotypes.addAll(stereotypes);
        return this;
    }

    public BeanConfigurator<T> stereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.stereotypes.clear();
        this.addStereotypes(stereotypes);
        return this;
    }

    public BeanConfigurator<T> name(String name) {
        this.name = name;
        return this;
    }

    public BeanConfigurator<T> alternative(boolean alternative) {
        this.alternative = alternative;
        return this;
    }

    public Bean<?> getBean() {
        this.updateQualifiers();
        this.setPassivationIdIfNeeded();
        return new ConstructedBean();
    }

    private void setPassivationIdIfNeeded() {
        if (!this.webBeansContext.getBeanManagerImpl().isPassivatingScope(this.scope) || this.passivationId != null) {
            return;
        }
        StringBuilder sb = new StringBuilder("CONFIGURATOR#");
        sb.append(this.beanClass != null ? this.beanClass : this.typeClosures.stream().filter(Class.class::isInstance).findFirst().filter(it -> it != Object.class).orElse((Type)((Object)Object.class))).append('#').append(this.qualifiers.stream().map(Annotation::toString).collect(Collectors.joining(",")));
        for (Annotation qualifier : this.qualifiers) {
            sb.append(qualifier.toString()).append(',');
        }
        this.passivationId = sb.toString();
    }

    private void updateQualifiers() {
        if (this.qualifiers.isEmpty()) {
            this.qualifiers.add((Annotation)((Object)DefaultLiteral.INSTANCE));
        } else if (this.qualifiers.size() == 1) {
            Class<? extends Annotation> annotationType = this.qualifiers.iterator().next().annotationType();
            if (annotationType == Named.class || annotationType == Any.class) {
                this.qualifiers.add((Annotation)((Object)DefaultLiteral.INSTANCE));
            }
        } else if (this.qualifiers.size() == 2 && this.qualifiers.stream().allMatch(it -> it.annotationType() == Named.class)) {
            this.qualifiers.add((Annotation)((Object)DefaultLiteral.INSTANCE));
        }
        if (AnnotationUtil.getAnnotation(this.qualifiers, Any.class) == null) {
            this.qualifiers.add((Annotation)((Object)AnyLiteral.INSTANCE));
        }
    }

    public class ConstructedBean
    implements OwbBean<T>,
    PassivationCapable {
        private final Class<T> returnType;
        private final boolean dependent;
        private boolean specialized;
        private boolean enabled = true;

        public ConstructedBean() {
            WebBeansConfigurationException e;
            this.returnType = BeanConfiguratorImpl.this.beanClass != null ? (Class)Class.class.cast(BeanConfiguratorImpl.this.beanClass) : (BeanConfiguratorImpl.this.typeClosures.isEmpty() ? null : (Class)Class.class.cast(BeanConfiguratorImpl.this.typeClosures.stream().filter(Class.class::isInstance).findFirst().filter(it -> it != Object.class).orElse((Type)((Object)Object.class))));
            boolean bl = this.dependent = !BeanConfiguratorImpl.this.webBeansContext.getBeanManagerImpl().isNormalScope(BeanConfiguratorImpl.this.scope);
            if (BeanConfiguratorImpl.this.createWithCallback == null && BeanConfiguratorImpl.this.produceWithCallback == null) {
                e = new WebBeansConfigurationException("Either a createCallback or a produceCallback must be set " + this.toString());
                BeanConfiguratorImpl.this.webBeansContext.getBeanManagerImpl().getErrorStack().pushError((Throwable)((Object)e));
            }
            if (BeanConfiguratorImpl.this.createWithCallback != null && BeanConfiguratorImpl.this.produceWithCallback != null) {
                e = new WebBeansConfigurationException("Only exactly one of createCallback and produceCallback must be set " + this.toString());
                BeanConfiguratorImpl.this.webBeansContext.getBeanManagerImpl().getErrorStack().pushError((Throwable)((Object)e));
            }
        }

        public Set<Type> getTypes() {
            return BeanConfiguratorImpl.this.typeClosures;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return BeanConfiguratorImpl.this.injectionPoints;
        }

        public Set<Annotation> getQualifiers() {
            return BeanConfiguratorImpl.this.qualifiers;
        }

        @Override
        public Producer<T> getProducer() {
            return new Producer<T>(){
                private final Instance<Object> instance = CDI.current();

                public T produce(CreationalContext<T> creationalContext) {
                    return BeanConfiguratorImpl.this.produceWithCallback.apply(this.instance);
                }

                public void dispose(T instance) {
                    if (BeanConfiguratorImpl.this.disposeWithCallback != null) {
                        BeanConfiguratorImpl.this.disposeWithCallback.accept(instance, this.instance);
                    }
                }

                public Set<InjectionPoint> getInjectionPoints() {
                    return BeanConfiguratorImpl.this.injectionPoints;
                }
            };
        }

        public Class<?> getBeanClass() {
            return BeanConfiguratorImpl.this.beanClass == null ? this.returnType : BeanConfiguratorImpl.this.beanClass;
        }

        public Class<? extends Annotation> getScope() {
            return BeanConfiguratorImpl.this.scope;
        }

        @Override
        public WebBeansType getWebBeansType() {
            return WebBeansType.CONFIGURED;
        }

        public String getName() {
            return BeanConfiguratorImpl.this.name;
        }

        @Override
        public Class<T> getReturnType() {
            return this.returnType;
        }

        public T create(CreationalContext<T> context) {
            return BeanConfiguratorImpl.this.createWithCallback.apply(context);
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return BeanConfiguratorImpl.this.stereotypes;
        }

        @Override
        public void setSpecializedBean(boolean specialized) {
            this.specialized = specialized;
        }

        public boolean isAlternative() {
            return BeanConfiguratorImpl.this.alternative;
        }

        public boolean isNullable() {
            return false;
        }

        public void destroy(T instance, CreationalContext<T> context) {
            if (BeanConfiguratorImpl.this.destroyWithCallback != null) {
                BeanConfiguratorImpl.this.destroyWithCallback.accept(instance, context);
            }
        }

        @Override
        public boolean isSpecializedBean() {
            return this.specialized;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public String getId() {
            return BeanConfiguratorImpl.this.passivationId;
        }

        @Override
        public boolean isPassivationCapable() {
            return BeanConfiguratorImpl.this.passivationId != null;
        }

        @Override
        public boolean isDependent() {
            return this.dependent;
        }

        @Override
        public WebBeansContext getWebBeansContext() {
            return BeanConfiguratorImpl.this.webBeansContext;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            String simpleName = this.getReturnType().getSimpleName();
            builder.append(simpleName);
            builder.append(", WebBeansType:").append((Object)this.getWebBeansType()).append(", Name:").append(this.getName());
            builder.append(", API Types:[");
            int size = this.getTypes().size();
            int index = 1;
            for (Type clazz : this.getTypes()) {
                if (clazz instanceof Class) {
                    builder.append(((Class)clazz).getName());
                } else {
                    ParameterizedType parameterizedType = (ParameterizedType)clazz;
                    Class rawType = (Class)parameterizedType.getRawType();
                    builder.append(rawType.getName());
                    builder.append("<");
                    Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                    if (actualTypeArguments.length > 0) {
                        for (Type actualType : actualTypeArguments) {
                            if (Class.class.isInstance(actualType)) {
                                builder.append(((Class)Class.class.cast(actualType)).getName().replace("java.lang.", ""));
                            } else {
                                builder.append(actualType);
                            }
                            builder.append(",");
                        }
                    }
                    builder.delete(builder.length() - 1, builder.length());
                    builder.append(">");
                }
                if (index < size) {
                    builder.append(",");
                }
                ++index;
            }
            builder.append("], ");
            builder.append("Qualifiers:[");
            size = this.getQualifiers().size();
            index = 1;
            for (Annotation ann : this.getQualifiers()) {
                builder.append(ann.annotationType().getName());
                if (index < size) {
                    builder.append(",");
                }
                ++index;
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

