/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.autoconfigure;

import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.client.MQAdmin;
import org.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.SelectorType;
import org.apache.rocketmq.spring.autoconfigure.ExtConsumerResetConfiguration;
import org.apache.rocketmq.spring.autoconfigure.ExtProducerResetConfiguration;
import org.apache.rocketmq.spring.autoconfigure.ListenerContainerConfiguration;
import org.apache.rocketmq.spring.autoconfigure.MessageConverterConfiguration;
import org.apache.rocketmq.spring.autoconfigure.RocketMQListenerConfiguration;
import org.apache.rocketmq.spring.autoconfigure.RocketMQProperties;
import org.apache.rocketmq.spring.autoconfigure.RocketMQTransactionConfiguration;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.apache.rocketmq.spring.support.RocketMQMessageConverter;
import org.apache.rocketmq.spring.support.RocketMQUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={RocketMQProperties.class})
@ConditionalOnClass(value={MQAdmin.class})
@ConditionalOnProperty(prefix="rocketmq", value={"name-server"}, matchIfMissing=true)
@Import(value={MessageConverterConfiguration.class, ListenerContainerConfiguration.class, ExtProducerResetConfiguration.class, ExtConsumerResetConfiguration.class, RocketMQTransactionConfiguration.class, RocketMQListenerConfiguration.class})
@AutoConfigureAfter(value={MessageConverterConfiguration.class})
@AutoConfigureBefore(value={RocketMQTransactionConfiguration.class})
public class RocketMQAutoConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RocketMQAutoConfiguration.class);
    public static final String ROCKETMQ_TEMPLATE_DEFAULT_GLOBAL_NAME = "rocketMQTemplate";
    public static final String PRODUCER_BEAN_NAME = "defaultMQProducer";
    public static final String CONSUMER_BEAN_NAME = "defaultLitePullConsumer";
    private final Environment environment;
    private ApplicationContext applicationContext;

    public RocketMQAutoConfiguration(Environment environment) {
        this.environment = environment;
        this.checkProperties();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void checkProperties() {
        String nameServer = (String)this.environment.getProperty("rocketmq.name-server", String.class);
        log.debug("rocketmq.nameServer = {}", (Object)nameServer);
        if (nameServer == null) {
            log.warn("The necessary spring property 'rocketmq.name-server' is not defined, all rockertmq beans creation are skipped!");
        }
    }

    @Bean(value={"defaultMQProducer"})
    @ConditionalOnMissingBean(value={DefaultMQProducer.class})
    @ConditionalOnProperty(prefix="rocketmq", value={"name-server", "producer.group"})
    public DefaultMQProducer defaultMQProducer(RocketMQProperties rocketMQProperties) {
        RocketMQProperties.Producer producerConfig = rocketMQProperties.getProducer();
        String nameServer = rocketMQProperties.getNameServer();
        String groupName = producerConfig.getGroup();
        Assert.hasText((String)nameServer, (String)"[rocketmq.name-server] must not be null");
        Assert.hasText((String)groupName, (String)"[rocketmq.producer.group] must not be null");
        String accessChannel = rocketMQProperties.getAccessChannel();
        String ak = rocketMQProperties.getProducer().getAccessKey();
        String sk = rocketMQProperties.getProducer().getSecretKey();
        boolean isEnableMsgTrace = rocketMQProperties.getProducer().isEnableMsgTrace();
        String customizedTraceTopic = rocketMQProperties.getProducer().getCustomizedTraceTopic();
        DefaultMQProducer producer = RocketMQUtil.createDefaultMQProducer(groupName, ak, sk, isEnableMsgTrace, customizedTraceTopic);
        producer.setNamesrvAddr(nameServer);
        if (StringUtils.hasLength((String)accessChannel)) {
            producer.setAccessChannel(AccessChannel.valueOf((String)accessChannel));
        }
        producer.setSendMsgTimeout(producerConfig.getSendMessageTimeout());
        producer.setRetryTimesWhenSendFailed(producerConfig.getRetryTimesWhenSendFailed());
        producer.setRetryTimesWhenSendAsyncFailed(producerConfig.getRetryTimesWhenSendAsyncFailed());
        producer.setMaxMessageSize(producerConfig.getMaxMessageSize());
        producer.setCompressMsgBodyOverHowmuch(producerConfig.getCompressMessageBodyThreshold());
        producer.setRetryAnotherBrokerWhenNotStoreOK(producerConfig.isRetryNextServer());
        producer.setUseTLS(producerConfig.isTlsEnable());
        if (StringUtils.hasText((String)producerConfig.getNamespace())) {
            producer.setNamespace(producerConfig.getNamespace());
        }
        if (StringUtils.hasText((String)producerConfig.getNamespaceV2())) {
            producer.setNamespaceV2(producerConfig.getNamespaceV2());
        }
        producer.setInstanceName(producerConfig.getInstanceName());
        log.info("a producer ({}) init on namesrv {}", (Object)groupName, (Object)nameServer);
        return producer;
    }

    @Bean(value={"defaultLitePullConsumer"})
    @ConditionalOnMissingBean(value={DefaultLitePullConsumer.class})
    @ConditionalOnProperty(prefix="rocketmq", value={"name-server", "pull-consumer.group", "pull-consumer.topic"})
    public DefaultLitePullConsumer defaultLitePullConsumer(RocketMQProperties rocketMQProperties) throws MQClientException {
        RocketMQProperties.PullConsumer consumerConfig = rocketMQProperties.getPullConsumer();
        String nameServer = rocketMQProperties.getNameServer();
        String groupName = consumerConfig.getGroup();
        String topicName = consumerConfig.getTopic();
        Assert.hasText((String)nameServer, (String)"[rocketmq.name-server] must not be null");
        Assert.hasText((String)groupName, (String)"[rocketmq.pull-consumer.group] must not be null");
        Assert.hasText((String)topicName, (String)"[rocketmq.pull-consumer.topic] must not be null");
        String accessChannel = rocketMQProperties.getAccessChannel();
        MessageModel messageModel = MessageModel.valueOf(consumerConfig.getMessageModel());
        SelectorType selectorType = SelectorType.valueOf(consumerConfig.getSelectorType());
        String selectorExpression = consumerConfig.getSelectorExpression();
        String ak = consumerConfig.getAccessKey();
        String sk = consumerConfig.getSecretKey();
        int pullBatchSize = consumerConfig.getPullBatchSize();
        boolean useTLS = consumerConfig.isTlsEnable();
        DefaultLitePullConsumer litePullConsumer = RocketMQUtil.createDefaultLitePullConsumer(nameServer, accessChannel, groupName, topicName, messageModel, selectorType, selectorExpression, ak, sk, pullBatchSize, useTLS);
        litePullConsumer.setEnableMsgTrace(consumerConfig.isEnableMsgTrace());
        litePullConsumer.setCustomizedTraceTopic(consumerConfig.getCustomizedTraceTopic());
        if (StringUtils.hasText((String)consumerConfig.getNamespace())) {
            litePullConsumer.setNamespace(consumerConfig.getNamespace());
        }
        if (StringUtils.hasText((String)consumerConfig.getNamespaceV2())) {
            litePullConsumer.setNamespaceV2(consumerConfig.getNamespaceV2());
        }
        litePullConsumer.setInstanceName(consumerConfig.getInstanceName());
        log.info("a pull consumer({} sub {}) init on namesrv {}", new Object[]{groupName, topicName, nameServer});
        return litePullConsumer;
    }

    @Bean(destroyMethod="destroy")
    @Conditional(value={ProducerOrConsumerPropertyCondition.class})
    @ConditionalOnMissingBean(name={"rocketMQTemplate"})
    public RocketMQTemplate rocketMQTemplate(RocketMQMessageConverter rocketMQMessageConverter) {
        RocketMQTemplate rocketMQTemplate = new RocketMQTemplate();
        if (this.applicationContext.containsBean(PRODUCER_BEAN_NAME)) {
            rocketMQTemplate.setProducer((DefaultMQProducer)this.applicationContext.getBean(PRODUCER_BEAN_NAME));
        }
        if (this.applicationContext.containsBean(CONSUMER_BEAN_NAME)) {
            rocketMQTemplate.setConsumer((DefaultLitePullConsumer)this.applicationContext.getBean(CONSUMER_BEAN_NAME));
        }
        rocketMQTemplate.setMessageConverter(rocketMQMessageConverter.getMessageConverter());
        return rocketMQTemplate;
    }

    static class ProducerOrConsumerPropertyCondition
    extends AnyNestedCondition {
        public ProducerOrConsumerPropertyCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={DefaultLitePullConsumer.class})
        static class DefaultLitePullConsumerExistsCondition {
            DefaultLitePullConsumerExistsCondition() {
            }
        }

        @ConditionalOnBean(value={DefaultMQProducer.class})
        static class DefaultMQProducerExistsCondition {
            DefaultMQProducerExistsCondition() {
            }
        }
    }
}

