/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.api;

import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.shardingsphere.sql.parser.core.ParseASTNode;
import org.apache.shardingsphere.sql.parser.core.database.visitor.SQLVisitorFactory;
import org.apache.shardingsphere.sql.parser.core.database.visitor.SQLVisitorRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.AbstractSQLStatement;

public final class SQLVisitorEngine {
    private final String databaseType;
    private final String visitorType;
    private final boolean isParseComment;
    private final Properties props;

    public <T> T visit(ParseASTNode parseASTNode) {
        ParseTreeVisitor visitor = SQLVisitorFactory.newInstance(this.databaseType, this.visitorType, SQLVisitorRule.valueOf(parseASTNode.getRootNode().getClass()), this.props);
        Object result = parseASTNode.getRootNode().accept(visitor);
        if (this.isParseComment) {
            this.appendSQLComments(parseASTNode, result);
        }
        return (T)result;
    }

    private <T> void appendSQLComments(ParseASTNode parseASTNode, T visitResult) {
        if (visitResult instanceof AbstractSQLStatement) {
            Collection commentSegments = parseASTNode.getHiddenTokens().stream().map(each -> new CommentSegment(each.getText(), each.getStartIndex(), each.getStopIndex())).collect(Collectors.toList());
            ((AbstractSQLStatement)visitResult).getCommentSegments().addAll(commentSegments);
        }
    }

    @Generated
    public SQLVisitorEngine(String databaseType, String visitorType, boolean isParseComment, Properties props) {
        this.databaseType = databaseType;
        this.visitorType = visitorType;
        this.isParseComment = isParseComment;
        this.props = props;
    }
}

