/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.env;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.servlet.ServletContext;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.ResourceConfigurable;
import org.apache.shiro.util.ClassUtils;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.util.UnknownClassException;
import org.apache.shiro.web.env.IniWebEnvironment;
import org.apache.shiro.web.env.MutableWebEnvironment;
import org.apache.shiro.web.env.WebEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentLoader {
    public static final String ENVIRONMENT_CLASS_PARAM = "shiroEnvironmentClass";
    public static final String CONFIG_LOCATIONS_PARAM = "shiroConfigLocations";
    public static final String ENVIRONMENT_ATTRIBUTE_KEY = EnvironmentLoader.class.getName() + ".ENVIRONMENT_ATTRIBUTE_KEY";
    private static final Logger log = LoggerFactory.getLogger(EnvironmentLoader.class);

    public WebEnvironment initEnvironment(ServletContext servletContext) throws IllegalStateException {
        if (servletContext.getAttribute(ENVIRONMENT_ATTRIBUTE_KEY) != null) {
            String msg = "There is already a Shiro environment associated with the current ServletContext.  Check if you have multiple EnvironmentLoader* definitions in your web.xml!";
            throw new IllegalStateException(msg);
        }
        servletContext.log("Initializing Shiro environment");
        log.info("Starting Shiro environment initialization.");
        long startTime = System.currentTimeMillis();
        try {
            WebEnvironment environment = this.createEnvironment(servletContext);
            servletContext.setAttribute(ENVIRONMENT_ATTRIBUTE_KEY, (Object)environment);
            log.debug("Published WebEnvironment as ServletContext attribute with name [{}]", (Object)ENVIRONMENT_ATTRIBUTE_KEY);
            if (log.isInfoEnabled()) {
                long elapsed = System.currentTimeMillis() - startTime;
                log.info("Shiro environment initialized in {} ms.", (Object)elapsed);
            }
            return environment;
        }
        catch (RuntimeException ex) {
            log.error("Shiro environment initialization failed", (Throwable)ex);
            servletContext.setAttribute(ENVIRONMENT_ATTRIBUTE_KEY, (Object)ex);
            throw ex;
        }
        catch (Error err) {
            log.error("Shiro environment initialization failed", (Throwable)err);
            servletContext.setAttribute(ENVIRONMENT_ATTRIBUTE_KEY, (Object)err);
            throw err;
        }
    }

    @Deprecated
    protected Class<?> determineWebEnvironmentClass(ServletContext servletContext) {
        Class<? extends WebEnvironment> webEnvironmentClass = this.webEnvironmentClassFromServletContext(servletContext);
        if (webEnvironmentClass != null) {
            return webEnvironmentClass;
        }
        return this.getDefaultWebEnvironmentClass();
    }

    private Class<? extends WebEnvironment> webEnvironmentClassFromServletContext(ServletContext servletContext) {
        Class webEnvironmentClass = null;
        String className = servletContext.getInitParameter(ENVIRONMENT_CLASS_PARAM);
        if (className != null) {
            try {
                webEnvironmentClass = ClassUtils.forName(className);
            }
            catch (UnknownClassException ex) {
                throw new ConfigurationException("Failed to load custom WebEnvironment class [" + className + "]", ex);
            }
        }
        return webEnvironmentClass;
    }

    private WebEnvironment webEnvironmentFromServiceLoader() {
        WebEnvironment webEnvironment = null;
        ServiceLoader<WebEnvironment> serviceLoader = ServiceLoader.load(WebEnvironment.class);
        Iterator<WebEnvironment> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            webEnvironment = iterator.next();
        }
        if (iterator.hasNext()) {
            ArrayList<String> allWebEnvironments = new ArrayList<String>();
            allWebEnvironments.add(webEnvironment.getClass().getName());
            while (iterator.hasNext()) {
                allWebEnvironments.add(iterator.next().getClass().getName());
            }
            throw new ConfigurationException("ServiceLoader for class [" + WebEnvironment.class + "] returned more then one result.  ServiceLoader must return zero or exactly one result for this class. Select one using the servlet init parameter '" + ENVIRONMENT_CLASS_PARAM + "'. Found: " + allWebEnvironments);
        }
        return webEnvironment;
    }

    protected Class<? extends WebEnvironment> getDefaultWebEnvironmentClass() {
        return IniWebEnvironment.class;
    }

    protected WebEnvironment determineWebEnvironment(ServletContext servletContext) {
        Class<? extends WebEnvironment> webEnvironmentClass = this.webEnvironmentClassFromServletContext(servletContext);
        WebEnvironment webEnvironment = null;
        if (webEnvironmentClass == null) {
            webEnvironment = this.webEnvironmentFromServiceLoader();
        }
        if (webEnvironmentClass == null && webEnvironment == null) {
            webEnvironmentClass = this.getDefaultWebEnvironmentClass();
        }
        if (webEnvironmentClass != null) {
            webEnvironment = (WebEnvironment)ClassUtils.newInstance(webEnvironmentClass);
        }
        return webEnvironment;
    }

    protected WebEnvironment createEnvironment(ServletContext sc) {
        WebEnvironment webEnvironment = this.determineWebEnvironment(sc);
        if (!MutableWebEnvironment.class.isInstance(webEnvironment)) {
            throw new ConfigurationException("Custom WebEnvironment class [" + webEnvironment.getClass().getName() + "] is not of required type [" + MutableWebEnvironment.class.getName() + "]");
        }
        String configLocations = sc.getInitParameter(CONFIG_LOCATIONS_PARAM);
        boolean configSpecified = StringUtils.hasText(configLocations);
        if (configSpecified && !ResourceConfigurable.class.isInstance(webEnvironment)) {
            String msg = "WebEnvironment class [" + webEnvironment.getClass().getName() + "] does not implement the " + ResourceConfigurable.class.getName() + "interface.  This is required to accept any configured " + CONFIG_LOCATIONS_PARAM + "value(s).";
            throw new ConfigurationException(msg);
        }
        MutableWebEnvironment environment = (MutableWebEnvironment)webEnvironment;
        environment.setServletContext(sc);
        if (configSpecified && environment instanceof ResourceConfigurable) {
            ((ResourceConfigurable)((Object)environment)).setConfigLocations(configLocations);
        }
        this.customizeEnvironment(environment);
        LifecycleUtils.init(environment);
        return environment;
    }

    protected void customizeEnvironment(WebEnvironment environment) {
    }

    public void destroyEnvironment(ServletContext servletContext) {
        servletContext.log("Cleaning up Shiro Environment");
        try {
            Object environment = servletContext.getAttribute(ENVIRONMENT_ATTRIBUTE_KEY);
            if (environment instanceof WebEnvironment) {
                this.finalizeEnvironment((WebEnvironment)environment);
            }
            LifecycleUtils.destroy(environment);
        }
        finally {
            servletContext.removeAttribute(ENVIRONMENT_ATTRIBUTE_KEY);
        }
    }

    protected void finalizeEnvironment(WebEnvironment environment) {
    }
}

