/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import java.io.InputStream;
import java.util.Map;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniFactorySupport;
import org.apache.shiro.io.ResourceUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.config.IniFilterChainResolverFactory;
import org.apache.shiro.web.config.WebIniSecurityManagerFactory;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class IniShiroFilter
extends AbstractShiroFilter {
    public static final String CONFIG_INIT_PARAM_NAME = "config";
    public static final String CONFIG_PATH_INIT_PARAM_NAME = "configPath";
    public static final String DEFAULT_WEB_INI_RESOURCE_PATH = "/WEB-INF/shiro.ini";
    private static final Logger log = LoggerFactory.getLogger(IniShiroFilter.class);
    private String config;
    private String configPath;

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public void setConfigPath(String configPath) {
        this.configPath = StringUtils.clean((String)configPath);
    }

    @Override
    public void init() throws Exception {
        this.applyInitParams();
        this.configure();
    }

    protected void applyInitParams() throws Exception {
        String configPath;
        String config = this.getInitParam(CONFIG_INIT_PARAM_NAME);
        if (config != null) {
            this.setConfig(config);
        }
        if ((configPath = this.getInitParam(CONFIG_PATH_INIT_PARAM_NAME)) != null) {
            this.setConfigPath(configPath);
        }
    }

    protected void configure() throws Exception {
        Ini ini = this.loadIniFromConfig();
        if (CollectionUtils.isEmpty((Map)ini)) {
            log.info("Null or empty configuration specified via 'config' init-param.  Checking path-based configuration.");
            ini = this.loadIniFromPath();
        }
        if (CollectionUtils.isEmpty((Map)ini)) {
            log.info("Null or empty configuration specified via 'config' or 'configPath' filter parameters.  Trying the default /WEB-INF/shiro.ini file.");
            ini = this.getServletContextIniResource(DEFAULT_WEB_INI_RESOURCE_PATH);
        }
        if (CollectionUtils.isEmpty((Map)ini)) {
            log.info("Null or empty configuration specified via 'config' or 'configPath' filter parameters.  Trying the default classpath:shiro.ini file.");
            ini = IniFactorySupport.loadDefaultClassPathIni();
        }
        Map<String, ?> objects = this.applySecurityManager(ini);
        this.applyFilterChainResolver(ini, objects);
    }

    protected Ini loadIniFromConfig() {
        Ini ini = null;
        String config = this.getConfig();
        if (config != null) {
            ini = this.convertConfigToIni(config);
        }
        return ini;
    }

    protected Ini loadIniFromPath() {
        Ini ini = null;
        String path = this.getConfigPath();
        if (path != null) {
            ini = this.convertPathToIni(path);
        }
        return ini;
    }

    protected Map<String, ?> applySecurityManager(Ini ini) {
        WebIniSecurityManagerFactory factory = CollectionUtils.isEmpty((Map)ini) ? new WebIniSecurityManagerFactory() : new WebIniSecurityManagerFactory(ini);
        SecurityManager securityManager = (SecurityManager)factory.getInstance();
        if (!(securityManager instanceof WebSecurityManager)) {
            String msg = "The configured security manager is not an instance of WebSecurityManager, so it can not be used with the Shiro servlet filter.";
            throw new ConfigurationException(msg);
        }
        this.setSecurityManager((WebSecurityManager)securityManager);
        return factory.getBeans();
    }

    protected void applyFilterChainResolver(Ini ini, Map<String, ?> defaults) {
        if (ini == null || ini.isEmpty()) {
            return;
        }
        Ini.Section urls = ini.getSection("urls");
        Ini.Section filters = ini.getSection("filters");
        if (urls != null && !urls.isEmpty() || filters != null && !filters.isEmpty()) {
            IniFilterChainResolverFactory filterChainResolverFactory = new IniFilterChainResolverFactory(ini, defaults);
            filterChainResolverFactory.setFilterConfig(this.getFilterConfig());
            FilterChainResolver resolver = (FilterChainResolver)filterChainResolverFactory.getInstance();
            this.setFilterChainResolver(resolver);
        }
    }

    protected Ini convertConfigToIni(String config) {
        Ini ini = new Ini();
        ini.load(config);
        return ini;
    }

    protected Ini getServletContextIniResource(String servletContextPath) {
        InputStream is;
        String path = WebUtils.normalize(servletContextPath);
        if (this.getServletContext() != null && (is = this.getServletContext().getResourceAsStream(path)) != null) {
            Ini ini = new Ini();
            ini.load(is);
            if (CollectionUtils.isEmpty((Map)ini)) {
                log.warn("ServletContext INI resource '" + servletContextPath + "' exists, but it did not contain any data.");
            }
            return ini;
        }
        return null;
    }

    protected Ini convertPathToIni(String path) {
        Ini ini = new Ini();
        if (!ResourceUtils.hasResourcePrefix((String)path)) {
            ini = this.getServletContextIniResource(path);
            if (ini == null) {
                String msg = "There is no servlet context resource corresponding to configPath '" + path + "'  If the resource is located elsewhere (not immediately resolveable in the servlet context), specify an appropriate classpath:, url:, or file: resource prefix accordingly.";
                throw new ConfigurationException(msg);
            }
        } else {
            ini.loadFromPath(path);
        }
        return ini;
    }
}

