/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.AsyncChannelGroupUtil;
import org.apache.tomcat.websocket.AsyncChannelWrapper;
import org.apache.tomcat.websocket.AsyncChannelWrapperNonSecure;
import org.apache.tomcat.websocket.AsyncChannelWrapperSecure;
import org.apache.tomcat.websocket.BackgroundProcess;
import org.apache.tomcat.websocket.BackgroundProcessManager;
import org.apache.tomcat.websocket.CaseInsensitiveKeyMap;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.TransformationFactory;
import org.apache.tomcat.websocket.Util;
import org.apache.tomcat.websocket.WsFrameClient;
import org.apache.tomcat.websocket.WsHandshakeResponse;
import org.apache.tomcat.websocket.WsRemoteEndpointImplClient;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.pojo.PojoEndpointClient;

public class WsWebSocketContainer
implements WebSocketContainer,
BackgroundProcess {
    public static final String SSL_PROTOCOLS_PROPERTY = "org.apache.tomcat.websocket.SSL_PROTOCOLS";
    public static final String SSL_TRUSTSTORE_PROPERTY = "org.apache.tomcat.websocket.SSL_TRUSTSTORE";
    public static final String SSL_TRUSTSTORE_PWD_PROPERTY = "org.apache.tomcat.websocket.SSL_TRUSTSTORE_PWD";
    public static final String SSL_TRUSTSTORE_PWD_DEFAULT = "changeit";
    public static final String SSL_CONTEXT_PROPERTY = "org.apache.tomcat.websocket.SSL_CONTEXT";
    public static final String IO_TIMEOUT_MS_PROPERTY = "org.apache.tomcat.websocket.IO_TIMEOUT_MS";
    public static final long IO_TIMEOUT_MS_DEFAULT = 5000L;
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private static final Random random = new Random();
    private static final byte[] crlf = new byte[]{13, 10};
    private static final byte[] GET_BYTES = "GET ".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ROOT_URI_BYTES = "/".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] HTTP_VERSION_BYTES = " HTTP/1.1\r\n".getBytes(StandardCharsets.ISO_8859_1);
    private volatile AsynchronousChannelGroup asynchronousChannelGroup = null;
    private final Object asynchronousChannelGroupLock = new Object();
    private final Log log = LogFactory.getLog(WsWebSocketContainer.class);
    private final Map<Endpoint, Set<WsSession>> endpointSessionMap = new HashMap<Endpoint, Set<WsSession>>();
    private final Map<WsSession, WsSession> sessions = new ConcurrentHashMap<WsSession, WsSession>();
    private final Object endPointSessionMapLock = new Object();
    private long defaultAsyncTimeout = -1L;
    private int maxBinaryMessageBufferSize = Constants.DEFAULT_BUFFER_SIZE;
    private int maxTextMessageBufferSize = Constants.DEFAULT_BUFFER_SIZE;
    private volatile long defaultMaxSessionIdleTimeout = 0L;
    private int backgroundProcessCount = 0;
    private int processPeriod = Constants.DEFAULT_PROCESS_PERIOD;
    private InstanceManager instanceManager;

    InstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    protected void setInstanceManager(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }

    @Override
    public Session connectToServer(Object pojo, URI path) throws DeploymentException {
        ClientEndpoint annotation = pojo.getClass().getAnnotation(ClientEndpoint.class);
        if (annotation == null) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.missingAnnotation", new Object[]{pojo.getClass().getName()}));
        }
        PojoEndpointClient ep = new PojoEndpointClient(pojo, Arrays.asList(annotation.decoders()));
        Class<? extends ClientEndpointConfig.Configurator> configuratorClazz = annotation.configurator();
        ClientEndpointConfig.Configurator configurator = null;
        if (!ClientEndpointConfig.Configurator.class.equals(configuratorClazz)) {
            try {
                configurator = configuratorClazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new DeploymentException(sm.getString("wsWebSocketContainer.defaultConfiguratorFail"), e);
            }
            catch (IllegalAccessException e) {
                throw new DeploymentException(sm.getString("wsWebSocketContainer.defaultConfiguratorFail"), e);
            }
        }
        ClientEndpointConfig.Builder builder = ClientEndpointConfig.Builder.create();
        if (configurator != null) {
            builder.configurator(configurator);
        }
        ClientEndpointConfig config = builder.decoders(Arrays.asList(annotation.decoders())).encoders(Arrays.asList(annotation.encoders())).preferredSubprotocols(Arrays.asList(annotation.subprotocols())).build();
        return this.connectToServer(ep, config, path);
    }

    @Override
    public Session connectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException {
        Object pojo;
        try {
            pojo = annotatedEndpointClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.endpointCreateFail", new Object[]{annotatedEndpointClass.getName()}), e);
        }
        catch (IllegalAccessException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.endpointCreateFail", new Object[]{annotatedEndpointClass.getName()}), e);
        }
        return this.connectToServer(pojo, path);
    }

    @Override
    public Session connectToServer(Class<? extends Endpoint> clazz, ClientEndpointConfig clientEndpointConfiguration, URI path) throws DeploymentException {
        Endpoint endpoint;
        try {
            endpoint = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.endpointCreateFail", new Object[]{clazz.getName()}), e);
        }
        catch (IllegalAccessException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.endpointCreateFail", new Object[]{clazz.getName()}), e);
        }
        return this.connectToServer(endpoint, clientEndpointConfiguration, path);
    }

    @Override
    public Session connectToServer(Endpoint endpoint, ClientEndpointConfig clientEndpointConfiguration, URI path) throws DeploymentException {
        String subProtocol;
        AsynchronousSocketChannel socketChannel;
        URI proxyPath;
        boolean secure = false;
        ByteBuffer proxyConnect = null;
        String scheme = path.getScheme();
        if ("ws".equalsIgnoreCase(scheme)) {
            proxyPath = URI.create("http" + path.toString().substring(2));
        } else if ("wss".equalsIgnoreCase(scheme)) {
            proxyPath = URI.create("https" + path.toString().substring(3));
        } else {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.pathWrongScheme", new Object[]{scheme}));
        }
        String host = path.getHost();
        if (host == null) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.pathNoHost"));
        }
        int port = path.getPort();
        SocketAddress sa = null;
        List<Proxy> proxies = ProxySelector.getDefault().select(proxyPath);
        Proxy selectedProxy = null;
        for (Proxy proxy : proxies) {
            InetSocketAddress inet;
            if (!proxy.type().equals((Object)Proxy.Type.HTTP)) continue;
            sa = proxy.address();
            if (sa instanceof InetSocketAddress && (inet = (InetSocketAddress)sa).isUnresolved()) {
                sa = new InetSocketAddress(inet.getHostName(), inet.getPort());
            }
            selectedProxy = proxy;
            break;
        }
        if (sa == null) {
            if (port == -1) {
                if ("ws".equalsIgnoreCase(scheme)) {
                    sa = new InetSocketAddress(host, 80);
                } else {
                    sa = new InetSocketAddress(host, 443);
                    secure = true;
                }
            } else {
                if ("wss".equalsIgnoreCase(scheme)) {
                    secure = true;
                }
                sa = new InetSocketAddress(host, port);
            }
        } else {
            proxyConnect = WsWebSocketContainer.createProxyRequest(host, port);
        }
        Map<String, List<String>> reqHeaders = WsWebSocketContainer.createRequestHeaders(host, port, clientEndpointConfiguration.getPreferredSubprotocols(), clientEndpointConfiguration.getExtensions());
        clientEndpointConfiguration.getConfigurator().beforeRequest(reqHeaders);
        if (Constants.DEFAULT_ORIGIN_HEADER_VALUE != null && !reqHeaders.containsKey("Origin")) {
            ArrayList<String> originValues = new ArrayList<String>(1);
            originValues.add(Constants.DEFAULT_ORIGIN_HEADER_VALUE);
            reqHeaders.put("Origin", originValues);
        }
        ByteBuffer request = WsWebSocketContainer.createRequest(path, reqHeaders);
        try {
            socketChannel = AsynchronousSocketChannel.open(this.getAsynchronousChannelGroup());
        }
        catch (IOException ioe) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.asynchronousSocketChannelFail"), ioe);
        }
        long timeout = 5000L;
        String timeoutValue = (String)clientEndpointConfiguration.getUserProperties().get(IO_TIMEOUT_MS_PROPERTY);
        if (timeoutValue != null) {
            timeout = Long.valueOf(timeoutValue).intValue();
        }
        ByteBuffer response = ByteBuffer.allocate(this.maxBinaryMessageBufferSize);
        boolean success = false;
        ArrayList<Extension> extensionsAgreed = new ArrayList<Extension>();
        Transformation transformation = null;
        Future<Void> fConnect = socketChannel.connect(sa);
        AsyncChannelWrapper channel = null;
        if (proxyConnect != null) {
            try {
                fConnect.get(timeout, TimeUnit.MILLISECONDS);
                channel = new AsyncChannelWrapperNonSecure(socketChannel);
                WsWebSocketContainer.writeRequest(channel, proxyConnect, timeout);
                HttpResponse httpResponse = this.processResponse(response, channel, timeout);
                if (httpResponse.getStatus() != 200) {
                    throw new DeploymentException(sm.getString("wsWebSocketContainer.proxyConnectFail", new Object[]{selectedProxy, Integer.toString(httpResponse.getStatus())}));
                }
            }
            catch (Exception e) {
                if (channel != null) {
                    channel.close();
                }
                throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed"), e);
            }
        }
        if (secure) {
            SSLEngine sslEngine = this.createSSLEngine(clientEndpointConfiguration.getUserProperties());
            channel = new AsyncChannelWrapperSecure(socketChannel, sslEngine);
        } else if (channel == null) {
            channel = new AsyncChannelWrapperNonSecure(socketChannel);
        }
        try {
            fConnect.get(timeout, TimeUnit.MILLISECONDS);
            Future<Void> fHandshake = channel.handshake();
            fHandshake.get(timeout, TimeUnit.MILLISECONDS);
            WsWebSocketContainer.writeRequest(channel, request, timeout);
            HttpResponse httpResponse = this.processResponse(response, channel, timeout);
            if (httpResponse.status != 101) {
                throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidStatus", new Object[]{Integer.toString(httpResponse.status)}));
            }
            HandshakeResponse handshakeResponse = httpResponse.getHandshakeResponse();
            clientEndpointConfiguration.getConfigurator().afterResponse(handshakeResponse);
            List<String> protocolHeaders = handshakeResponse.getHeaders().get("Sec-WebSocket-Protocol");
            if (protocolHeaders == null || protocolHeaders.size() == 0) {
                subProtocol = null;
            } else if (protocolHeaders.size() == 1) {
                subProtocol = protocolHeaders.get(0);
            } else {
                throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidSubProtocol"));
            }
            List<String> extHeaders = handshakeResponse.getHeaders().get("Sec-WebSocket-Extensions");
            if (extHeaders != null) {
                for (String extHeader : extHeaders) {
                    Util.parseExtensionHeader(extensionsAgreed, extHeader);
                }
            }
            TransformationFactory factory = TransformationFactory.getInstance();
            for (Extension extension : extensionsAgreed) {
                ArrayList<List<Extension.Parameter>> wrapper = new ArrayList<List<Extension.Parameter>>(1);
                wrapper.add(extension.getParameters());
                Transformation t = factory.create(extension.getName(), wrapper, false);
                if (t == null) {
                    throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidExtensionParameters"));
                }
                if (transformation == null) {
                    transformation = t;
                    continue;
                }
                transformation.setNext(t);
            }
            success = true;
        }
        catch (ExecutionException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed"), e);
        }
        catch (InterruptedException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed"), e);
        }
        catch (SSLException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed"), e);
        }
        catch (EOFException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed"), e);
        }
        catch (TimeoutException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed"), e);
        }
        finally {
            if (!success) {
                channel.close();
            }
        }
        WsRemoteEndpointImplClient wsRemoteEndpointClient = new WsRemoteEndpointImplClient(channel);
        WsSession wsSession = new WsSession(endpoint, wsRemoteEndpointClient, this, null, null, null, null, null, extensionsAgreed, subProtocol, Collections.<String, String>emptyMap(), secure, clientEndpointConfiguration);
        WsFrameClient wsFrameClient = new WsFrameClient(response, channel, wsSession, transformation);
        wsRemoteEndpointClient.setTransformation(wsFrameClient.getTransformation());
        endpoint.onOpen(wsSession, clientEndpointConfiguration);
        this.registerSession(endpoint, wsSession);
        wsFrameClient.startInputProcessing();
        return wsSession;
    }

    private static void writeRequest(AsyncChannelWrapper channel, ByteBuffer request, long timeout) throws TimeoutException, InterruptedException, ExecutionException {
        int toWrite = request.limit();
        Future<Integer> fWrite = channel.write(request);
        Integer thisWrite = fWrite.get(timeout, TimeUnit.MILLISECONDS);
        toWrite -= thisWrite.intValue();
        while (toWrite > 0) {
            fWrite = channel.write(request);
            thisWrite = fWrite.get(timeout, TimeUnit.MILLISECONDS);
            toWrite -= thisWrite.intValue();
        }
    }

    private static ByteBuffer createProxyRequest(String host, int port) {
        StringBuilder request = new StringBuilder();
        request.append("CONNECT ");
        request.append(host);
        if (port != -1) {
            request.append(':');
            request.append(port);
        }
        request.append(" HTTP/1.1\r\nProxy-Connection: keep-alive\r\nConnection: keepalive\r\nHost: ");
        request.append(host);
        if (port != -1) {
            request.append(':');
            request.append(port);
        }
        request.append("\r\n\r\n");
        byte[] bytes = request.toString().getBytes(StandardCharsets.ISO_8859_1);
        return ByteBuffer.wrap(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSession(Endpoint endpoint, WsSession wsSession) {
        if (!wsSession.isOpen()) {
            return;
        }
        Object object = this.endPointSessionMapLock;
        synchronized (object) {
            Set<WsSession> wsSessions;
            if (this.endpointSessionMap.size() == 0) {
                BackgroundProcessManager.getInstance().register(this);
            }
            if ((wsSessions = this.endpointSessionMap.get(endpoint)) == null) {
                wsSessions = new HashSet<WsSession>();
                this.endpointSessionMap.put(endpoint, wsSessions);
            }
            wsSessions.add(wsSession);
        }
        this.sessions.put(wsSession, wsSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterSession(Endpoint endpoint, WsSession wsSession) {
        Object object = this.endPointSessionMapLock;
        synchronized (object) {
            Set<WsSession> wsSessions = this.endpointSessionMap.get(endpoint);
            if (wsSessions != null) {
                wsSessions.remove(wsSession);
                if (wsSessions.size() == 0) {
                    this.endpointSessionMap.remove(endpoint);
                }
            }
            if (this.endpointSessionMap.size() == 0) {
                BackgroundProcessManager.getInstance().unregister(this);
            }
        }
        this.sessions.remove(wsSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Session> getOpenSessions(Endpoint endpoint) {
        HashSet<Session> result = new HashSet<Session>();
        Object object = this.endPointSessionMapLock;
        synchronized (object) {
            Set<WsSession> sessions = this.endpointSessionMap.get(endpoint);
            if (sessions != null) {
                result.addAll(sessions);
            }
        }
        return result;
    }

    private static Map<String, List<String>> createRequestHeaders(String host, int port, List<String> subProtocols, List<Extension> extensions) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        ArrayList<String> hostValues = new ArrayList<String>(1);
        if (port == -1) {
            hostValues.add(host);
        } else {
            hostValues.add(host + ':' + port);
        }
        headers.put("Host", hostValues);
        ArrayList<String> upgradeValues = new ArrayList<String>(1);
        upgradeValues.add("websocket");
        headers.put("Upgrade", upgradeValues);
        ArrayList<String> connectionValues = new ArrayList<String>(1);
        connectionValues.add("upgrade");
        headers.put("Connection", connectionValues);
        ArrayList<String> wsVersionValues = new ArrayList<String>(1);
        wsVersionValues.add("13");
        headers.put("Sec-WebSocket-Version", wsVersionValues);
        ArrayList<String> wsKeyValues = new ArrayList<String>(1);
        wsKeyValues.add(WsWebSocketContainer.generateWsKeyValue());
        headers.put("Sec-WebSocket-Key", wsKeyValues);
        if (subProtocols != null && subProtocols.size() > 0) {
            headers.put("Sec-WebSocket-Protocol", subProtocols);
        }
        if (extensions != null && extensions.size() > 0) {
            headers.put("Sec-WebSocket-Extensions", WsWebSocketContainer.generateExtensionHeaders(extensions));
        }
        return headers;
    }

    private static List<String> generateExtensionHeaders(List<Extension> extensions) {
        ArrayList<String> result = new ArrayList<String>(extensions.size());
        for (Extension extension : extensions) {
            StringBuilder header = new StringBuilder();
            header.append(extension.getName());
            for (Extension.Parameter param : extension.getParameters()) {
                header.append(';');
                header.append(param.getName());
                String value = param.getValue();
                if (value == null || value.length() <= 0) continue;
                header.append('=');
                header.append(value);
            }
            result.add(header.toString());
        }
        return result;
    }

    private static String generateWsKeyValue() {
        byte[] keyBytes = new byte[16];
        random.nextBytes(keyBytes);
        return Base64.encodeBase64String((byte[])keyBytes);
    }

    private static ByteBuffer createRequest(URI uri, Map<String, List<String>> reqHeaders) {
        ByteBuffer result = ByteBuffer.allocate(4096);
        result.put(GET_BYTES);
        byte[] path = null == uri.getPath() || "".equals(uri.getPath()) ? ROOT_URI_BYTES : uri.getRawPath().getBytes(StandardCharsets.ISO_8859_1);
        result.put(path);
        String query = uri.getRawQuery();
        if (query != null) {
            result.put((byte)63);
            result.put(query.getBytes(StandardCharsets.ISO_8859_1));
        }
        result.put(HTTP_VERSION_BYTES);
        for (Map.Entry<String, List<String>> entry : reqHeaders.entrySet()) {
            WsWebSocketContainer.addHeader(result, entry.getKey(), entry.getValue());
        }
        result.put(crlf);
        result.flip();
        return result;
    }

    private static void addHeader(ByteBuffer result, String key, List<String> values) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = values.iterator();
        if (!iter.hasNext()) {
            return;
        }
        sb.append(iter.next());
        while (iter.hasNext()) {
            sb.append(',');
            sb.append(iter.next());
        }
        result.put(key.getBytes(StandardCharsets.ISO_8859_1));
        result.put(": ".getBytes(StandardCharsets.ISO_8859_1));
        result.put(sb.toString().getBytes(StandardCharsets.ISO_8859_1));
        result.put(crlf);
    }

    private HttpResponse processResponse(ByteBuffer response, AsyncChannelWrapper channel, long timeout) throws InterruptedException, ExecutionException, DeploymentException, EOFException, TimeoutException {
        CaseInsensitiveKeyMap<List<String>> headers = new CaseInsensitiveKeyMap<List<String>>();
        int status = 0;
        boolean readStatus = false;
        boolean readHeaders = false;
        String line = null;
        while (!readHeaders) {
            response.clear();
            Future<Integer> read = channel.read(response);
            Integer bytesRead = read.get(timeout, TimeUnit.MILLISECONDS);
            if (bytesRead == -1) {
                throw new EOFException();
            }
            response.flip();
            while (response.hasRemaining() && !readHeaders) {
                if ("\r\n".equals(line = line == null ? this.readLine(response) : line + this.readLine(response))) {
                    readHeaders = true;
                    continue;
                }
                if (!line.endsWith("\r\n")) continue;
                if (readStatus) {
                    this.parseHeaders(line, headers);
                } else {
                    status = this.parseStatus(line);
                    readStatus = true;
                }
                line = null;
            }
        }
        return new HttpResponse(status, new WsHandshakeResponse(headers));
    }

    private int parseStatus(String line) throws DeploymentException {
        String[] parts = line.trim().split(" ");
        if (parts.length < 2 || !"HTTP/1.0".equals(parts[0]) && !"HTTP/1.1".equals(parts[0])) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidStatus", new Object[]{line}));
        }
        try {
            return Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException nfe) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidStatus", new Object[]{line}));
        }
    }

    private void parseHeaders(String line, Map<String, List<String>> headers) {
        int index = line.indexOf(58);
        if (index == -1) {
            this.log.warn((Object)sm.getString("wsWebSocketContainer.invalidHeader", new Object[]{line}));
            return;
        }
        String headerName = line.substring(0, index).trim().toLowerCase(Locale.ENGLISH);
        String headerValue = line.substring(index + 1).trim();
        List<String> values = headers.get(headerName);
        if (values == null) {
            values = new ArrayList<String>(1);
            headers.put(headerName, values);
        }
        values.add(headerValue);
    }

    private String readLine(ByteBuffer response) {
        StringBuilder sb = new StringBuilder();
        char c = '\u0000';
        while (response.hasRemaining()) {
            c = (char)response.get();
            sb.append(c);
            if (c != '\n') continue;
            break;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLEngine createSSLEngine(Map<String, Object> userProperties) throws DeploymentException {
        try {
            SSLContext sslContext = (SSLContext)userProperties.get(SSL_CONTEXT_PROPERTY);
            if (sslContext == null) {
                sslContext = SSLContext.getInstance("TLS");
                String sslTrustStoreValue = (String)userProperties.get(SSL_TRUSTSTORE_PROPERTY);
                if (sslTrustStoreValue != null) {
                    String sslTrustStorePwdValue = (String)userProperties.get(SSL_TRUSTSTORE_PWD_PROPERTY);
                    if (sslTrustStorePwdValue == null) {
                        sslTrustStorePwdValue = SSL_TRUSTSTORE_PWD_DEFAULT;
                    }
                    File keyStoreFile = new File(sslTrustStoreValue);
                    KeyStore ks = KeyStore.getInstance("JKS");
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(keyStoreFile);
                        ks.load(is, sslTrustStorePwdValue.toCharArray());
                    }
                    finally {
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ks);
                    sslContext.init(null, tmf.getTrustManagers(), null);
                } else {
                    sslContext.init(null, null, null);
                }
            }
            SSLEngine engine = sslContext.createSSLEngine();
            String sslProtocolsValue = (String)userProperties.get(SSL_PROTOCOLS_PROPERTY);
            if (sslProtocolsValue != null) {
                engine.setEnabledProtocols(sslProtocolsValue.split(","));
            }
            engine.setUseClientMode(true);
            return engine;
        }
        catch (Exception e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.sslEngineFail"), e);
        }
    }

    @Override
    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    @Override
    public void setDefaultMaxSessionIdleTimeout(long timeout) {
        this.defaultMaxSessionIdleTimeout = timeout;
    }

    @Override
    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    @Override
    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.maxBinaryMessageBufferSize = max;
    }

    @Override
    public int getDefaultMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    @Override
    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.maxTextMessageBufferSize = max;
    }

    @Override
    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    @Override
    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncTimeout;
    }

    @Override
    public void setAsyncSendTimeout(long timeout) {
        this.defaultAsyncTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        CloseReason cr = new CloseReason(CloseReason.CloseCodes.GOING_AWAY, sm.getString("wsWebSocketContainer.shutdown"));
        for (WsSession session : this.sessions.keySet()) {
            try {
                session.close(cr);
            }
            catch (IOException ioe) {
                this.log.debug((Object)sm.getString("wsWebSocketContainer.sessionCloseFail", new Object[]{session.getId()}), (Throwable)ioe);
            }
        }
        if (this.asynchronousChannelGroup != null) {
            Object object = this.asynchronousChannelGroupLock;
            synchronized (object) {
                if (this.asynchronousChannelGroup != null) {
                    AsyncChannelGroupUtil.unregister();
                    this.asynchronousChannelGroup = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsynchronousChannelGroup getAsynchronousChannelGroup() {
        AsynchronousChannelGroup result = this.asynchronousChannelGroup;
        if (result == null) {
            Object object = this.asynchronousChannelGroupLock;
            synchronized (object) {
                if (this.asynchronousChannelGroup == null) {
                    this.asynchronousChannelGroup = AsyncChannelGroupUtil.register();
                }
                result = this.asynchronousChannelGroup;
            }
        }
        return result;
    }

    @Override
    public void backgroundProcess() {
        ++this.backgroundProcessCount;
        if (this.backgroundProcessCount >= this.processPeriod) {
            this.backgroundProcessCount = 0;
            for (WsSession wsSession : this.sessions.keySet()) {
                wsSession.checkExpiration();
            }
        }
    }

    @Override
    public void setProcessPeriod(int period) {
        this.processPeriod = period;
    }

    @Override
    public int getProcessPeriod() {
        return this.processPeriod;
    }

    private static class HttpResponse {
        private final int status;
        private final HandshakeResponse handshakeResponse;

        public HttpResponse(int status, HandshakeResponse handshakeResponse) {
            this.status = status;
            this.handshakeResponse = handshakeResponse;
        }

        public int getStatus() {
            return this.status;
        }

        public HandshakeResponse getHandshakeResponse() {
            return this.handshakeResponse;
        }
    }
}

