/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.parser.AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Literal;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.TheOriginalJDTParserClass;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class Parser
extends TheOriginalJDTParserClass {
    private static final String ASPECTJ_DECLARATION_FACTORY = "org.aspectj.ajdt.internal.compiler.parser.DeclarationFactory";
    private static IDeclarationFactory declarationFactory;
    protected int aspectIntPtr;
    protected int[] aspectIntStack;
    private static final boolean AJ_DEBUG = false;

    static {
        try {
            Parser.initTables(Parser.class);
            declarationFactory = (IDeclarationFactory)Class.forName(ASPECTJ_DECLARATION_FACTORY).newInstance();
        }
        catch (IOException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Warning: AspectJ declaration factory class not found on classpath");
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.aspectIntPtr = -1;
        this.aspectIntStack = new int[4];
    }

    @Override
    public void initialize(boolean initializeNLS) {
        super.initialize(initializeNLS);
        this.aspectIntPtr = -1;
        this.aspectIntStack = new int[4];
    }

    @Override
    public void initializeScanner() {
        this.scanner = new Scanner(false, false, this.options.getSeverity(256) != 256, this.options.sourceLevel, this.options.taskTags, this.options.taskPriorities, this.options.isTaskCaseSensitive);
    }

    void println(Object o) {
    }

    private void printStack(Object[] s, int p) {
        List<Object> list = Arrays.asList(s);
        System.out.println("  " + list.subList(0, p + 1));
    }

    private void printStack(int[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Integer.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(long[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Long.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(char[][] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(new String(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    public void display() {
    }

    @Override
    protected MethodDeclaration createMethodDeclaration(CompilationResult result) {
        return declarationFactory.createMethodDeclaration(result);
    }

    @Override
    protected ConstructorDeclaration createConstructorDeclaration(CompilationResult result) {
        return declarationFactory.createConstructorDeclaration(result);
    }

    @Override
    protected void consumeMethodInvocationName() {
        super.consumeMethodInvocationName();
        MessageSend m = (MessageSend)this.expressionStack[this.expressionPtr];
        if (CharOperation.equals(m.selector, "proceed".toCharArray())) {
            this.expressionStack[this.expressionPtr] = declarationFactory.createProceed(m);
        }
    }

    @Override
    protected void consumeToken(int type) {
        this.currentTokenStart = this.scanner.startPosition;
        super.consumeToken(type);
        switch (type) {
            case 27: {
                this.pushOnAspectIntStack(this.scanner.currentPosition - 1);
                this.pushOnAspectIntStack(this.scanner.startPosition);
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                this.pushIdentifier();
                this.flushCommentsDefinedPriorTo(this.currentTokenStart);
                this.scanner.commentPtr = -1;
            }
        }
    }

    protected void consumeAspectDeclaration() {
        this.consumeClassDeclaration();
    }

    protected void consumeAspectHeader() {
        this.consumeClassHeader();
    }

    protected void consumeAspectHeaderName(boolean isPrivileged) {
        TypeDeclaration aspectDecl = declarationFactory.createAspect(this.compilationUnit.compilationResult);
        if (this.nestedMethod[this.nestedType] == 0) {
            if (this.nestedType != 0) {
                aspectDecl.bits |= 0x400;
            }
        } else {
            aspectDecl.bits |= 0x100;
            this.markEnclosingMemberWithLocalType();
            this.blockReal();
        }
        this.println("aspect header name: ");
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        aspectDecl.sourceEnd = (int)pos;
        aspectDecl.sourceStart = (int)(pos >>> 32);
        aspectDecl.name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        aspectDecl.declarationSourceStart = this.aspectIntStack[this.aspectIntPtr--];
        --this.aspectIntPtr;
        this.eatIdentifier();
        if (isPrivileged) {
            pos = this.eatIdentifier();
            declarationFactory.setPrivileged(aspectDecl, true);
        }
        aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
        aspectDecl.modifiers = this.intStack[this.intPtr--];
        if (isPrivileged) {
            aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
            aspectDecl.modifiers |= this.intStack[this.intPtr--];
        }
        if (aspectDecl.modifiersSourceStart >= 0) {
            aspectDecl.declarationSourceStart = aspectDecl.modifiersSourceStart;
        }
        this.println("modifiers: " + aspectDecl.modifiers);
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            aspectDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, aspectDecl.annotations, 0, length);
        }
        aspectDecl.bodyStart = aspectDecl.sourceEnd + 1;
        this.pushOnAstStack(aspectDecl);
        this.listLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = aspectDecl.bodyStart;
            this.currentElement = this.currentElement.add(aspectDecl, 0);
            this.lastIgnoredToken = -1;
        }
        aspectDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.display();
    }

    protected void consumeAspectHeaderNameWithTypeParameters(boolean isPriviliged) {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        int length = this.genericsLengthStack[this.genericsLengthPtr--];
        this.genericsPtr -= length;
        typeDecl.typeParameters = new TypeParameter[length];
        System.arraycopy(this.genericsStack, this.genericsPtr + 1, typeDecl.typeParameters, 0, length);
        typeDecl.bodyStart = typeDecl.typeParameters[length - 1].declarationSourceEnd + 1;
        this.listTypeParameterLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = typeDecl.bodyStart;
        }
    }

    private long eatIdentifier() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        --this.identifierPtr;
        --this.identifierLengthPtr;
        return pos;
    }

    protected void consumeAspectHeaderRest() {
        this.concatNodeLists();
        this.display();
        ASTNode pseudoTokens = this.popPseudoTokens("{");
        this.println("pseudo: " + pseudoTokens);
        TypeDeclaration aspectDecl = (TypeDeclaration)this.astStack[this.astPtr];
        declarationFactory.setDominatesPatternFrom(aspectDecl, pseudoTokens, this);
        declarationFactory.setPerClauseFrom(aspectDecl, pseudoTokens, this);
    }

    protected void consumePointcutDeclaration() {
        this.consumePointcutDesignatorOnDeclaration();
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    public int getCurrentTokenStart() {
        return this.currentTokenStart;
    }

    protected void consumeEmptyPointcutDeclaration() {
        MethodDeclaration pcutDecl = (MethodDeclaration)this.astStack[this.astPtr];
        pcutDecl.bodyEnd = this.endStatementPosition;
    }

    protected void consumePointcutHeader() {
        MethodDeclaration ret = declarationFactory.createPointcutDeclaration(this.compilationUnit.compilationResult);
        long pos = this.identifierPositionStack[this.identifierPtr];
        ret.sourceStart = (int)(pos >>> 32);
        ret.selector = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ret.javadoc = this.javadoc;
        this.javadoc = null;
        this.eatIdentifier();
        ret.declarationSourceStart = this.intStack[this.intPtr--];
        ret.modifiers = this.intStack[this.intPtr--];
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            ret.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, ret.annotations, 0, length);
        }
        this.pushOnAstStack(ret);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeAroundDeclaration() {
        this.consumeMethodDeclaration(true, false);
    }

    protected void consumeAroundHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.resetModifiers();
        this.consumeMethodHeader();
    }

    protected void consumeAroundHeaderName() {
        int length;
        MethodDeclaration adviceDecl = declarationFactory.createAroundAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        adviceDecl.returnType = returnType;
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            adviceDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, adviceDecl.annotations, 0, length);
        }
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
    }

    protected void consumePointcutDesignatorOnAdvice() {
        ASTNode des = this.popPointcutDesignator("{");
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnAdvice(adviceDecl, des);
        adviceDecl.sourceEnd = des.sourceEnd;
        adviceDecl.bodyStart = des.sourceEnd + 1;
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumePointcutDesignatorOnDeclaration() {
        ASTNode des = this.popPointcutDesignator(";");
        MethodDeclaration pcutDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnPointcut(pcutDecl, des);
        pcutDecl.sourceEnd = des.sourceEnd;
        pcutDecl.bodyStart = des.sourceEnd + 1;
        pcutDecl.bodyEnd = this.endPosition;
        pcutDecl.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceDeclaration() {
        this.consumeMethodDeclaration(true, false);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.resetModifiers();
        this.consumeMethodHeader();
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceHeaderName(boolean isAfter) {
        int length;
        MethodDeclaration adviceDecl = isAfter ? declarationFactory.createAfterAdviceDeclaration(this.compilationUnit.compilationResult) : declarationFactory.createBeforeAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            adviceDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, adviceDecl.annotations, 0, length);
        }
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeExtraParameterWithFormal() {
        Argument arg = (Argument)this.astStack[this.astPtr--];
        --this.astLengthPtr;
        declarationFactory.setExtraArgument((MethodDeclaration)this.astStack[this.astPtr], arg);
        this.consumeExtraParameterNoFormal();
    }

    protected void consumeExtraParameterNoFormal() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.isAfterAdvice(adviceDecl);
        if (CharOperation.equals(name, "throwing".toCharArray())) {
            declarationFactory.setAfterThrowingAdviceKind(adviceDecl);
        } else if (CharOperation.equals(name, "returning".toCharArray())) {
            declarationFactory.setAfterReturningAdviceKind(adviceDecl);
        } else {
            this.problemReporter().parseError(start, end, this.currentToken, name, String.valueOf(name), new String[]{"throwing", "returning", ":"});
        }
    }

    protected void consumeClassBodyDeclarationInAspect() {
    }

    protected void consumeDeclareDeclaration() {
        this.concatNodeLists();
        ASTNode tokens = this.popPseudoTokens(";");
        MethodDeclaration declareDecl = declarationFactory.createDeclareDeclaration(this.compilationUnit.compilationResult, tokens, this);
        this.display();
        this.pushOnAstStack(declareDecl);
    }

    protected void consumeDeclareAnnotation(char kind) {
        this.concatNodeLists();
        ASTNode tokens = this.popPseudoTokens(";");
        Annotation[] annotations = new Annotation[1];
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, annotations, 0, length);
        }
        MethodDeclaration declareDecl = declarationFactory.createDeclareAnnotationDeclaration(this.compilationUnit.compilationResult, tokens, annotations[0], this, kind);
        this.pushOnAstStack(declareDecl);
    }

    protected void consumeDeclareAnnotationHeader() {
        this.consumePseudoTokenIdentifier();
        this.consumePseudoTokenIdentifier();
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken("@", 0, false);
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken(":", 0, false);
        this.consumePseudoTokens();
        this.display();
    }

    protected void consumeDeclareHeader() {
        this.consumePseudoTokenIdentifier();
        this.consumePseudoTokenIdentifier();
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken(":", 0, false);
        this.consumePseudoTokens();
        this.display();
    }

    protected void consumeInterTypeFieldHeader(boolean hasTypeParameters) {
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] identifierName = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (hasTypeParameters) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        this.display();
        int decSourceStart = this.intStack[this.intPtr--];
        int fieldModifiers = this.intStack[this.intPtr--];
        MethodDeclaration dec = declarationFactory.createInterTypeFieldDeclaration(this.compilationUnit.compilationResult, onType);
        dec.returnType = returnType;
        dec.sourceStart = start;
        dec.sourceEnd = end;
        declarationFactory.setSelector(dec, identifierName);
        dec.declarationSourceStart = decSourceStart;
        declarationFactory.setDeclaredModifiers(dec, fieldModifiers);
        dec.bodyEnd = this.endPosition;
        dec.javadoc = this.javadoc;
        this.javadoc = null;
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            dec.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, dec.annotations, 0, length);
        }
        this.pushOnAstStack(dec);
        this.println("consumed field: " + dec);
        this.display();
    }

    protected void consumeExitITDVariableWithoutInitializer() {
        MethodDeclaration itdDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setInitialization(itdDecl, null);
    }

    protected void consumeExitITDVariableWithInitializer() {
        --this.expressionLengthPtr;
        MethodDeclaration itdDecl = (MethodDeclaration)this.astStack[this.astPtr];
        Expression initialization = this.expressionStack[this.expressionPtr--];
        declarationFactory.setInitialization(itdDecl, initialization);
        itdDecl.declarationSourceEnd = initialization.sourceEnd;
    }

    protected void consumeInterTypeFieldDeclaration() {
        MethodDeclaration dec = (MethodDeclaration)this.astStack[this.astPtr];
        dec.bodyEnd = this.endPosition;
        dec.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
    }

    protected void consumeInterTypeMethodDeclaration(boolean isNotAbstract) {
        this.consumeMethodDeclaration(isNotAbstract, false);
    }

    protected void consumeInterTypeMethodHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeConstructorDeclaration() {
        this.consumeMethodDeclaration(true, false);
    }

    protected void consumeInterTypeConstructorHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeMethodHeaderName(boolean hasMethodTypeParameters, boolean hasGenericTypeParameters) {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeMethodDeclaration(this.compilationUnit.compilationResult);
        char[] name = this.identifierStack[this.identifierPtr];
        long selectorSource = this.identifierPositionStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (hasGenericTypeParameters) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        md.returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        if (hasMethodTypeParameters) {
            int tp_length = this.genericsLengthStack[this.genericsLengthPtr--];
            this.genericsPtr -= tp_length;
            md.typeParameters = new TypeParameter[tp_length];
            System.arraycopy(this.genericsStack, this.genericsPtr + 1, md.typeParameters, 0, tp_length);
        }
        declarationFactory.setOnType(md, onType);
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        md.sourceStart = (int)(selectorSource >>> 32);
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        declarationFactory.setSelector(md, name);
        this.listLength = 0;
        md.javadoc = this.javadoc;
        this.javadoc = null;
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            md.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, md.annotations, 0, length);
        }
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType || this.scanner.getLineNumber(md.returnType.sourceStart) == this.scanner.getLineNumber(md.sourceStart)) {
                this.lastCheckPoint = md.bodyStart;
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumeInterTypeConstructorHeaderName(boolean hasConstructorTypeParameters, boolean hasTargetTypeParameters) {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeConstructorDeclaration(this.compilationUnit.compilationResult);
        if (!hasTargetTypeParameters) {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(md, onType);
        this.println("got onType: " + onType);
        this.display();
        --this.intPtr;
        md.returnType = TypeReference.baseTypeReference(6, 0, null);
        if (hasConstructorTypeParameters) {
            int tp_length = this.genericsLengthStack[this.genericsLengthPtr--];
            this.genericsPtr -= tp_length;
            md.typeParameters = new TypeParameter[tp_length];
            System.arraycopy(this.genericsStack, this.genericsPtr + 1, md.typeParameters, 0, tp_length);
        }
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            md.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, md.annotations, 0, length);
        }
        md.sourceStart = onType.sourceStart;
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        this.listLength = 0;
        declarationFactory.setSelector(md, (String.valueOf(new String(CharOperation.concatWith(onType.getTypeName(), '_'))) + "_new").toCharArray());
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType) {
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumePseudoToken(String value) {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.consumePseudoToken(value, 0, false);
    }

    protected void consumePseudoToken(String value, int popFromIntStack, boolean isIdentifier) {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.intPtr -= popFromIntStack;
        int start = this.currentTokenStart;
        int end = start + value.length() - 1;
        ASTNode tok = declarationFactory.createPseudoToken(this, value, isIdentifier);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIdentifier() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(name), true);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIf() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        Expression expr = this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        this.println("expr: " + expr);
        int start = this.intStack[this.intPtr--];
        ASTNode tok = declarationFactory.createIfPseudoToken(this, expr);
        tok.sourceStart = start;
        tok.sourceEnd = this.rParenPos;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenLiteral() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        Literal literal = (Literal)this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(literal.source()), false);
        declarationFactory.setLiteralKind(tok, "string");
        tok.sourceStart = literal.sourceStart;
        tok.sourceEnd = literal.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenModifier() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.consumePseudoToken(Modifier.toString(this.modifiers), 0, true);
        this.modifiers = 0;
    }

    protected void consumePseudoTokenPrimitiveType() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        TypeReference type = this.getTypeReference(0);
        ASTNode tok = declarationFactory.createPseudoToken(this, type.toString(), true);
        tok.sourceStart = type.sourceStart;
        tok.sourceEnd = type.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokens() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.optimizedConcatNodeLists();
    }

    @Override
    protected void consumeRule(int act) {
        switch (act) {
            case 41: {
                this.consumePrimitiveType();
                break;
            }
            case 55: {
                this.consumeReferenceType();
                break;
            }
            case 59: {
                this.consumeClassOrInterfaceName();
                break;
            }
            case 60: {
                this.consumeClassOrInterface();
                break;
            }
            case 61: {
                this.consumeGenericType();
                break;
            }
            case 62: {
                this.consumeGenericTypeWithDiamond();
                break;
            }
            case 63: {
                this.consumeArrayTypeWithTypeArgumentsName();
                break;
            }
            case 64: {
                this.consumePrimitiveArrayType();
                break;
            }
            case 65: {
                this.consumeNameArrayType();
                break;
            }
            case 66: {
                this.consumeGenericTypeNameArrayType();
                break;
            }
            case 67: {
                this.consumeGenericTypeArrayType();
                break;
            }
            case 73: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 74: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 83: {
                this.consumeQualifiedName();
                break;
            }
            case 86: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 91: {
                this.consumeUnannotatableQualifiedName();
                break;
            }
            case 92: {
                this.consumeQualifiedName(false);
                break;
            }
            case 93: {
                this.consumeQualifiedName(true);
                break;
            }
            case 94: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 98: {
                this.consumeOneMoreTypeAnnotation();
                break;
            }
            case 99: {
                this.consumeTypeAnnotation();
                break;
            }
            case 100: {
                this.consumeTypeAnnotation();
                break;
            }
            case 101: {
                this.consumeTypeAnnotation();
                break;
            }
            case 102: {
                this.consumeAnnotationName();
                break;
            }
            case 103: {
                this.consumeNormalAnnotation(true);
                break;
            }
            case 104: {
                this.consumeMarkerAnnotation(true);
                break;
            }
            case 105: {
                this.consumeSingleMemberAnnotation(true);
                break;
            }
            case 106: {
                this.consumeNonTypeUseName();
                break;
            }
            case 107: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 108: {
                this.consumeExplicitThisParameter(false);
                break;
            }
            case 109: {
                this.consumeExplicitThisParameter(true);
                break;
            }
            case 110: {
                this.consumeVariableDeclaratorIdParameter();
                break;
            }
            case 111: {
                this.consumeCompilationUnit();
                break;
            }
            case 112: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 113: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 114: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 115: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 116: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 117: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 118: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 119: {
                this.consumeEmptyInternalCompilationUnit();
                break;
            }
            case 120: {
                this.consumeInternalCompilationUnitWithModuleDeclaration();
                break;
            }
            case 121: {
                this.consumeInternalCompilationUnitWithModuleDeclaration();
                break;
            }
            case 122: {
                this.consumeModuleDeclaration();
                break;
            }
            case 123: {
                this.consumeModuleHeader();
                break;
            }
            case 125: {
                this.consumeModuleModifiers();
                break;
            }
            case 128: {
                this.consumeEmptyModuleStatementsOpt();
                break;
            }
            case 131: {
                this.consumeModuleStatements();
                break;
            }
            case 137: {
                this.consumeRequiresStatement();
                break;
            }
            case 138: {
                this.consumeSingleRequiresModuleName();
                break;
            }
            case 139: {
                this.consumeModifiers();
                break;
            }
            case 140: {
                this.consumeDefaultModifiers();
                break;
            }
            case 142: {
                this.consumeModifiers2();
                break;
            }
            case 145: {
                this.consumeExportsStatement();
                break;
            }
            case 146: {
                this.consumeExportsHeader();
                break;
            }
            case 148: {
                this.consumeTargetModuleList();
                break;
            }
            case 149: {
                this.consumeSingleTargetModuleName();
                break;
            }
            case 151: {
                this.consumeTargetModuleNameList();
                break;
            }
            case 152: {
                this.consumeSinglePkgName();
                break;
            }
            case 153: {
                this.consumeOpensStatement();
                break;
            }
            case 154: {
                this.consumeOpensHeader();
                break;
            }
            case 155: {
                this.consumeUsesStatement();
                break;
            }
            case 156: {
                this.consumeUsesHeader();
                break;
            }
            case 157: {
                this.consumeProvidesStatement();
                break;
            }
            case 158: {
                this.consumeProvidesInterface();
                break;
            }
            case 159: {
                this.consumeSingleServiceImplName();
                break;
            }
            case 161: {
                this.consumeServiceImplNameList();
                break;
            }
            case 162: {
                this.consumeWithClause();
                break;
            }
            case 163: {
                this.consumeReduceImports();
                break;
            }
            case 164: {
                this.consumeEnterCompilationUnit();
                break;
            }
            case 186: {
                this.consumeCatchHeader();
                break;
            }
            case 188: {
                this.consumeImportDeclarations();
                break;
            }
            case 190: {
                this.consumeTypeDeclarations();
                break;
            }
            case 191: {
                this.consumePackageDeclaration();
                break;
            }
            case 192: {
                this.consumePackageDeclarationNameWithModifiers();
                break;
            }
            case 193: {
                this.consumePackageDeclarationName();
                break;
            }
            case 194: {
                this.consumePackageComment();
                break;
            }
            case 199: {
                this.consumeImportDeclaration();
                break;
            }
            case 200: {
                this.consumeSingleTypeImportDeclarationName();
                break;
            }
            case 201: {
                this.consumeImportDeclaration();
                break;
            }
            case 202: {
                this.consumeTypeImportOnDemandDeclarationName();
                break;
            }
            case 205: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 209: {
                this.consumeModifiers2();
                break;
            }
            case 222: {
                this.consumeAnnotationAsModifier();
                break;
            }
            case 235: {
                this.consumeAspectDeclaration();
                break;
            }
            case 236: {
                this.consumeAspectHeader();
                break;
            }
            case 239: {
                this.consumeAspectHeaderNameWithTypeParameters(false);
                break;
            }
            case 240: {
                this.consumeAspectHeaderNameWithTypeParameters(true);
                break;
            }
            case 241: {
                this.consumeAspectHeaderName(false);
                break;
            }
            case 242: {
                this.consumeAspectHeaderName(true);
                break;
            }
            case 244: {
                this.consumeAspectHeaderRest();
                break;
            }
            case 245: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 248: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 249: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 250: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 251: {
                this.consumeClassBodyDeclarationInAspect();
                break;
            }
            case 255: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 265: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 267: {
                this.consumeMethodDeclaration(true, false);
                break;
            }
            case 268: {
                this.consumeMethodDeclaration(false, false);
                break;
            }
            case 269: {
                this.consumeMethodHeader();
                break;
            }
            case 270: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 271: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 272: {
                this.consumeEmptyPointcutDeclaration();
                break;
            }
            case 273: {
                this.consumePointcutDeclaration();
                break;
            }
            case 274: {
                this.consumePointcutHeader();
                break;
            }
            case 277: {
                this.consumeAroundDeclaration();
                break;
            }
            case 278: {
                this.consumeAroundHeader();
                break;
            }
            case 279: {
                this.consumeAroundHeaderName();
                break;
            }
            case 280: {
                this.consumeAroundHeaderNameMissingReturnType();
                break;
            }
            case 281: {
                this.consumeBasicAdviceDeclaration();
                break;
            }
            case 284: {
                this.consumeBasicAdviceHeader();
                break;
            }
            case 285: {
                this.consumeBasicAdviceHeader();
                break;
            }
            case 286: {
                this.consumeBasicAdviceHeaderName(false);
                break;
            }
            case 287: {
                this.consumeBasicAdviceHeaderName(true);
                break;
            }
            case 288: {
                this.consumeExtraParameterWithFormal();
                break;
            }
            case 289: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 290: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 292: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 293: {
                this.consumeZeroTypeAnnotations();
                this.consumeQualifiedName();
                break;
            }
            case 298: {
                this.consumeInterTypeMethodDeclaration(true);
                break;
            }
            case 299: {
                this.consumeInterTypeMethodHeader();
                break;
            }
            case 300: {
                this.consumeInterTypeMethodHeaderName(false, false);
                break;
            }
            case 301: {
                this.consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern("*");
                break;
            }
            case 302: {
                this.consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern("+");
                break;
            }
            case 303: {
                this.consumeInterTypeMethodHeaderName(false, true);
                break;
            }
            case 304: {
                this.consumeInterTypeMethodHeaderName(true, false);
                break;
            }
            case 305: {
                this.consumeInterTypeMethodHeaderName(true, true);
                break;
            }
            case 306: {
                this.consumeInterTypeMethodDeclaration(false);
                break;
            }
            case 307: {
                this.convertTypeParametersToSingleTypeReferences();
                break;
            }
            case 308: {
                this.consumeInterTypeConstructorDeclaration();
                break;
            }
            case 309: {
                this.consumeInterTypeConstructorHeader();
                break;
            }
            case 310: {
                this.consumeInterTypeConstructorHeaderName(false, false);
                break;
            }
            case 311: {
                this.consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern("*");
                break;
            }
            case 312: {
                this.consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern("+");
                break;
            }
            case 313: {
                this.consumeInterTypeConstructorHeaderName(true, false);
                break;
            }
            case 314: {
                this.consumeInterTypeConstructorHeaderName(false, true);
                break;
            }
            case 315: {
                this.consumeInterTypeConstructorHeaderName(true, true);
                break;
            }
            case 316: {
                this.consumeInterTypeFieldDeclaration();
                break;
            }
            case 317: {
                this.consumeInterTypeFieldHeader(false);
                break;
            }
            case 318: {
                this.consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern("*");
                break;
            }
            case 319: {
                this.consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern("+");
                break;
            }
            case 320: {
                this.consumeInterTypeFieldHeader(true);
                break;
            }
            case 321: {
                this.consumeExitITDVariableWithoutInitializer();
                break;
            }
            case 322: {
                this.consumeExitITDVariableWithInitializer();
                break;
            }
            case 324: {
                this.consumeDeclareDeclaration();
                break;
            }
            case 325: {
                this.consumeDeclareHeader();
                break;
            }
            case 326: {
                this.consumeDeclareAnnotation(' ');
                break;
            }
            case 327: {
                this.consumeDeclareAnnotation('+');
                break;
            }
            case 328: {
                this.consumeDeclareAnnotation('-');
                break;
            }
            case 331: {
                this.consumeDeclareAnnotationHeader();
                break;
            }
            case 334: {
                this.consumePseudoTokens();
                break;
            }
            case 335: {
                this.consumePseudoTokens();
                break;
            }
            case 337: {
                this.consumePseudoTokens();
                break;
            }
            case 338: {
                this.consumePseudoToken(":");
                break;
            }
            case 339: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 340: {
                this.consumePseudoToken("(");
                break;
            }
            case 341: {
                this.consumePseudoToken(")");
                break;
            }
            case 342: {
                this.consumePseudoToken(".");
                break;
            }
            case 343: {
                this.consumePseudoToken("*");
                break;
            }
            case 344: {
                this.consumePseudoToken("+");
                break;
            }
            case 345: {
                this.consumePseudoToken("=");
                break;
            }
            case 346: {
                this.consumePseudoToken("&&");
                break;
            }
            case 347: {
                this.consumePseudoToken("||");
                break;
            }
            case 348: {
                this.consumePseudoToken("!");
                break;
            }
            case 349: {
                this.consumePseudoToken(",");
                break;
            }
            case 350: {
                this.consumePseudoToken("[");
                break;
            }
            case 351: {
                this.consumePseudoToken("]");
                break;
            }
            case 352: {
                this.consumePseudoToken("@");
                break;
            }
            case 353: {
                this.consumePseudoToken("...");
                break;
            }
            case 354: {
                this.consumePseudoToken("?");
                break;
            }
            case 355: {
                this.consumePseudoToken("<");
                break;
            }
            case 356: {
                this.consumePseudoToken(">");
                break;
            }
            case 357: {
                this.consumePseudoToken(">>");
                break;
            }
            case 358: {
                this.consumePseudoToken(">>>");
                break;
            }
            case 359: {
                this.consumePseudoToken("&");
                break;
            }
            case 360: {
                this.consumePseudoToken("!=");
                break;
            }
            case 361: {
                this.consumePseudoTokenPrimitiveType();
                break;
            }
            case 362: {
                this.consumePseudoTokenModifier();
                break;
            }
            case 363: {
                this.consumePseudoTokenLiteral();
                break;
            }
            case 364: {
                this.consumePseudoToken("this", 1, true);
                break;
            }
            case 365: {
                this.consumePseudoToken("class", 1, true);
                break;
            }
            case 366: {
                this.consumePseudoToken("super", 1, true);
                break;
            }
            case 367: {
                this.consumePseudoTokenIf();
                break;
            }
            case 368: {
                this.consumePseudoToken("assert", 1, true);
                break;
            }
            case 369: {
                this.consumePseudoToken("import", 1, true);
                break;
            }
            case 370: {
                this.consumePseudoToken("package", 1, true);
                break;
            }
            case 371: {
                this.consumePseudoToken("throw", 1, true);
                break;
            }
            case 372: {
                this.consumePseudoToken("new", 1, true);
                break;
            }
            case 373: {
                this.consumePseudoToken("do", 1, true);
                break;
            }
            case 374: {
                this.consumePseudoToken("for", 1, true);
                break;
            }
            case 375: {
                this.consumePseudoToken("switch", 1, true);
                break;
            }
            case 376: {
                this.consumePseudoToken("try", 1, true);
                break;
            }
            case 377: {
                this.consumePseudoToken("while", 1, true);
                break;
            }
            case 378: {
                this.consumePseudoToken("break", 1, true);
                break;
            }
            case 379: {
                this.consumePseudoToken("continue", 1, true);
                break;
            }
            case 380: {
                this.consumePseudoToken("return", 1, true);
                break;
            }
            case 381: {
                this.consumePseudoToken("case", 1, true);
                break;
            }
            case 382: {
                this.consumePseudoToken("catch", 0, true);
                break;
            }
            case 383: {
                this.consumePseudoToken("instanceof", 0, true);
                break;
            }
            case 384: {
                this.consumePseudoToken("else", 0, true);
                break;
            }
            case 385: {
                this.consumePseudoToken("extends", 0, true);
                break;
            }
            case 386: {
                this.consumePseudoToken("finally", 0, true);
                break;
            }
            case 387: {
                this.consumePseudoToken("implements", 0, true);
                break;
            }
            case 388: {
                this.consumePseudoToken("throws", 0, true);
                break;
            }
            case 389: {
                this.consumeClassDeclaration();
                break;
            }
            case 390: {
                this.consumeIntertypeClassDeclaration();
                break;
            }
            case 391: {
                this.consumeIntertypeClassHeader();
                break;
            }
            case 392: {
                this.consumeIntertypeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 394: {
                this.consumeIntertypeClassHeaderName(false);
                break;
            }
            case 395: {
                this.consumeIntertypeClassHeaderName(true);
                break;
            }
            case 396: {
                this.consumeClassHeader();
                break;
            }
            case 397: {
                this.consumeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 399: {
                this.consumeClassHeaderName1();
                break;
            }
            case 400: {
                this.consumeClassHeaderExtends();
                break;
            }
            case 401: {
                this.consumeClassHeaderImplements();
                break;
            }
            case 403: {
                this.consumeInterfaceTypeList();
                break;
            }
            case 404: {
                this.consumeInterfaceType();
                break;
            }
            case 407: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 411: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 412: {
                this.consumeDiet();
                break;
            }
            case 413: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 414: {
                this.consumeCreateInitializer();
                break;
            }
            case 421: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 424: {
                this.consumeFieldDeclaration();
                break;
            }
            case 426: {
                this.consumeVariableDeclarators();
                break;
            }
            case 429: {
                this.consumeEnterVariable();
                break;
            }
            case 430: {
                this.consumeExitVariableWithInitialization();
                break;
            }
            case 431: {
                this.consumeExitVariableWithoutInitialization();
                break;
            }
            case 432: {
                this.consumeForceNoDiet();
                break;
            }
            case 433: {
                this.consumeRestoreDiet();
                break;
            }
            case 438: {
                this.consumeMethodDeclaration(true, false);
                break;
            }
            case 439: {
                this.consumeMethodDeclaration(true, true);
                break;
            }
            case 440: {
                this.consumeMethodDeclaration(false, false);
                break;
            }
            case 441: {
                this.consumeMethodHeader();
                break;
            }
            case 442: {
                this.consumeMethodHeader();
                break;
            }
            case 443: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 444: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 445: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 446: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 447: {
                this.consumePushCombineModifiers();
                break;
            }
            case 448: {
                this.consumeMethodHeaderRightParen();
                break;
            }
            case 449: {
                this.consumeMethodHeaderExtendedDims();
                break;
            }
            case 450: {
                this.consumeMethodHeaderThrowsClause();
                break;
            }
            case 451: {
                this.consumeConstructorHeader();
                break;
            }
            case 452: {
                this.consumeConstructorHeaderNameWithTypeParameters();
                break;
            }
            case 453: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 454: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 456: {
                this.consumeFormalParameterList();
                break;
            }
            case 457: {
                this.consumeFormalParameter(false);
                break;
            }
            case 458: {
                this.consumeFormalParameter(true);
                break;
            }
            case 459: {
                this.consumeFormalParameter(true);
                break;
            }
            case 460: {
                this.consumeCatchFormalParameter();
                break;
            }
            case 461: {
                this.consumeCatchType();
                break;
            }
            case 462: {
                this.consumeUnionTypeAsClassType();
                break;
            }
            case 463: {
                this.consumeUnionType();
                break;
            }
            case 465: {
                this.consumeClassTypeList();
                break;
            }
            case 466: {
                this.consumeClassTypeElt();
                break;
            }
            case 467: {
                this.consumeMethodBody();
                break;
            }
            case 468: {
                this.consumeNestedMethod();
                break;
            }
            case 469: {
                this.consumeStaticInitializer();
                break;
            }
            case 470: {
                this.consumeStaticOnly();
                break;
            }
            case 471: {
                this.consumeConstructorDeclaration();
                break;
            }
            case 472: {
                this.consumeInvalidConstructorDeclaration();
                break;
            }
            case 473: {
                this.consumeExplicitConstructorInvocation(0, 3);
                break;
            }
            case 474: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(0, 3);
                break;
            }
            case 475: {
                this.consumeExplicitConstructorInvocation(0, 2);
                break;
            }
            case 476: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(0, 2);
                break;
            }
            case 477: {
                this.consumeExplicitConstructorInvocation(1, 2);
                break;
            }
            case 478: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(1, 2);
                break;
            }
            case 479: {
                this.consumeExplicitConstructorInvocation(2, 2);
                break;
            }
            case 480: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(2, 2);
                break;
            }
            case 481: {
                this.consumeExplicitConstructorInvocation(1, 3);
                break;
            }
            case 482: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(1, 3);
                break;
            }
            case 483: {
                this.consumeExplicitConstructorInvocation(2, 3);
                break;
            }
            case 484: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(2, 3);
                break;
            }
            case 485: {
                this.consumeInterfaceDeclaration();
                break;
            }
            case 486: {
                this.consumeInterfaceHeader();
                break;
            }
            case 487: {
                this.consumeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 489: {
                this.consumeInterfaceHeaderName1();
                break;
            }
            case 490: {
                this.consumeInterfaceHeaderExtends();
                break;
            }
            case 493: {
                this.consumeInterfaceMemberDeclarations();
                break;
            }
            case 494: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 496: {
                this.consumeInterfaceMethodDeclaration(false);
                break;
            }
            case 497: {
                this.consumeInterfaceMethodDeclaration(false);
                break;
            }
            case 498: {
                this.consumeInterfaceMethodDeclaration(true);
                break;
            }
            case 499: {
                this.consumeInvalidConstructorDeclaration(true);
                break;
            }
            case 500: {
                this.consumeInvalidConstructorDeclaration(false);
                break;
            }
            case 511: {
                this.consumePushLeftBrace();
                break;
            }
            case 512: {
                this.consumeEmptyArrayInitializer();
                break;
            }
            case 513: {
                this.consumeArrayInitializer();
                break;
            }
            case 514: {
                this.consumeArrayInitializer();
                break;
            }
            case 516: {
                this.consumeVariableInitializers();
                break;
            }
            case 517: {
                this.consumeBlock();
                break;
            }
            case 518: {
                this.consumeOpenBlock();
                break;
            }
            case 519: {
                this.consumeBlockStatement();
                break;
            }
            case 520: {
                this.consumeBlockStatements();
                break;
            }
            case 527: {
                this.consumeInvalidInterfaceDeclaration();
                break;
            }
            case 528: {
                this.consumeInvalidAnnotationTypeDeclaration();
                break;
            }
            case 529: {
                this.consumeInvalidEnumDeclaration();
                break;
            }
            case 530: {
                this.consumeLocalVariableDeclarationStatement();
                break;
            }
            case 531: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 532: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 533: {
                this.consumePushModifiers();
                break;
            }
            case 534: {
                this.consumePushModifiersForHeader();
                break;
            }
            case 535: {
                this.consumePushRealModifiers();
                break;
            }
            case 563: {
                this.consumeEmptyStatement();
                break;
            }
            case 564: {
                this.consumeStatementLabel();
                break;
            }
            case 565: {
                this.consumeStatementLabel();
                break;
            }
            case 566: {
                this.consumeLabel();
                break;
            }
            case 567: {
                this.consumeExpressionStatement();
                break;
            }
            case 576: {
                this.consumeStatementIfNoElse();
                break;
            }
            case 577: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 578: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 579: {
                this.consumeStatementSwitch();
                break;
            }
            case 580: {
                this.consumeEmptySwitchBlock();
                break;
            }
            case 583: {
                this.consumeSwitchBlock();
                break;
            }
            case 585: {
                this.consumeSwitchBlockStatements();
                break;
            }
            case 587: {
                this.consumeSwitchBlockStatement();
                break;
            }
            case 589: {
                this.consumeSwitchLabels();
                break;
            }
            case 590: {
                this.consumeCaseLabel();
                break;
            }
            case 591: {
                this.consumeDefaultLabel();
                break;
            }
            case 594: {
                this.consumeSwitchExpression();
                break;
            }
            case 597: {
                this.consumeSwitchLabeledRule();
                break;
            }
            case 598: {
                this.consumeSwitchLabeledExpression();
                break;
            }
            case 599: {
                this.consumeSwitchLabeledBlock();
                break;
            }
            case 600: {
                this.consumeSwitchLabeledThrowStatement();
                break;
            }
            case 601: {
                this.consumeDefaultLabelExpr();
                break;
            }
            case 602: {
                this.consumeCaseLabelExpr();
                break;
            }
            case 603: {
                this.consumeSwitchLabelCaseLhs();
                break;
            }
            case 604: {
                this.consumeStatementYield();
                break;
            }
            case 605: {
                this.consumeStatementWhile();
                break;
            }
            case 606: {
                this.consumeStatementWhile();
                break;
            }
            case 607: {
                this.consumeStatementDo();
                break;
            }
            case 608: {
                this.consumeStatementFor();
                break;
            }
            case 609: {
                this.consumeStatementFor();
                break;
            }
            case 610: {
                this.consumeForInit();
                break;
            }
            case 614: {
                this.consumeStatementExpressionList();
                break;
            }
            case 615: {
                this.consumeSimpleAssertStatement();
                break;
            }
            case 616: {
                this.consumeAssertStatement();
                break;
            }
            case 617: {
                this.consumeStatementBreak();
                break;
            }
            case 618: {
                this.consumeStatementBreakWithLabel();
                break;
            }
            case 619: {
                this.consumeStatementContinue();
                break;
            }
            case 620: {
                this.consumeStatementContinueWithLabel();
                break;
            }
            case 621: {
                this.consumeStatementReturn();
                break;
            }
            case 622: {
                this.consumeStatementThrow();
                break;
            }
            case 623: {
                this.consumeThrowExpression();
                break;
            }
            case 624: {
                this.consumeStatementSynchronized();
                break;
            }
            case 625: {
                this.consumeOnlySynchronized();
                break;
            }
            case 626: {
                this.consumeStatementTry(false, false);
                break;
            }
            case 627: {
                this.consumeStatementTry(true, false);
                break;
            }
            case 628: {
                this.consumeStatementTry(false, true);
                break;
            }
            case 629: {
                this.consumeStatementTry(true, true);
                break;
            }
            case 630: {
                this.consumeResourceSpecification();
                break;
            }
            case 631: {
                this.consumeResourceOptionalTrailingSemiColon(false);
                break;
            }
            case 632: {
                this.consumeResourceOptionalTrailingSemiColon(true);
                break;
            }
            case 633: {
                this.consumeSingleResource();
                break;
            }
            case 634: {
                this.consumeMultipleResources();
                break;
            }
            case 635: {
                this.consumeResourceOptionalTrailingSemiColon(true);
                break;
            }
            case 636: {
                this.consumeResourceAsLocalVariableDeclaration();
                break;
            }
            case 637: {
                this.consumeResourceAsLocalVariableDeclaration();
                break;
            }
            case 638: {
                this.consumeResourceAsLocalVariable();
                break;
            }
            case 639: {
                this.consumeResourceAsFieldAccess();
                break;
            }
            case 641: {
                this.consumeExitTryBlock();
                break;
            }
            case 643: {
                this.consumeCatches();
                break;
            }
            case 644: {
                this.consumeStatementCatch();
                break;
            }
            case 646: {
                this.consumeLeftParen();
                break;
            }
            case 647: {
                this.consumeRightParen();
                break;
            }
            case 652: {
                this.consumePrimaryNoNewArrayThis();
                break;
            }
            case 653: {
                this.consumePrimaryNoNewArray();
                break;
            }
            case 654: {
                this.consumePrimaryNoNewArrayWithName();
                break;
            }
            case 657: {
                this.consumePrimaryNoNewArrayNameThis();
                break;
            }
            case 658: {
                this.consumeQualifiedSuperReceiver();
                break;
            }
            case 659: {
                this.consumePrimaryNoNewArrayName();
                break;
            }
            case 660: {
                this.consumePrimaryNoNewArrayArrayType();
                break;
            }
            case 661: {
                this.consumePrimaryNoNewArrayPrimitiveArrayType();
                break;
            }
            case 662: {
                this.consumePrimaryNoNewArrayPrimitiveType();
                break;
            }
            case 668: {
                this.consumeReferenceExpressionTypeArgumentsAndTrunk(false);
                break;
            }
            case 669: {
                this.consumeReferenceExpressionTypeArgumentsAndTrunk(true);
                break;
            }
            case 670: {
                this.consumeReferenceExpressionTypeForm(true);
                break;
            }
            case 671: {
                this.consumeReferenceExpressionTypeForm(false);
                break;
            }
            case 672: {
                this.consumeReferenceExpressionGenericTypeForm();
                break;
            }
            case 673: {
                this.consumeReferenceExpressionPrimaryForm();
                break;
            }
            case 674: {
                this.consumeReferenceExpressionPrimaryForm();
                break;
            }
            case 675: {
                this.consumeReferenceExpressionSuperForm();
                break;
            }
            case 676: {
                this.consumeEmptyTypeArguments();
                break;
            }
            case 678: {
                this.consumeIdentifierOrNew(false);
                break;
            }
            case 679: {
                this.consumeIdentifierOrNew(true);
                break;
            }
            case 680: {
                this.consumeLambdaExpression();
                break;
            }
            case 681: {
                this.consumeNestedLambda();
                break;
            }
            case 682: {
                this.consumeTypeElidedLambdaParameter(false);
                break;
            }
            case 688: {
                this.consumeFormalParameterList();
                break;
            }
            case 689: {
                this.consumeTypeElidedLambdaParameter(true);
                break;
            }
            case 692: {
                this.consumeElidedLeftBraceAndReturn();
                break;
            }
            case 693: {
                this.consumeAllocationHeader();
                break;
            }
            case 694: {
                this.consumeClassInstanceCreationExpressionWithTypeArguments();
                break;
            }
            case 695: {
                this.consumeClassInstanceCreationExpression();
                break;
            }
            case 696: {
                this.consumeClassInstanceCreationExpressionQualifiedWithTypeArguments();
                break;
            }
            case 697: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 698: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 699: {
                this.consumeClassInstanceCreationExpressionQualifiedWithTypeArguments();
                break;
            }
            case 700: {
                this.consumeEnterInstanceCreationArgumentList();
                break;
            }
            case 701: {
                this.consumeClassInstanceCreationExpressionName();
                break;
            }
            case 702: {
                this.consumeClassBodyopt();
                break;
            }
            case 704: {
                this.consumeEnterAnonymousClassBody(false);
                break;
            }
            case 705: {
                this.consumeClassBodyopt();
                break;
            }
            case 707: {
                this.consumeEnterAnonymousClassBody(true);
                break;
            }
            case 709: {
                this.consumeArgumentList();
                break;
            }
            case 710: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 711: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 712: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 713: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 714: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 715: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 717: {
                this.consumeDimWithOrWithOutExprs();
                break;
            }
            case 719: {
                this.consumeDimWithOrWithOutExpr();
                break;
            }
            case 720: {
                this.consumeDims();
                break;
            }
            case 723: {
                this.consumeOneDimLoop(false);
                break;
            }
            case 724: {
                this.consumeOneDimLoop(true);
                break;
            }
            case 725: {
                this.consumeFieldAccess(false);
                break;
            }
            case 726: {
                this.consumeFieldAccess(true);
                break;
            }
            case 727: {
                this.consumeFieldAccess(false);
                break;
            }
            case 728: {
                this.consumeMethodInvocationName();
                break;
            }
            case 729: {
                this.consumeMethodInvocationNameWithTypeArguments();
                break;
            }
            case 730: {
                this.consumeMethodInvocationPrimaryWithTypeArguments();
                break;
            }
            case 731: {
                this.consumeMethodInvocationPrimary();
                break;
            }
            case 732: {
                this.consumeMethodInvocationPrimary();
                break;
            }
            case 733: {
                this.consumeMethodInvocationPrimaryWithTypeArguments();
                break;
            }
            case 734: {
                this.consumeMethodInvocationSuperWithTypeArguments();
                break;
            }
            case 735: {
                this.consumeMethodInvocationSuper();
                break;
            }
            case 736: {
                this.consumeArrayAccess(true);
                break;
            }
            case 737: {
                this.consumeArrayAccess(true);
                break;
            }
            case 738: {
                this.consumeArrayAccess(false);
                break;
            }
            case 739: {
                this.consumeArrayAccess(false);
                break;
            }
            case 741: {
                this.consumePostfixExpression();
                break;
            }
            case 744: {
                this.consumeUnaryExpression(14, true);
                break;
            }
            case 745: {
                this.consumeUnaryExpression(13, true);
                break;
            }
            case 746: {
                this.consumePushPosition();
                break;
            }
            case 749: {
                this.consumeUnaryExpression(14);
                break;
            }
            case 750: {
                this.consumeUnaryExpression(13);
                break;
            }
            case 752: {
                this.consumeUnaryExpression(14, false);
                break;
            }
            case 753: {
                this.consumeUnaryExpression(13, false);
                break;
            }
            case 755: {
                this.consumeUnaryExpression(12);
                break;
            }
            case 756: {
                this.consumeUnaryExpression(11);
                break;
            }
            case 758: {
                this.consumeCastExpressionWithPrimitiveType();
                break;
            }
            case 759: {
                this.consumeCastExpressionWithGenericsArray();
                break;
            }
            case 760: {
                this.consumeCastExpressionWithQualifiedGenericsArray();
                break;
            }
            case 761: {
                this.consumeCastExpressionLL1();
                break;
            }
            case 762: {
                this.consumeCastExpressionLL1WithBounds();
                break;
            }
            case 763: {
                this.consumeCastExpressionWithNameArray();
                break;
            }
            case 764: {
                this.consumeZeroAdditionalBounds();
                break;
            }
            case 768: {
                this.consumeOnlyTypeArgumentsForCastExpression();
                break;
            }
            case 769: {
                this.consumeInsideCastExpression();
                break;
            }
            case 770: {
                this.consumeInsideCastExpressionLL1();
                break;
            }
            case 771: {
                this.consumeInsideCastExpressionLL1WithBounds();
                break;
            }
            case 772: {
                this.consumeInsideCastExpressionWithQualifiedGenerics();
                break;
            }
            case 774: {
                this.consumeBinaryExpression(15);
                break;
            }
            case 775: {
                this.consumeBinaryExpression(9);
                break;
            }
            case 776: {
                this.consumeBinaryExpression(16);
                break;
            }
            case 778: {
                this.consumeBinaryExpression(14);
                break;
            }
            case 779: {
                this.consumeBinaryExpression(13);
                break;
            }
            case 781: {
                this.consumeBinaryExpression(10);
                break;
            }
            case 782: {
                this.consumeBinaryExpression(17);
                break;
            }
            case 783: {
                this.consumeBinaryExpression(19);
                break;
            }
            case 785: {
                this.consumeBinaryExpression(4);
                break;
            }
            case 786: {
                this.consumeBinaryExpression(6);
                break;
            }
            case 787: {
                this.consumeBinaryExpression(5);
                break;
            }
            case 788: {
                this.consumeBinaryExpression(7);
                break;
            }
            case 790: {
                this.consumeInstanceOfExpression();
                break;
            }
            case 792: {
                this.consumeEqualityExpression(18);
                break;
            }
            case 793: {
                this.consumeEqualityExpression(29);
                break;
            }
            case 795: {
                this.consumeBinaryExpression(2);
                break;
            }
            case 797: {
                this.consumeBinaryExpression(8);
                break;
            }
            case 799: {
                this.consumeBinaryExpression(3);
                break;
            }
            case 801: {
                this.consumeBinaryExpression(0);
                break;
            }
            case 803: {
                this.consumeBinaryExpression(1);
                break;
            }
            case 805: {
                this.consumeConditionalExpression(23);
                break;
            }
            case 808: {
                this.consumeAssignment();
                break;
            }
            case 810: {
                this.ignoreExpressionAssignment();
                break;
            }
            case 811: {
                this.consumeAssignmentOperator(30);
                break;
            }
            case 812: {
                this.consumeAssignmentOperator(15);
                break;
            }
            case 813: {
                this.consumeAssignmentOperator(9);
                break;
            }
            case 814: {
                this.consumeAssignmentOperator(16);
                break;
            }
            case 815: {
                this.consumeAssignmentOperator(14);
                break;
            }
            case 816: {
                this.consumeAssignmentOperator(13);
                break;
            }
            case 817: {
                this.consumeAssignmentOperator(10);
                break;
            }
            case 818: {
                this.consumeAssignmentOperator(17);
                break;
            }
            case 819: {
                this.consumeAssignmentOperator(19);
                break;
            }
            case 820: {
                this.consumeAssignmentOperator(2);
                break;
            }
            case 821: {
                this.consumeAssignmentOperator(8);
                break;
            }
            case 822: {
                this.consumeAssignmentOperator(3);
                break;
            }
            case 823: {
                this.consumeExpression();
                break;
            }
            case 826: {
                this.consumeEmptyExpression();
                break;
            }
            case 829: {
                this.consumeConstantExpressions();
                break;
            }
            case 833: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 834: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 835: {
                this.consumeDefaultModifiers();
                break;
            }
            case 836: {
                this.consumeModifiers();
                break;
            }
            case 837: {
                this.consumeEmptyBlockStatementsopt();
                break;
            }
            case 839: {
                this.consumeEmptyDimsopt();
                break;
            }
            case 841: {
                this.consumeEmptyArgumentListopt();
                break;
            }
            case 845: {
                this.consumeFormalParameterListopt();
                break;
            }
            case 849: {
                this.consumeEmptyInterfaceMemberDeclarationsopt();
                break;
            }
            case 850: {
                this.consumeInterfaceMemberDeclarationsopt();
                break;
            }
            case 851: {
                this.consumeNestedType();
                break;
            }
            case 852: {
                this.consumeEmptyForInitopt();
                break;
            }
            case 854: {
                this.consumeEmptyForUpdateopt();
                break;
            }
            case 858: {
                this.consumeEmptyCatchesopt();
                break;
            }
            case 860: {
                this.consumeEnumDeclaration();
                break;
            }
            case 861: {
                this.consumeEnumHeader();
                break;
            }
            case 862: {
                this.consumeEnumHeaderName();
                break;
            }
            case 863: {
                this.consumeEnumHeaderNameWithTypeParameters();
                break;
            }
            case 864: {
                this.consumeEnumBodyNoConstants();
                break;
            }
            case 865: {
                this.consumeEnumBodyNoConstants();
                break;
            }
            case 866: {
                this.consumeEnumBodyWithConstants();
                break;
            }
            case 867: {
                this.consumeEnumBodyWithConstants();
                break;
            }
            case 869: {
                this.consumeEnumConstants();
                break;
            }
            case 870: {
                this.consumeEnumConstantHeaderName();
                break;
            }
            case 871: {
                this.consumeEnumConstantHeader();
                break;
            }
            case 872: {
                this.consumeEnumConstantWithClassBody();
                break;
            }
            case 873: {
                this.consumeEnumConstantNoClassBody();
                break;
            }
            case 874: {
                this.consumeArguments();
                break;
            }
            case 875: {
                this.consumeEmptyArguments();
                break;
            }
            case 877: {
                this.consumeEnumDeclarations();
                break;
            }
            case 878: {
                this.consumeEmptyEnumDeclarations();
                break;
            }
            case 880: {
                this.consumeEnhancedForStatement();
                break;
            }
            case 881: {
                this.consumeEnhancedForStatement();
                break;
            }
            case 882: {
                this.consumeEnhancedForStatementHeaderInit(false);
                break;
            }
            case 883: {
                this.consumeEnhancedForStatementHeaderInit(true);
                break;
            }
            case 884: {
                this.consumeEnhancedForStatementHeader();
                break;
            }
            case 885: {
                this.consumeImportDeclaration();
                break;
            }
            case 886: {
                this.consumeSingleStaticImportDeclarationName();
                break;
            }
            case 887: {
                this.consumeImportDeclaration();
                break;
            }
            case 888: {
                this.consumeStaticImportOnDemandDeclarationName();
                break;
            }
            case 889: {
                this.consumeTypeArguments();
                break;
            }
            case 890: {
                this.consumeOnlyTypeArguments();
                break;
            }
            case 892: {
                this.consumeTypeArgumentList1();
                break;
            }
            case 894: {
                this.consumeTypeArgumentList();
                break;
            }
            case 895: {
                this.consumeTypeArgument();
                break;
            }
            case 899: {
                this.consumeReferenceType1();
                break;
            }
            case 900: {
                this.consumeTypeArgumentReferenceType1();
                break;
            }
            case 902: {
                this.consumeTypeArgumentList2();
                break;
            }
            case 905: {
                this.consumeReferenceType2();
                break;
            }
            case 906: {
                this.consumeTypeArgumentReferenceType2();
                break;
            }
            case 908: {
                this.consumeTypeArgumentList3();
                break;
            }
            case 911: {
                this.consumeReferenceType3();
                break;
            }
            case 912: {
                this.consumeWildcard();
                break;
            }
            case 913: {
                this.consumeWildcardWithBounds();
                break;
            }
            case 914: {
                this.consumeWildcardBoundsExtends();
                break;
            }
            case 915: {
                this.consumeWildcardBoundsSuper();
                break;
            }
            case 916: {
                this.consumeWildcard1();
                break;
            }
            case 917: {
                this.consumeWildcard1WithBounds();
                break;
            }
            case 918: {
                this.consumeWildcardBounds1Extends();
                break;
            }
            case 919: {
                this.consumeWildcardBounds1Super();
                break;
            }
            case 920: {
                this.consumeWildcard2();
                break;
            }
            case 921: {
                this.consumeWildcard2WithBounds();
                break;
            }
            case 922: {
                this.consumeWildcardBounds2Extends();
                break;
            }
            case 923: {
                this.consumeWildcardBounds2Super();
                break;
            }
            case 924: {
                this.consumeWildcard3();
                break;
            }
            case 925: {
                this.consumeWildcard3WithBounds();
                break;
            }
            case 926: {
                this.consumeWildcardBounds3Extends();
                break;
            }
            case 927: {
                this.consumeWildcardBounds3Super();
                break;
            }
            case 928: {
                this.consumeTypeParameterHeader();
                break;
            }
            case 929: {
                this.consumeTypeParameters();
                break;
            }
            case 931: {
                this.consumeTypeParameterList();
                break;
            }
            case 933: {
                this.consumeTypeParameterWithExtends();
                break;
            }
            case 934: {
                this.consumeTypeParameterWithExtendsAndBounds();
                break;
            }
            case 936: {
                this.consumeAdditionalBoundList();
                break;
            }
            case 937: {
                this.consumeAdditionalBound();
                break;
            }
            case 939: {
                this.consumeTypeParameterList1();
                break;
            }
            case 940: {
                this.consumeTypeParameter1();
                break;
            }
            case 941: {
                this.consumeTypeParameter1WithExtends();
                break;
            }
            case 942: {
                this.consumeTypeParameter1WithExtendsAndBounds();
                break;
            }
            case 944: {
                this.consumeAdditionalBoundList1();
                break;
            }
            case 945: {
                this.consumeAdditionalBound1();
                break;
            }
            case 951: {
                this.consumeUnaryExpression(14);
                break;
            }
            case 952: {
                this.consumeUnaryExpression(13);
                break;
            }
            case 955: {
                this.consumeUnaryExpression(12);
                break;
            }
            case 956: {
                this.consumeUnaryExpression(11);
                break;
            }
            case 959: {
                this.consumeBinaryExpression(15);
                break;
            }
            case 960: {
                this.consumeBinaryExpressionWithName(15);
                break;
            }
            case 961: {
                this.consumeBinaryExpression(9);
                break;
            }
            case 962: {
                this.consumeBinaryExpressionWithName(9);
                break;
            }
            case 963: {
                this.consumeBinaryExpression(16);
                break;
            }
            case 964: {
                this.consumeBinaryExpressionWithName(16);
                break;
            }
            case 966: {
                this.consumeBinaryExpression(14);
                break;
            }
            case 967: {
                this.consumeBinaryExpressionWithName(14);
                break;
            }
            case 968: {
                this.consumeBinaryExpression(13);
                break;
            }
            case 969: {
                this.consumeBinaryExpressionWithName(13);
                break;
            }
            case 971: {
                this.consumeBinaryExpression(10);
                break;
            }
            case 972: {
                this.consumeBinaryExpressionWithName(10);
                break;
            }
            case 973: {
                this.consumeBinaryExpression(17);
                break;
            }
            case 974: {
                this.consumeBinaryExpressionWithName(17);
                break;
            }
            case 975: {
                this.consumeBinaryExpression(19);
                break;
            }
            case 976: {
                this.consumeBinaryExpressionWithName(19);
                break;
            }
            case 978: {
                this.consumeBinaryExpression(4);
                break;
            }
            case 979: {
                this.consumeBinaryExpressionWithName(4);
                break;
            }
            case 980: {
                this.consumeBinaryExpression(6);
                break;
            }
            case 981: {
                this.consumeBinaryExpressionWithName(6);
                break;
            }
            case 982: {
                this.consumeBinaryExpression(5);
                break;
            }
            case 983: {
                this.consumeBinaryExpressionWithName(5);
                break;
            }
            case 984: {
                this.consumeBinaryExpression(7);
                break;
            }
            case 985: {
                this.consumeBinaryExpressionWithName(7);
                break;
            }
            case 987: {
                this.consumeInstanceOfExpressionWithName();
                break;
            }
            case 988: {
                this.consumeInstanceOfExpression();
                break;
            }
            case 990: {
                this.consumeEqualityExpression(18);
                break;
            }
            case 991: {
                this.consumeEqualityExpressionWithName(18);
                break;
            }
            case 992: {
                this.consumeEqualityExpression(29);
                break;
            }
            case 993: {
                this.consumeEqualityExpressionWithName(29);
                break;
            }
            case 995: {
                this.consumeBinaryExpression(2);
                break;
            }
            case 996: {
                this.consumeBinaryExpressionWithName(2);
                break;
            }
            case 998: {
                this.consumeBinaryExpression(8);
                break;
            }
            case 999: {
                this.consumeBinaryExpressionWithName(8);
                break;
            }
            case 1001: {
                this.consumeBinaryExpression(3);
                break;
            }
            case 1002: {
                this.consumeBinaryExpressionWithName(3);
                break;
            }
            case 1004: {
                this.consumeBinaryExpression(0);
                break;
            }
            case 1005: {
                this.consumeBinaryExpressionWithName(0);
                break;
            }
            case 1007: {
                this.consumeBinaryExpression(1);
                break;
            }
            case 1008: {
                this.consumeBinaryExpressionWithName(1);
                break;
            }
            case 1010: {
                this.consumeConditionalExpression(23);
                break;
            }
            case 1011: {
                this.consumeConditionalExpressionWithName(23);
                break;
            }
            case 1015: {
                this.consumeAnnotationTypeDeclarationHeaderName();
                break;
            }
            case 1016: {
                this.consumeAnnotationTypeDeclarationHeaderNameWithTypeParameters();
                break;
            }
            case 1017: {
                this.consumeAnnotationTypeDeclarationHeaderNameWithTypeParameters();
                break;
            }
            case 1018: {
                this.consumeAnnotationTypeDeclarationHeaderName();
                break;
            }
            case 1019: {
                this.consumeAnnotationTypeDeclarationHeader();
                break;
            }
            case 1020: {
                this.consumeAnnotationTypeDeclaration();
                break;
            }
            case 1022: {
                this.consumeEmptyAnnotationTypeMemberDeclarationsopt();
                break;
            }
            case 1023: {
                this.consumeAnnotationTypeMemberDeclarationsopt();
                break;
            }
            case 1025: {
                this.consumeAnnotationTypeMemberDeclarations();
                break;
            }
            case 1026: {
                this.consumeMethodHeaderNameWithTypeParameters(true);
                break;
            }
            case 1027: {
                this.consumeMethodHeaderName(true);
                break;
            }
            case 1028: {
                this.consumeEmptyMethodHeaderDefaultValue();
                break;
            }
            case 1029: {
                this.consumeMethodHeaderDefaultValue();
                break;
            }
            case 1030: {
                this.consumeMethodHeader();
                break;
            }
            case 1031: {
                this.consumeAnnotationTypeMemberDeclaration();
                break;
            }
            case 1039: {
                this.consumeAnnotationName();
                break;
            }
            case 1040: {
                this.consumeNormalAnnotation(false);
                break;
            }
            case 1041: {
                this.consumeEmptyMemberValuePairsopt();
                break;
            }
            case 1044: {
                this.consumeMemberValuePairs();
                break;
            }
            case 1045: {
                this.consumeMemberValuePair();
                break;
            }
            case 1046: {
                this.consumeEnterMemberValue();
                break;
            }
            case 1047: {
                this.consumeExitMemberValue();
                break;
            }
            case 1049: {
                this.consumeMemberValueAsName();
                break;
            }
            case 1052: {
                this.consumeMemberValueArrayInitializer();
                break;
            }
            case 1053: {
                this.consumeMemberValueArrayInitializer();
                break;
            }
            case 1054: {
                this.consumeEmptyMemberValueArrayInitializer();
                break;
            }
            case 1055: {
                this.consumeEmptyMemberValueArrayInitializer();
                break;
            }
            case 1056: {
                this.consumeEnterMemberValueArrayInitializer();
                break;
            }
            case 1058: {
                this.consumeMemberValues();
                break;
            }
            case 1059: {
                this.consumeMarkerAnnotation(false);
                break;
            }
            case 1060: {
                this.consumeSingleMemberAnnotationMemberValue();
                break;
            }
            case 1061: {
                this.consumeSingleMemberAnnotation(false);
                break;
            }
            case 1062: {
                this.consumeRecoveryMethodHeaderNameWithTypeParameters();
                break;
            }
            case 1063: {
                this.consumeRecoveryMethodHeaderName();
                break;
            }
            case 1064: {
                this.consumeRecoveryMethodHeaderNameWithTypeParameters();
                break;
            }
            case 1065: {
                this.consumeRecoveryMethodHeaderName();
                break;
            }
            case 1066: {
                this.consumeMethodHeader();
                break;
            }
            case 1067: {
                this.consumeMethodHeader();
            }
        }
    }

    protected void consumeQualifiedName() {
        this.consumeQualifiedName(false);
    }

    private void consumeIntertypeClassHeader() {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        if (this.currentToken == 66) {
            typeDecl.bodyStart = this.scanner.currentPosition;
        }
        if (this.currentElement != null) {
            this.restartRecovery = true;
        }
        this.scanner.commentPtr = -1;
    }

    private void consumeIntertypeClassDeclaration() {
        TypeDeclaration typeDecl;
        boolean hasConstructor;
        int length;
        if ((length = this.astLengthStack[this.astLengthPtr--]) != 0) {
            this.dispatchDeclarationInto(length);
        }
        if (!(hasConstructor = (typeDecl = (TypeDeclaration)this.astStack[this.astPtr]).checkConstructors(this))) {
            switch (TypeDeclaration.kind(typeDecl.modifiers)) {
                case 1: 
                case 3: {
                    boolean insideFieldInitializer = false;
                    if (this.diet) {
                        int i = this.nestedType;
                        while (i > 0) {
                            if (this.variablesCounter[i] > 0) {
                                insideFieldInitializer = true;
                                break;
                            }
                            --i;
                        }
                    }
                    typeDecl.createDefaultConstructor(!this.diet || insideFieldInitializer, true);
                }
            }
        }
        if (this.scanner.containsAssertKeyword) {
            typeDecl.bits |= 1;
        }
        typeDecl.addClinit();
        typeDecl.bodyEnd = this.endStatementPosition;
        if (length == 0 && !this.containsComment(typeDecl.bodyStart, typeDecl.bodyEnd)) {
            typeDecl.bits |= 8;
        }
        typeDecl.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
    }

    private void consumeIntertypeTypeHeaderNameWithTypeParameters() {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        int length = this.genericsLengthStack[this.genericsLengthPtr--];
        this.genericsPtr -= length;
        typeDecl.typeParameters = new TypeParameter[length];
        System.arraycopy(this.genericsStack, this.genericsPtr + 1, typeDecl.typeParameters, 0, length);
        typeDecl.bodyStart = typeDecl.typeParameters[length - 1].declarationSourceEnd + 1;
        this.listTypeParameterLength = 0;
        if (this.currentElement != null) {
            RecoveredType recoveredType = (RecoveredType)this.currentElement;
            recoveredType.pendingTypeParameters = null;
            this.lastCheckPoint = typeDecl.bodyStart;
        }
    }

    private void consumeIntertypeClassHeaderName(boolean b) {
        int length;
        TypeDeclaration typeDecl = declarationFactory.createIntertypeMemberClassDeclaration(this.compilationUnit.compilationResult);
        if (this.nestedMethod[this.nestedType] == 0) {
            if (this.nestedType != 0) {
                typeDecl.bits |= 0x400;
            }
        } else {
            typeDecl.bits |= 0x100;
            this.markEnclosingMemberWithLocalType();
            this.blockReal();
        }
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        typeDecl.sourceEnd = (int)pos;
        typeDecl.sourceStart = (int)(pos >>> 32);
        typeDecl.name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (b) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(typeDecl, onType);
        typeDecl.declarationSourceStart = this.intStack[this.intPtr--];
        --this.intPtr;
        typeDecl.modifiersSourceStart = this.intStack[this.intPtr--];
        typeDecl.modifiers = this.intStack[this.intPtr--];
        if (typeDecl.modifiersSourceStart >= 0) {
            typeDecl.declarationSourceStart = typeDecl.modifiersSourceStart;
        }
        if ((typeDecl.bits & 0x400) == 0 && (typeDecl.bits & 0x100) == 0 && this.compilationUnit != null && !CharOperation.equals(typeDecl.name, this.compilationUnit.getMainTypeName())) {
            typeDecl.bits |= 0x1000;
        }
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            typeDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, typeDecl.annotations, 0, length);
        }
        typeDecl.bodyStart = typeDecl.sourceEnd + 1;
        this.pushOnAstStack(typeDecl);
        this.listLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = typeDecl.bodyStart;
            this.currentElement = this.currentElement.add(typeDecl, 0);
            this.lastIgnoredToken = -1;
        }
        typeDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.display();
    }

    protected ASTNode popPointcutDesignator(String terminator) {
        ASTNode tokens = this.popPseudoTokens(terminator);
        return declarationFactory.createPointcutDesignator(this, tokens);
    }

    protected ASTNode popPseudoTokens(String terminator) {
        this.consumePseudoToken(terminator);
        this.consumePseudoTokens();
        int length = this.astLengthStack[this.astLengthPtr--];
        this.astPtr -= length;
        ASTNode[] tokens = new ASTNode[length];
        System.arraycopy(this.astStack, this.astPtr + 1, tokens, 0, length);
        this.listLength = 0;
        return declarationFactory.createPseudoTokensFrom(tokens, this.compilationUnit.compilationResult());
    }

    private void swapAstStack() {
        ASTNode next;
        ASTNode top = this.astStack[this.astPtr];
        this.astStack[this.astPtr] = next = this.astStack[this.astPtr - 1];
        this.astStack[this.astPtr - 1] = top;
    }

    private void consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern(String badToken) {
        this.consumeInterTypeFieldHeader(false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 14, badToken.toCharArray(), badToken);
    }

    private void consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern(String badToken) {
        this.consumeInterTypeConstructorHeaderName(false, false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 14, badToken.toCharArray(), badToken);
    }

    private void consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern(String badToken) {
        this.consumeInterTypeMethodHeaderName(false, false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 14, badToken.toCharArray(), badToken);
    }

    private void consumeAroundHeaderNameMissingReturnType() {
        this.problemReporter().parseErrorInsertToComplete(this.scanner.startPosition, this.scanner.currentPosition, "return type", "around advice declaration");
        this.restartRecovery = true;
    }

    private void consumeBadHeader() {
        this.problemReporter().parseErrorReplaceTokens(this.scanner.startPosition, this.scanner.currentPosition, "valid member declaration");
        this.restartRecovery = true;
    }

    @Override
    protected void consumeSimpleAssertStatement() {
        super.consumeSimpleAssertStatement();
    }

    private void convertTypeParametersToSingleTypeReferences() {
        int typeParameterIndex = 0;
        while (typeParameterIndex < this.genericsLengthStack[this.genericsLengthPtr]) {
            TypeParameter tp = (TypeParameter)this.genericsStack[this.genericsPtr - typeParameterIndex];
            SingleTypeReference str = new SingleTypeReference(tp.name, tp.declarationSourceStart);
            this.genericsStack[this.genericsPtr - typeParameterIndex] = str;
            ++typeParameterIndex;
        }
    }

    public Parser() {
    }

    public Parser(ProblemReporter problemReporter, boolean optimizeStringLiterals) {
        super(problemReporter, optimizeStringLiterals);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean shouldTryToRecover() {
        ASTNode aSTNode;
        int index = 0;
        while (index < this.astStack.length && (aSTNode = this.astStack[index++]) != null) {
            void node;
            if (declarationFactory.shouldTryToRecover((ASTNode)node)) continue;
            return false;
        }
        return true;
    }

    protected void pushOnAspectIntStack(int pos) {
        int stackLength = this.aspectIntStack.length;
        if (++this.aspectIntPtr >= stackLength) {
            this.aspectIntStack = new int[stackLength + 255];
            System.arraycopy(this.aspectIntStack, 0, this.aspectIntStack, 0, stackLength);
        }
        this.aspectIntStack[this.aspectIntPtr] = pos;
    }

    public static interface IDeclarationFactory {
        public MessageSend createProceed(MessageSend var1);

        public TypeDeclaration createAspect(CompilationResult var1);

        public void setPrivileged(TypeDeclaration var1, boolean var2);

        public void setPerClauseFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public void setDominatesPatternFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public ASTNode createPseudoTokensFrom(ASTNode[] var1, CompilationResult var2);

        public MethodDeclaration createMethodDeclaration(CompilationResult var1);

        public ConstructorDeclaration createConstructorDeclaration(CompilationResult var1);

        public MethodDeclaration createPointcutDeclaration(CompilationResult var1);

        public MethodDeclaration createAroundAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createAfterAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createBeforeAdviceDeclaration(CompilationResult var1);

        public ASTNode createPointcutDesignator(Parser var1, ASTNode var2);

        public void setPointcutDesignatorOnAdvice(MethodDeclaration var1, ASTNode var2);

        public void setPointcutDesignatorOnPointcut(MethodDeclaration var1, ASTNode var2);

        public void setExtraArgument(MethodDeclaration var1, Argument var2);

        public boolean isAfterAdvice(MethodDeclaration var1);

        public void setAfterThrowingAdviceKind(MethodDeclaration var1);

        public void setAfterReturningAdviceKind(MethodDeclaration var1);

        public MethodDeclaration createDeclareDeclaration(CompilationResult var1, ASTNode var2, Parser var3);

        public MethodDeclaration createDeclareAnnotationDeclaration(CompilationResult var1, ASTNode var2, Annotation var3, Parser var4, char var5);

        public MethodDeclaration createInterTypeFieldDeclaration(CompilationResult var1, TypeReference var2);

        public MethodDeclaration createInterTypeMethodDeclaration(CompilationResult var1);

        public MethodDeclaration createInterTypeConstructorDeclaration(CompilationResult var1);

        public void setSelector(MethodDeclaration var1, char[] var2);

        public void setDeclaredModifiers(MethodDeclaration var1, int var2);

        public void setInitialization(MethodDeclaration var1, Expression var2);

        public void setOnType(MethodDeclaration var1, TypeReference var2);

        public ASTNode createPseudoToken(Parser var1, String var2, boolean var3);

        public ASTNode createIfPseudoToken(Parser var1, Expression var2);

        public void setLiteralKind(ASTNode var1, String var2);

        public boolean shouldTryToRecover(ASTNode var1);

        public TypeDeclaration createIntertypeMemberClassDeclaration(CompilationResult var1);

        public void setOnType(TypeDeclaration var1, TypeReference var2);
    }
}

