/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jira;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.swizzle.jira.Attachment;
import org.codehaus.swizzle.jira.Issue;
import org.codehaus.swizzle.jira.IssueFiller;
import org.codehaus.swizzle.jira.Jira;
import org.codehaus.swizzle.jira.JiraRss;
import org.codehaus.swizzle.jira.ServerInfo;
import org.codehaus.swizzle.stream.StreamLexer;

public class AttachmentsFiller
implements IssueFiller {
    private final Jira jira;
    private boolean enabled;
    private final SimpleDateFormat dateFormat;

    public AttachmentsFiller(Jira jira) {
        this.jira = jira;
        this.dateFormat = new SimpleDateFormat("dd/MMM/yy hh:mm a");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void fill(Issue issue) {
        if (!this.enabled) {
            return;
        }
        ServerInfo serverInfo = this.jira.getServerInfo();
        String baseUrlString = serverInfo.getBaseUrl();
        this.getAttachments(baseUrlString, issue);
    }

    public static List fill(JiraRss jiraRss) throws Exception {
        AttachmentsFiller filler = new AttachmentsFiller(null);
        List<Issue> issues = jiraRss.getIssues();
        for (int i = 0; i < issues.size(); ++i) {
            Issue issue = issues.get(i);
            String link = issue.getLink();
            link = link.replaceFirst("/browse/.*$", "/");
            filler.getAttachments(link, issue);
        }
        return issues;
    }

    private void getAttachments(String baseUrlString, Issue issue) {
        try {
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            URL baseUrl = new URL(baseUrlString);
            URL pageUrl = new URL(baseUrl, "secure/ManageAttachments.jspa?id=" + issue.getId());
            BufferedInputStream in = new BufferedInputStream(pageUrl.openStream());
            StreamLexer lexer = new StreamLexer((InputStream)in);
            while (lexer.readToken("icons/attach") != null) {
                try {
                    Attachment attachment = new Attachment();
                    String link = lexer.readToken("secure/attachment/", "\"");
                    URL url = new URL(pageUrl, "attachment/" + link);
                    attachment.setUrl(url);
                    attachments.add(attachment);
                    String id = link.replaceFirst("/.*", "");
                    attachment.setId(Integer.parseInt(id));
                    File file = new File(url.getFile());
                    attachment.setFileName(file.getName());
                    lexer.readToken("<td");
                    String size = lexer.readToken(">", "</td>");
                    lexer.readToken("<td");
                    String mimeType = lexer.readToken(">", "</td>");
                    try {
                        lexer.readToken("<td");
                        String dateAttached = lexer.readToken(">", "</td>");
                        if (!this.containsGarbage(dateAttached)) {
                            Date created = this.dateFormat.parse(dateAttached);
                            attachment.setCreated(created);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    lexer.readToken("<td");
                    String attachedBy = lexer.readToken(">", "</td>");
                    if (!this.containsGarbage(attachedBy)) {
                        attachment.setAuthor(attachedBy);
                        continue;
                    }
                    attachment.setAuthor("");
                }
                catch (Exception e) {}
            }
            ((InputStream)in).close();
            issue.setAttachments(attachments);
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private boolean containsGarbage(String data) {
        char[] illegal = new char[]{'<', '>', '=', '\n', '\r', '\t'};
        for (int i = 0; i < illegal.length; ++i) {
            char c = illegal[i];
            if (data.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }
}

