/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jira;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.codehaus.swizzle.jira.Component;
import org.codehaus.swizzle.jira.Issue;
import org.codehaus.swizzle.jira.IssueFiller;
import org.codehaus.swizzle.jira.IssueType;
import org.codehaus.swizzle.jira.Jira;
import org.codehaus.swizzle.jira.Priority;
import org.codehaus.swizzle.jira.Resolution;
import org.codehaus.swizzle.jira.ServerInfo;
import org.codehaus.swizzle.jira.Status;
import org.codehaus.swizzle.jira.User;
import org.codehaus.swizzle.jira.Version;

public class BasicIssueFiller
implements IssueFiller {
    private final Jira jira;
    private boolean enabled;

    public BasicIssueFiller(Jira jira) {
        this.jira = jira;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void fill(Issue issue) {
        Version version;
        int i;
        if (!this.enabled) {
            return;
        }
        this.fill(issue.getAssignee());
        this.fill(issue.getReporter());
        this.fill(issue.getPriority());
        this.fill(issue.getStatus());
        this.fill(issue.getResolution());
        this.fill(issue.getType());
        List<Version> versions = issue.getAffectsVersions();
        for (i = 0; i < versions.size(); ++i) {
            version = versions.get(i);
            this.fill(issue, version);
        }
        versions = issue.getFixVersions();
        for (i = 0; i < versions.size(); ++i) {
            version = versions.get(i);
            this.fill(issue, version);
        }
        List<Component> components = issue.getComponents();
        for (int i2 = 0; i2 < components.size(); ++i2) {
            Component component = components.get(i2);
            this.fill(issue, component);
        }
        if (issue.getLink() == null && this.jira != null) {
            try {
                ServerInfo serverInfo = this.jira.getServerInfo();
                URL url = new URL(serverInfo.getBaseUrl() + "/browse/" + issue.getKey());
                issue.setLink(url.toExternalForm());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    public void fill(Issue issue, Version dest) {
        Version source = this.jira.getVersion(issue.getProject().getKey(), dest.getId());
        if (source == null) {
            source = this.jira.getVersion(issue.getProject().getKey(), dest.getName());
        }
        dest.merge(source);
    }

    public void fill(Issue issue, Component dest) {
        Component source = this.jira.getComponent(issue.getProject().getKey(), dest.getId());
        if (source == null) {
            source = this.jira.getComponent(issue.getProject().getKey(), dest.getName());
        }
        dest.merge(source);
    }

    public void fill(User dest) {
        if (dest == null) {
            return;
        }
        User source = this.jira.getUser(dest.getName());
        dest.merge(source);
    }

    public void fill(Priority dest) {
        if (dest == null) {
            return;
        }
        Priority source = this.jira.getPriority(dest.getId());
        if (source == null) {
            source = this.jira.getPriority(dest.getName());
        }
        dest.merge(source);
    }

    public void fill(Status dest) {
        if (dest == null) {
            return;
        }
        Status source = this.jira.getStatus(dest.getId());
        if (source == null) {
            source = this.jira.getStatus(dest.getName());
        }
        dest.merge(source);
    }

    public void fill(Resolution dest) {
        if (dest == null) {
            return;
        }
        Resolution source = this.jira.getResolution(dest.getId());
        if (source == null) {
            source = this.jira.getResolution(dest.getName());
        }
        dest.merge(source);
    }

    public void fill(IssueType dest) {
        if (dest == null) {
            return;
        }
        IssueType source = this.jira.getIssueType(dest.getId());
        if (source == null) {
            source = this.jira.getIssueType(dest.getName());
        }
        dest.merge(source);
    }
}

