/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jira;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.swizzle.jira.Attachment;
import org.codehaus.swizzle.jira.Comment;
import org.codehaus.swizzle.jira.Component;
import org.codehaus.swizzle.jira.CustomFieldValue;
import org.codehaus.swizzle.jira.IssueType;
import org.codehaus.swizzle.jira.MapObject;
import org.codehaus.swizzle.jira.MapObjectList;
import org.codehaus.swizzle.jira.Priority;
import org.codehaus.swizzle.jira.Project;
import org.codehaus.swizzle.jira.Resolution;
import org.codehaus.swizzle.jira.Status;
import org.codehaus.swizzle.jira.User;
import org.codehaus.swizzle.jira.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Issue
extends MapObject
implements Comparable {
    public Issue() {
        this(new HashMap());
    }

    public Issue(Map data) {
        super(data);
        this.xmlrpcRefs.put(IssueType.class, "id");
        this.xmlrpcRefs.put(Status.class, "id");
        this.xmlrpcRefs.put(User.class, "name");
        this.xmlrpcRefs.put(Project.class, "key");
        this.xmlrpcRefs.put(Priority.class, "id");
        this.xmlrpcRefs.put(Resolution.class, "id");
        this.xmlrpcNoSend.add("customFieldValues");
        this.xmlrpcNoSend.add("link");
        this.xmlrpcNoSend.add("voters");
        this.xmlrpcNoSend.add("subTasks");
        this.xmlrpcNoSend.add("parentTask");
        this.xmlrpcNoSend.add("attachments");
        this.xmlrpcNoSend.add("comments");
    }

    public Project getProject() {
        return (Project)this.getMapObject("project", Project.class);
    }

    public void setProject(Project project) {
        this.setMapObject("project", project);
    }

    public IssueType getType() {
        return (IssueType)this.getMapObject("type", IssueType.class);
    }

    public void setType(IssueType type) {
        this.setMapObject("type", type);
    }

    public Date getCreated() {
        return this.getDate("created");
    }

    public void setCreated(Date created) {
        this.setDate("created", created);
    }

    public String getSummary() {
        return this.getString("summary");
    }

    public void setSummary(String summary) {
        this.setString("summary", summary);
    }

    public List<User> getVoters() {
        if (!this.hasField("voters")) {
            MapObjectList<User> votes = new MapObjectList<User>();
            for (int i = this.getInt("votes"); i > 0; --i) {
                votes.add(new User());
            }
            this.setMapObjects("voters", votes);
        }
        return this.getMapObjects("voters", User.class);
    }

    public void setVoters(List users) {
        this.setMapObjects("voters", users);
    }

    public int getVotes() {
        return this.getVoters().size();
    }

    public List<CustomFieldValue> getCustomFieldValues() {
        return this.getMapObjects("customFieldValues", CustomFieldValue.class);
    }

    public void setCustomFieldValues(List customFieldValues) {
        this.setMapObjects("customFieldValues", customFieldValues);
    }

    public List<Comment> getComments() {
        return this.getMapObjects("comments", Comment.class);
    }

    public List<Component> getComponents() {
        return this.getMapObjects("components", Component.class);
    }

    public void setComponents(List components) {
        this.setMapObjects("components", components);
    }

    @Deprecated
    public void addComponents(Component component) {
        this.getComponents().add(component);
    }

    public void addComponent(Component component) {
        this.getComponents().add(component);
    }

    public void removeComponents(Component component) {
        this.getComponents().remove(component);
    }

    public List<Version> getAffectsVersions() {
        return this.getMapObjects("affectsVersions", Version.class);
    }

    public void setAffectsVersions(List affectsVersions) {
        this.setMapObjects("affectsVersions", affectsVersions);
    }

    public void addAffectsVersion(Version version) {
        this.getAffectsVersions().add(version);
    }

    public void removeAffectsVersion(Version version) {
        this.getAffectsVersions().remove(version);
    }

    public int getId() {
        return this.getInt("id");
    }

    public void setId(int id) {
        this.setInt("id", id);
    }

    public Status getStatus() {
        return (Status)this.getMapObject("status", Status.class);
    }

    public void setStatus(Status status) {
        this.setMapObject("status", status);
    }

    public Resolution getResolution() {
        return (Resolution)this.getMapObject("resolution", Resolution.class);
    }

    public void setResolution(Resolution resolution) {
        this.setMapObject("resolution", resolution);
    }

    public List<Version> getFixVersions() {
        return this.getMapObjects("fixVersions", Version.class);
    }

    public void setFixVersions(List fixVersions) {
        this.setMapObjects("fixVersions", fixVersions);
    }

    public void addFixVersion(Version version) {
        this.getFixVersions().add(version);
    }

    public void removeFixVersion(Version version) {
        this.getFixVersions().remove(version);
    }

    public List<Issue> getSubTasks() {
        return this.getMapObjects("subTasks", Issue.class);
    }

    public void setSubTasks(List subTasks) {
        this.setMapObjects("subTasks", subTasks);
    }

    public void addSubTask(Issue issue) {
        this.getSubTasks().add(issue);
    }

    public void removeSubTask(Issue issue) {
        this.getSubTasks().remove(issue);
    }

    protected Issue getParentTask() {
        return (Issue)this.getMapObject("parentTask", Issue.class);
    }

    protected void setParentTask(Issue parentTask) {
        this.setMapObject("parentTask", parentTask);
    }

    public String getDescription() {
        return this.getString("description");
    }

    public void setDescription(String description) {
        this.setString("description", description);
    }

    public User getReporter() {
        return (User)this.getMapObject("reporter", User.class);
    }

    public void setReporter(User reporter) {
        this.setMapObject("reporter", reporter);
    }

    public Date getUpdated() {
        return this.getDate("updated");
    }

    public void setUpdated(Date updated) {
        this.setDate("updated", updated);
    }

    public Date getDuedate() {
        return this.getDate("duedate");
    }

    public void setDuedate(Date duedate) {
        this.setDate("duedate", duedate);
    }

    public User getAssignee() {
        return (User)this.getMapObject("assignee", User.class);
    }

    public void setAssignee(User assignee) {
        this.setMapObject("assignee", assignee);
    }

    public String getEnvironment() {
        return this.getString("environment");
    }

    public void setEnvironment(String environment) {
        this.setString("environment", environment);
    }

    public Priority getPriority() {
        return (Priority)this.getMapObject("priority", Priority.class);
    }

    public void setPriority(Priority priority) {
        this.setMapObject("priority", priority);
    }

    public String getKey() {
        return this.getString("key");
    }

    public void setKey(String key) {
        this.setString("key", key);
    }

    public String getLink() {
        return this.getString("link");
    }

    public void setLink(String link) {
        this.setString("link", link);
    }

    public List<Attachment> getAttachments() {
        return this.getMapObjects("attachments", Attachment.class);
    }

    public void setAttachments(List attachments) {
        this.setMapObjects("attachments", attachments);
    }

    @Override
    public Map toMap() {
        this.setInt("votes", this.getVoters().size());
        return super.toMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        if (this.getId() != issue.getId()) {
            return false;
        }
        return !(this.getKey() != null ? !this.getKey().equals(issue.getKey()) : issue.getKey() != null);
    }

    public int hashCode() {
        int result = this.getId();
        result = 29 * result + (this.getKey() != null ? this.getKey().hashCode() : 0);
        return result;
    }

    public int compareTo(Object object) {
        if (object instanceof Issue) {
            int b;
            Issue that = (Issue)object;
            int a = this.getId();
            if (a > (b = that.getId())) {
                return 1;
            }
            if (a < b) {
                return -1;
            }
        }
        return 0;
    }

    public String toString() {
        return this.getKey();
    }
}

