/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jira;

import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.codehaus.swizzle.jira.BasicIssueFiller;
import org.codehaus.swizzle.jira.Comment;
import org.codehaus.swizzle.jira.Component;
import org.codehaus.swizzle.jira.Filter;
import org.codehaus.swizzle.jira.Issue;
import org.codehaus.swizzle.jira.IssueFiller;
import org.codehaus.swizzle.jira.IssueType;
import org.codehaus.swizzle.jira.MapObject;
import org.codehaus.swizzle.jira.MapObjectList;
import org.codehaus.swizzle.jira.Priority;
import org.codehaus.swizzle.jira.Project;
import org.codehaus.swizzle.jira.ProjectFiller;
import org.codehaus.swizzle.jira.Resolution;
import org.codehaus.swizzle.jira.ServerInfo;
import org.codehaus.swizzle.jira.Status;
import org.codehaus.swizzle.jira.User;
import org.codehaus.swizzle.jira.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jira {
    private static Map cacheMetadata = new HashMap();
    private final XmlRpcClient client;
    private String token;
    private boolean autofill = true;
    private final Map<String, IssueFiller> issueFillers = new LinkedHashMap<String, IssueFiller>();
    private final Map<String, String> autofillProviders = new HashMap<String, String>();
    private Map<Call, Object> callcache = new HashMap<Call, Object>();

    public Jira(String endpoint) throws MalformedURLException {
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        if (!endpoint.endsWith("/rpc/xmlrpc")) {
            endpoint = endpoint + "/rpc/xmlrpc";
        }
        XmlRpcClientConfigImpl clientConfig = new XmlRpcClientConfigImpl();
        clientConfig.setServerURL(new URL(endpoint));
        this.client = new XmlRpcClient();
        this.client.setConfig((XmlRpcClientConfig)clientConfig);
        BasicIssueFiller basicIssueFiller = new BasicIssueFiller(this);
        basicIssueFiller.setEnabled(true);
        this.issueFillers.put("issue", basicIssueFiller);
        this.issueFillers.put("project", new ProjectFiller(this));
        this.autofillProviders.put("issue", BasicIssueFiller.class.getName());
        this.autofillProviders.put("project", ProjectFiller.class.getName());
        this.autofillProviders.put("voters", "org.codehaus.swizzle.jira.VotersFiller");
        this.autofillProviders.put("subtasks", "org.codehaus.swizzle.jira.SubTasksFiller");
        this.autofillProviders.put("attachments", "org.codehaus.swizzle.jira.AttachmentsFiller");
        this.autofillProviders.put("comments", "org.codehaus.swizzle.jira.CommentsFiller");
    }

    public void autofill(String scheme, boolean enabled) {
        if (!this.autofillProviders.containsKey(scheme)) {
            throw new UnsupportedOperationException("Autofill Scheme not supported: " + scheme);
        }
        IssueFiller filler = this.issueFillers.get(scheme);
        if (filler == null) {
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                Class<?> clazz = classLoader.loadClass(this.autofillProviders.get(scheme));
                Constructor<?> constructor = clazz.getConstructor(Jira.class);
                filler = (IssueFiller)constructor.newInstance(this);
                this.issueFillers.put(scheme, filler);
            }
            catch (Exception e) {
                System.err.println("Cannot install autofill provider " + scheme);
                e.printStackTrace();
            }
        }
        filler.setEnabled(enabled);
    }

    public void login(String username, String password) throws Exception {
        this.token = (String)this.call("login", username, password);
    }

    public boolean logout() throws Exception {
        Boolean value = (Boolean)this.call("logout", new Object[0]);
        return value;
    }

    public List getComments(String issueKey) {
        return this.cachedList(new Call("getComments", issueKey), Comment.class);
    }

    public List getComments(Issue issue) {
        return this.getComments(issue.getKey());
    }

    public boolean addComment(String issueKey, String comment) throws Exception {
        Boolean value = (Boolean)this.call("getComments", issueKey, comment);
        return value;
    }

    public Issue createIssue(Issue issue) throws Exception {
        Map data = (Map)this.call("createIssue", issue.toMap());
        return this.autofill ? this.fill(new Issue(data)) : new Issue(data);
    }

    public Issue updateIssue(String issueKey, Issue issue) throws Exception {
        Map data = (Map)this.call("updateIssue", issueKey, issue.toMap());
        return this.autofill ? this.fill(new Issue(data)) : new Issue(data);
    }

    public Issue getIssue(String issueKey) {
        return (Issue)this.cachedObject(new Call("getIssue", issueKey), Issue.class);
    }

    public List<Issue> getIssuesFromFilter(Filter filter) throws Exception {
        return this.getIssuesFromFilter(filter.getId());
    }

    public List<Issue> getIssuesFromFilter(String filterName) throws Exception {
        Filter filter = this.getSavedFilter(filterName);
        if (filter == null) {
            return this.toList(new Object[0], Issue.class);
        }
        return this.getIssuesFromFilter(filter.getId());
    }

    public List<Issue> getIssuesFromFilter(int filterId) throws Exception {
        Object[] vector = (Object[])this.call("getIssuesFromFilter", filterId + "");
        return this.toList(vector, Issue.class);
    }

    public List<Issue> getIssuesFromTextSearch(String searchTerms) throws Exception {
        Object[] vector = (Object[])this.call("getIssuesFromTextSearch", searchTerms);
        return this.toList(vector, Issue.class);
    }

    public List<Issue> getIssuesFromTextSearchWithProject(List projectKeys, String searchTerms, int maxNumResults) throws Exception {
        Object[] vector = (Object[])this.call("getIssuesFromTextSearchWithProject", projectKeys.toArray(), searchTerms, new Integer(maxNumResults));
        return this.toList(vector, Issue.class);
    }

    public List<IssueType> getIssueTypes() {
        return this.cachedList(new Call("getIssueTypes", new Object[0]), IssueType.class);
    }

    public IssueType getIssueType(String name) {
        Map objects = this.cachedMap(new Call("getIssueTypes", new Object[0]), IssueType.class, "name");
        return (IssueType)objects.get(name);
    }

    public IssueType getIssueType(int id) {
        Map objects = this.cachedMap(new Call("getIssueTypes", new Object[0]), IssueType.class, "id");
        return (IssueType)objects.get(id + "");
    }

    public List getIssueTypesForProject(int projectId) {
        return this.cachedList(new Call("getIssueTypesForProject", projectId + ""), IssueType.class);
    }

    public List getIssueTypesForProject(String projectKey) {
        return this.cachedList(new Call("getIssueTypesForProject", this.getProject(projectKey).getId() + ""), IssueType.class);
    }

    public List<Priority> getPriorities() {
        return this.cachedList(new Call("getPriorities", new Object[0]), Priority.class);
    }

    public Priority getPriority(String name) {
        Map objects = this.cachedMap(new Call("getPriorities", new Object[0]), Priority.class, "name");
        return (Priority)objects.get(name);
    }

    public Priority getPriority(int id) {
        Map objects = this.cachedMap(new Call("getPriorities", new Object[0]), Priority.class, "id");
        return (Priority)objects.get(id + "");
    }

    public List<Project> getProjects() {
        String versionPrefix = this.getVersionPrefix(4);
        if (versionPrefix.compareTo("3.13") < 0) {
            return this.cachedList(new Call("getProjects", new Object[0]), Project.class);
        }
        return this.cachedList(new Call("getProjectsNoSchemes", new Object[0]), Project.class);
    }

    public Project getProject(String key) {
        String versionPrefix = this.getVersionPrefix(4);
        Map objects = versionPrefix.compareTo("3.13") < 0 ? this.cachedMap(new Call("getProjects", new Object[0]), Project.class, "key") : this.cachedMap(new Call("getProjectsNoSchemes", new Object[0]), Project.class, "key");
        return (Project)objects.get(key);
    }

    public Project getProject(int id) {
        String versionPrefix = this.getVersionPrefix(4);
        Map objects = versionPrefix.compareTo("3.13") < 0 ? this.cachedMap(new Call("getProjects", new Object[0]), Project.class, "id") : this.cachedMap(new Call("getProjectsNoSchemes", new Object[0]), Project.class, "id");
        return (Project)objects.get(id + "");
    }

    public List<Resolution> getResolutions() {
        return this.cachedList(new Call("getResolutions", new Object[0]), Resolution.class);
    }

    public Resolution getResolution(String name) {
        Map objects = this.cachedMap(new Call("getResolutions", new Object[0]), Resolution.class, "name");
        return (Resolution)objects.get(name);
    }

    public Resolution getResolution(int id) {
        Map objects = this.cachedMap(new Call("getResolutions", new Object[0]), Resolution.class, "id");
        return (Resolution)objects.get(id + "");
    }

    public List<Status> getStatuses() {
        return this.cachedList(new Call("getStatuses", new Object[0]), Status.class);
    }

    public Status getStatus(String name) {
        Map objects = this.cachedMap(new Call("getStatuses", new Object[0]), Status.class, "name");
        return (Status)objects.get(name);
    }

    public Status getStatus(int id) {
        Map objects = this.cachedMap(new Call("getStatuses", new Object[0]), Status.class, "id");
        return (Status)objects.get(id + "");
    }

    public List<Filter> getSavedFilters() {
        return this.cachedList(new Call("getSavedFilters", new Object[0]), Filter.class);
    }

    public Filter getSavedFilter(String name) {
        Map objects = this.cachedMap(new Call("getSavedFilters", new Object[0]), Filter.class, "name");
        return (Filter)objects.get(name);
    }

    public Filter getSavedFilter(int id) {
        Map objects = this.cachedMap(new Call("getSavedFilters", new Object[0]), Filter.class, "id");
        return (Filter)objects.get(id + "");
    }

    public ServerInfo getServerInfo() {
        return (ServerInfo)this.cachedObject(new Call("getServerInfo", new Object[0]), ServerInfo.class);
    }

    public List<IssueType> getSubTaskIssueTypes() {
        return this.cachedList(new Call("getSubTaskIssueTypes", new Object[0]), IssueType.class);
    }

    public IssueType getSubTaskIssueType(String name) {
        Map objects = this.cachedMap(new Call("getSubTaskIssueTypes", new Object[0]), IssueType.class, "name");
        return (IssueType)objects.get(name);
    }

    public IssueType getSubTaskIssueType(int id) {
        Map objects = this.cachedMap(new Call("getSubTaskIssueTypes", new Object[0]), IssueType.class, "id");
        return (IssueType)objects.get(id + "");
    }

    public User getUser(String username) {
        return (User)this.cachedObject(new Call("getUser", username), User.class);
    }

    public List<Component> getComponents(String projectKey) {
        return this.cachedList(new Call("getComponents", projectKey), Component.class);
    }

    public List<Component> getComponents(Project project) {
        return this.getComments(project.getKey());
    }

    public Component getComponent(String projectKey, String name) {
        Map components = this.cachedMap(new Call("getComponents", projectKey), Component.class, "name");
        return (Component)components.get(name);
    }

    public Component getComponent(Project project, String name) {
        return this.getComponent(project.getKey(), name);
    }

    public Component getComponent(String projectKey, int id) {
        Map components = this.cachedMap(new Call("getComponents", projectKey), Component.class, "id");
        return (Component)components.get(id + "");
    }

    public Component getComponent(Project project, int id) {
        return this.getComponent(project.getKey(), id);
    }

    public List<Version> getVersions(String projectKey) {
        return this.cachedList(new Call("getVersions", projectKey), Version.class);
    }

    public List<Version> getVersions(Project project) {
        return this.getVersions(project.getKey());
    }

    public Version getVersion(String projectKey, String name) {
        Map versions = this.cachedMap(new Call("getVersions", projectKey), Version.class, "name");
        return (Version)versions.get(name);
    }

    public Version getVersion(Project project, String name) {
        return this.getVersion(project.getKey(), name);
    }

    public Version getVersion(String projectKey, int id) {
        Map versions = this.cachedMap(new Call("getVersions", projectKey), Version.class, "id");
        return (Version)versions.get(id + "");
    }

    public Version getVersion(Project project, int id) {
        return this.getVersion(project.getKey(), id);
    }

    public List getFavoriteFilters() {
        return this.cachedList(new Call("getFavouriteFilters", new Object[0]), Filter.class);
    }

    private <T> List<T> toList(Object[] vector, Class<T> type) {
        MapObjectList<T> list = new MapObjectList<T>(vector.length);
        try {
            Constructor<T> constructor = type.getConstructor(Map.class);
            for (int i = 0; i < vector.length; ++i) {
                Map data = (Map)vector[i];
                T object = constructor.newInstance(data);
                this.fill(type, object);
                list.add(object);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    private void fill(Class type, Object object) {
        if (this.autofill && type == Issue.class) {
            this.fill((Issue)object);
        }
        if (type == Filter.class) {
            Filter filter = (Filter)object;
            User dest = filter.getAuthor();
            User source = this.getUser(dest.getName());
            dest.merge(source);
        }
    }

    private <T> T toObject(Map data, Class<T> type) {
        try {
            Constructor<T> constructor = type.getConstructor(Map.class);
            T object = constructor.newInstance(data);
            this.fill(type, object);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object call(String command, Object ... args) throws Exception {
        Object[] vector;
        if (this.token != null) {
            vector = new Object[args.length + 1];
            vector[0] = this.token;
            System.arraycopy(args, 0, vector, 1, args.length);
        } else {
            vector = args;
        }
        return this.client.execute("jira1." + command, vector);
    }

    public Issue fill(Issue issue) {
        for (IssueFiller issueFiller : this.issueFillers.values()) {
            issueFiller.fill(issue);
        }
        return issue;
    }

    private List cachedList(Call call, Class type) {
        Object result = this.cache(call, type);
        Map indexes = (Map)result;
        return (List)indexes.get(List.class);
    }

    private Map cachedMap(Call call, Class type, String field) {
        Object result = this.cache(call, type);
        Map indexes = (Map)result;
        return (Map)indexes.get(field);
    }

    private Object cachedObject(Call call, Class type) {
        return this.cache(call, type);
    }

    private <T> T cache(Call call, Class<T> type) {
        Object object = this.callcache.get(call);
        if (object != null) {
            return (T)object;
        }
        Object result = this.exec(call);
        if (result instanceof Object[]) {
            List<T> list = this.toList((Object[])result, type);
            HashMap<Object, Cloneable> indexes = new HashMap<Object, Cloneable>();
            String[] uniqueFields = (String[])cacheMetadata.get(type);
            for (int i = 0; uniqueFields != null && i < uniqueFields.length; ++i) {
                HashMap<String, MapObject> index = new HashMap<String, MapObject>();
                String field = uniqueFields[i];
                for (int j = 0; j < list.size(); ++j) {
                    MapObject mapObject = (MapObject)list.get(j);
                    index.put(mapObject.getString(field), mapObject);
                }
                indexes.put(field, index);
            }
            indexes.put(List.class, new MapObjectList(list));
            result = indexes;
        } else if (result instanceof Map) {
            result = this.toObject((Map)result, type);
        }
        this.callcache.put(call, result);
        return (T)result;
    }

    private Object exec(Call call) {
        try {
            Object[] vector;
            if (this.token != null) {
                vector = new Object[call.args.length + 1];
                vector[0] = this.token;
                System.arraycopy(call.args, 0, vector, 1, call.args.length);
            } else {
                vector = call.args;
            }
            return this.client.execute("jira1." + call.command, vector);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getVersionPrefix(int maxLength) {
        String fullVersion = this.getServerInfo().getVersion();
        if (fullVersion.length() > maxLength) {
            return fullVersion.substring(0, maxLength);
        }
        return fullVersion;
    }

    static {
        cacheMetadata.put(IssueType.class, new String[]{"id", "name"});
        cacheMetadata.put(Component.class, new String[]{"id", "name"});
        cacheMetadata.put(Priority.class, new String[]{"id", "name"});
        cacheMetadata.put(Resolution.class, new String[]{"id", "name"});
        cacheMetadata.put(Version.class, new String[]{"id", "name"});
        cacheMetadata.put(Status.class, new String[]{"id", "name"});
        cacheMetadata.put(Filter.class, new String[]{"id", "name"});
        cacheMetadata.put(Issue.class, new String[]{"id", "key"});
        cacheMetadata.put(Project.class, new String[]{"id", "key"});
    }

    public static class Call {
        public final String command;
        public final Object[] args;

        public Call(String command, Object ... args) {
            this.command = command;
            this.args = args;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Call call = (Call)o;
            if (!Arrays.equals(this.args, call.args)) {
                return false;
            }
            return this.command.equals(call.command);
        }

        public int hashCode() {
            return this.command.hashCode();
        }
    }
}

