/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jira;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.codehaus.swizzle.jira.Comment;
import org.codehaus.swizzle.jira.Component;
import org.codehaus.swizzle.jira.Issue;
import org.codehaus.swizzle.jira.IssueRef;
import org.codehaus.swizzle.jira.IssueType;
import org.codehaus.swizzle.jira.MapObject;
import org.codehaus.swizzle.jira.MapObjectList;
import org.codehaus.swizzle.jira.Priority;
import org.codehaus.swizzle.jira.Resolution;
import org.codehaus.swizzle.jira.Status;
import org.codehaus.swizzle.jira.SubTasksFiller;
import org.codehaus.swizzle.jira.User;
import org.codehaus.swizzle.jira.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraRss {
    private static final Map autofillProviders = new HashMap();
    private Map<String, Issue> issues = new HashMap<String, Issue>();
    private URL url;
    private Stack<MapObject> objects = new Stack();

    public JiraRss(String query) throws Exception {
        this(new URL(query));
    }

    public JiraRss(URL url) throws Exception {
        this(JiraRss.openStream(url));
        this.url = url;
    }

    public JiraRss(InputStream in) throws Exception {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        ObjectBuilder objectBuilder = new ObjectBuilder();
        saxParser.parse(in, (org.xml.sax.helpers.DefaultHandler)objectBuilder);
        List<Issue> list = objectBuilder.getIssues();
        for (Issue issue : list) {
            this.issues.put(issue.getKey(), issue);
            try {
                String project = issue.getKey().split("-")[0];
                issue.setString("project", project);
            }
            catch (Exception dontCare) {}
        }
        SubTasksFiller.JiraRssResolver existingIssues = new SubTasksFiller.JiraRssResolver(this);
        for (Issue issue : list) {
            SubTasksFiller.fillSubtasks(issue, existingIssues);
        }
    }

    private static InputStream openStream(URL url) throws IOException {
        String location;
        HttpURLConnection httpConnection;
        int code;
        URLConnection urlConnection = url.openConnection();
        if (urlConnection instanceof HttpURLConnection && ((code = (httpConnection = (HttpURLConnection)urlConnection).getResponseCode()) == 301 || code == 302) && (location = httpConnection.getHeaderField("Location")) != null) {
            URL redirect = new URL(url, location);
            return JiraRss.openStream(redirect);
        }
        return urlConnection.getInputStream();
    }

    public void autofill(String scheme) {
        if (!autofillProviders.containsKey(scheme)) {
            throw new UnsupportedOperationException("Autofill Scheme not supported: " + scheme);
        }
        try {
            String className = (String)autofillProviders.get(scheme);
            List<Issue> list = this.fill(className);
            for (Issue issue : list) {
                this.issues.put(issue.getKey(), issue);
            }
        }
        catch (Exception e) {
            System.err.println("Cannot install autofill provider " + scheme);
            e.printStackTrace();
        }
    }

    public List<Issue> fillVotes() throws Exception {
        return this.fill("org.codehaus.swizzle.jira.VotersFiller");
    }

    public List<Issue> fillSubTasks() throws Exception {
        return this.fill("org.codehaus.swizzle.jira.SubTasksFiller");
    }

    private List<Issue> fill(String className) throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class<?> clazz = classLoader.loadClass(className);
        Method fill = clazz.getMethod("fill", JiraRss.class);
        try {
            return (List)fill.invoke(null, this);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
            }
            throw e;
        }
    }

    public List<Issue> fillAttachments() throws Exception {
        this.autofill("attachments");
        return this.getIssues();
    }

    public List<Issue> getIssues() {
        return new MapObjectList<Issue>((Collection)this.issues.values());
    }

    public Issue getIssue(String key) {
        return this.issues.get(key);
    }

    static {
        autofillProviders.put("voters", "org.codehaus.swizzle.jira.VotersFiller");
        autofillProviders.put("subtasks", "org.codehaus.swizzle.jira.SubTasksFiller");
        autofillProviders.put("attachments", "org.codehaus.swizzle.jira.AttachmentsFiller");
    }

    public class CommentHandler
    extends MapObjectListHandler {
        public CommentHandler() {
            super(Comment.class);
            this.atts.clear();
            this.atts.put("author", "username");
            this.atts.put("created", "timePerformed");
            this.contentField = "body";
        }

        protected Object clone() {
            return new CommentHandler();
        }

        public void endElement(String string, String string1, String string2) throws SAXException {
            String text = this.value.toString();
            text = text.replaceAll("^<p>|</p>$", "");
            this.value = new StringBuffer(text);
            super.endElement(string, string1, string2);
        }
    }

    public class SubtaskHanlder
    extends MapObjectListHandler {
        public SubtaskHanlder() {
            super(IssueRef.class, "key", "subTasks");
        }

        protected void setMapObject(String qName, MapObject mapObject) {
            Issue parent = (Issue)JiraRss.this.objects.peek();
            Issue child = (Issue)mapObject;
            parent.getSubTasks().add(child);
            child.setParentTask(parent);
        }
    }

    public class MapObjectListHandler
    extends MapObjectHandler {
        private String fieldName;

        public MapObjectListHandler(Class mapObjectClass, String contentField, String fieldName) {
            super(mapObjectClass, contentField);
            this.fieldName = fieldName;
        }

        public MapObjectListHandler(Class mapObjectClass) {
            super(mapObjectClass);
            this.fieldName = null;
        }

        public MapObjectListHandler(Class mapObjectClass, String contentField) {
            super(mapObjectClass, contentField);
            this.fieldName = null;
        }

        public MapObjectListHandler setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        protected void setMapObject(String qName, MapObject mapObject) {
            MapObject parent = (MapObject)JiraRss.this.objects.peek();
            List<?> list = parent.getMapObjects(this.getFieldName(qName), mapObject.getClass());
            list.add(mapObject);
        }

        protected String getFieldName(String qName) {
            return this.fieldName != null ? this.fieldName : qName + "s";
        }

        protected Object clone() {
            return new MapObjectListHandler(this.mapObjectClass, this.contentField, this.fieldName);
        }
    }

    public class UserHandler
    extends MapObjectHandler {
        public UserHandler() {
            super(User.class);
            this.atts.clear();
            this.atts.put("username", "name");
            this.contentField = "fullname";
        }

        protected Object clone() {
            return new UserHandler();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MapObjectHandler<T extends MapObject>
    extends DefaultHandler {
        protected Map<String, String> atts;
        protected T mapObject;
        protected StringBuffer value;
        protected String contentField;
        protected Class<T> mapObjectClass;

        public MapObjectHandler(Class<T> mapObjectClass) {
            this(mapObjectClass, "name");
        }

        public MapObjectHandler(Class<T> mapObjectClass, String contentField) {
            this.atts = new HashMap<String, String>();
            this.value = new StringBuffer();
            this.mapObjectClass = mapObjectClass;
            this.contentField = contentField;
            this.atts.put("id", "id");
        }

        public MapObjectHandler setContentField(String contentField) {
            this.contentField = contentField;
            return this;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.mapObject = this.createMapObject();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                String field = this.atts.get(name);
                if (field == null) continue;
                ((MapObject)this.mapObject).setString(field, value);
            }
            this.setMapObject(qName, (MapObject)this.mapObject);
            JiraRss.this.objects.push(this.mapObject);
        }

        private T createMapObject() {
            if (this.mapObject != null) {
                return this.mapObject;
            }
            try {
                Constructor<T> constructor = this.mapObjectClass.getConstructor(Map.class);
                return (T)((MapObject)constructor.newInstance(new HashMap()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected void setMapObject(String qName, MapObject mapObject) {
            try {
                MapObject parent = (MapObject)JiraRss.this.objects.peek();
                parent.setMapObject(qName, mapObject);
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }

        @Override
        public void characters(char[] chars, int i, int i1) throws SAXException {
            this.value.append(chars, i, i1);
        }

        @Override
        public void endElement(String string, String string1, String string2) throws SAXException {
            JiraRss.this.objects.pop();
            if (this.contentField != null) {
                ((MapObject)this.mapObject).setString(this.contentField, this.value.toString());
            }
        }

        @Override
        protected Object clone() {
            return new MapObjectHandler<T>(this.mapObjectClass, this.contentField);
        }
    }

    public class KeyHandler
    extends TextHandler {
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            MapObject status = (MapObject)JiraRss.this.objects.peek();
            status.setString("id", attributes.getValue("id"));
            super.startElement(uri, localName, qName, attributes);
        }

        protected Object clone() {
            return new KeyHandler();
        }
    }

    public class TextHandler
    extends DefaultHandler {
        protected StringBuffer value;
        protected String name;

        public TextHandler() {
            this.value = new StringBuffer();
        }

        public TextHandler(String name) {
            this.value = new StringBuffer();
            this.name = name;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.name == null) {
                this.name = qName;
            }
        }

        public void characters(char[] chars, int i, int i1) throws SAXException {
            this.value.append(chars, i, i1);
        }

        public void endElement(String string, String string1, String string2) throws SAXException {
            MapObject status = (MapObject)JiraRss.this.objects.peek();
            String text = this.value.toString();
            text = text.replaceAll("^<p>|</p>$", "");
            status.setString(this.name, text);
        }

        protected Object clone() {
            return new TextHandler(this.name);
        }
    }

    public class DefaultHandler
    extends org.xml.sax.helpers.DefaultHandler
    implements Cloneable {
        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Channel
    extends MapObject {
        public Channel() {
            super(new HashMap());
        }

        public Channel(Map data) {
            super(data);
        }

        public List<Issue> getIssues() {
            return this.getMapObjects("items", Issue.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectBuilder
    extends DefaultHandler {
        private Map handlers = new HashMap();
        private Stack<DefaultHandler> handlerStack = new Stack();
        private Channel channel;

        public ObjectBuilder() {
            TextHandler textHandler = new TextHandler();
            this.registerHandler("item", new MapObjectListHandler(Issue.class, null));
            this.registerHandler("priority", new MapObjectHandler<Priority>(Priority.class));
            this.registerHandler("status", new MapObjectHandler<Status>(Status.class));
            this.registerHandler("type", new MapObjectHandler<IssueType>(IssueType.class));
            this.registerHandler("resolution", new MapObjectHandler<Resolution>(Resolution.class));
            this.registerHandler("fixVersion", new MapObjectListHandler(Version.class));
            this.registerHandler("affectsVersion", new MapObjectListHandler(Version.class));
            this.registerHandler("subtask", new SubtaskHanlder());
            this.registerHandler("assignee", new UserHandler());
            this.registerHandler("reporter", new UserHandler());
            this.registerHandler("component", new MapObjectListHandler(Component.class));
            this.registerHandler("comment", new CommentHandler());
            this.registerHandler("title", textHandler);
            this.registerHandler("link", textHandler);
            this.registerHandler("description", textHandler);
            this.registerHandler("environment", textHandler);
            this.registerHandler("summary", textHandler);
            this.registerHandler("created", textHandler);
            this.registerHandler("updated", textHandler);
            this.registerHandler("votes", textHandler);
            this.registerHandler("due", new TextHandler("duedate"));
            this.registerHandler("key", new KeyHandler());
            this.channel = new Channel();
            JiraRss.this.objects.push(this.channel);
        }

        public void registerHandler(String name, Object handler) {
            this.handlers.put(name, handler);
        }

        public List<Issue> getIssues() {
            return this.channel.getIssues();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            DefaultHandler handler = this.createHandler(qName);
            this.handlerStack.push(handler);
            handler.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void characters(char[] chars, int i, int i1) throws SAXException {
            DefaultHandler handler = this.handlerStack.peek();
            handler.characters(chars, i, i1);
        }

        @Override
        public void endElement(String string, String string1, String string2) throws SAXException {
            DefaultHandler handler = this.handlerStack.pop();
            handler.endElement(string, string1, string2);
        }

        private DefaultHandler createHandler(String qName) {
            Object object = this.handlers.get(qName);
            if (object == null) {
                return new DefaultHandler();
            }
            if (object instanceof DefaultHandler) {
                try {
                    DefaultHandler handler = (DefaultHandler)object;
                    return (DefaultHandler)handler.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (object instanceof Class) {
                Class handlerClass = (Class)object;
                try {
                    return (DefaultHandler)handlerClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalStateException("Unknown handler type " + object.getClass().getName());
        }
    }
}

