/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jira;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.swizzle.jira.Issue;
import org.codehaus.swizzle.jira.IssueFiller;
import org.codehaus.swizzle.jira.IssueRef;
import org.codehaus.swizzle.jira.Jira;
import org.codehaus.swizzle.jira.JiraRss;
import org.codehaus.swizzle.jira.MapObjectList;

public class SubTasksFiller
implements IssueFiller {
    private final Jira jira;
    private boolean enabled;

    public SubTasksFiller(Jira jira) {
        this.jira = jira;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void fill(Issue issue) {
        if (!this.enabled) {
            return;
        }
        if (issue.getParentTask() != null) {
            return;
        }
        SubTasksFiller.fillSubtasks(issue, new JiraResolver(this.jira));
    }

    public static void main(String[] args) throws Exception {
        JiraRss jiraRss = new JiraRss("https://issues.apache.org/jira/si/jira.issueviews:issue-xml/OPENEJB-1133/OPENEJB-1133.xml");
        SubTasksFiller.fill(jiraRss);
    }

    public static List fill(JiraRss jiraRss) throws Exception {
        MapObjectList issues = (MapObjectList)jiraRss.getIssues();
        issues = issues.ascending("id");
        RssResolver rssResolver = new RssResolver();
        for (int i = 0; i < issues.size(); ++i) {
            Issue issue = (Issue)issues.get(i);
            SubTasksFiller.fillSubtasks(issue, rssResolver);
        }
        return issues;
    }

    public static void fillSubtasks(Issue parent, Resolver resolver) {
        if (parent.getParentTask() != null) {
            return;
        }
        List<Issue> subtasks = parent.getSubTasks();
        ArrayList<Issue> replacements = new ArrayList<Issue>();
        Iterator<Issue> it = subtasks.iterator();
        while (it.hasNext()) {
            Issue full;
            Issue subtask = it.next();
            if (!(subtask instanceof IssueRef) || (full = resolver.getIssue(parent, subtask.getKey())) == null) continue;
            it.remove();
            full.setParentTask(parent);
            replacements.add(full);
        }
        subtasks.addAll(replacements);
    }

    public static class RssResolver
    implements Resolver {
        public Issue getIssue(Issue parent, String key) {
            try {
                String link = parent.getLink();
                URL base = new URL(link.replaceAll("/browse/.*", "/"));
                URL rssURL = new URL(base, "si/jira.issueviews:issue-xml/" + key + "/" + key + ".xml");
                JiraRss jiraRss = new JiraRss(rssURL);
                return jiraRss.getIssue(key);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to get issue " + key + " via rss", e);
            }
        }
    }

    public static class JiraResolver
    implements Resolver {
        private final Jira jira;

        public JiraResolver(Jira jira) {
            this.jira = jira;
        }

        public Issue getIssue(Issue parent, String key) {
            return this.jira.getIssue(key);
        }
    }

    public static class JiraRssResolver
    implements Resolver {
        private final JiraRss jiraRss;

        public JiraRssResolver(JiraRss jiraRss) {
            this.jiraRss = jiraRss;
        }

        public Issue getIssue(Issue parent, String key) {
            return this.jiraRss.getIssue(key);
        }
    }

    public static interface Resolver {
        public Issue getIssue(Issue var1, String var2);
    }
}

