/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.TraceLogger;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;

public class KBpolygon
extends KBobject
implements Serializable,
Cloneable {
    public KBpoint[] points;

    public KBpolygon(KBpoint[] points) {
        this();
        this.points = points;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBpolygon(String s) throws SQLException {
        this();
        this.setValue(s);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBpolygon() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("polygon");
    }

    @Override
    public void setValue(String s) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBtokenizer t = new KBtokenizer(KBtokenizer.removePara(s), ',');
        int npoints = t.getSize();
        this.points = new KBpoint[npoints];
        for (int p = 0; p < npoints; ++p) {
            this.points[p] = new KBpoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (objt instanceof KBpolygon) {
            KBpolygon pnt = (KBpolygon)objt;
            if (pnt.points.length != this.points.length) {
                return false;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(pnt.points[i])) continue;
                return false;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int hashVal = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            hashVal ^= this.points[i].hashCode();
        }
        return hashVal;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBpolygon newKBpolygon = (KBpolygon)super.clone();
        if (newKBpolygon.points != null) {
            newKBpolygon.points = (KBpoint[])newKBpolygon.points.clone();
            for (int i = 0; i < newKBpolygon.points.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (newKBpolygon.points[i] == null) continue;
                newKBpolygon.points[i] = (KBpoint)newKBpolygon.points[i].clone();
            }
        }
        return newKBpolygon;
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int p = 0; p < this.points.length; ++p) {
            if (p > 0) {
                sb.append(",");
            }
            sb.append(this.points[p].toString());
        }
        sb.append(")");
        return sb.toString();
    }
}

