/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.extrnal;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnExternalStorage;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoBetaWrapper;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.extrnal.ExternalStoragePaginationHelperImpl;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoBetaMapper;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Conditional(value={ConditionOnExternalStorage.class})
@Service(value="externalConfigInfoBetaPersistServiceImpl")
public class ExternalConfigInfoBetaPersistServiceImpl
implements ConfigInfoBetaPersistService {
    private DataSourceService dataSourceService = DynamicDataSource.getInstance().getDataSource();
    protected JdbcTemplate jt = this.dataSourceService.getJdbcTemplate();
    protected TransactionTemplate tjt = this.dataSourceService.getTransactionTemplate();
    private MapperManager mapperManager;

    public ExternalConfigInfoBetaPersistServiceImpl() {
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new ExternalStoragePaginationHelperImpl(this.jt);
    }

    @Override
    public void addConfigInfo4Beta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String encryptedDataKey = StringUtils.isBlank((CharSequence)configInfo.getEncryptedDataKey()) ? "" : configInfo.getEncryptedDataKey();
        try {
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            this.jt.update(configInfoBetaMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "app_name", "content", "md5", "beta_ips", "src_ip", "src_user", "gmt_create", "gmt_modified", "encrypted_data_key")), new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5, betaIps, srcIp, srcUser, time, time, encryptedDataKey});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void insertOrUpdateBeta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        try {
            this.addConfigInfo4Beta(configInfo, betaIps, srcIp, null, time, notify);
        }
        catch (DataIntegrityViolationException ive) {
            this.updateConfigInfo4Beta(configInfo, betaIps, srcIp, null, time, notify);
        }
    }

    @Override
    public boolean insertOrUpdateBetaCas(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        try {
            this.addConfigInfo4Beta(configInfo, betaIps, srcIp, null, time, notify);
            return true;
        }
        catch (DataIntegrityViolationException ive) {
            return this.updateConfigInfo4BetaCas(configInfo, betaIps, srcIp, null, time, notify);
        }
    }

    @Override
    public void removeConfigInfo4Beta(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        this.tjt.execute(status -> {
            try {
                ConfigInfoBetaWrapper configInfo = this.findConfigInfo4Beta(dataId, group, tenant);
                if (configInfo != null) {
                    ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
                    this.jt.update(configInfoBetaMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id")), new Object[]{dataId, group, tenantTmp});
                }
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
                throw e;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public void updateConfigInfo4Beta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String encryptedDataKey = StringUtils.isBlank((CharSequence)configInfo.getEncryptedDataKey()) ? "" : configInfo.getEncryptedDataKey();
        try {
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            this.jt.update(configInfoBetaMapper.update(Arrays.asList("content", "md5", "beta_ips", "src_ip", "src_user", "gmt_modified", "app_name", "encrypted_data_key"), Arrays.asList("data_id", "group_id", "tenant_id")), new Object[]{configInfo.getContent(), md5, betaIps, srcIp, srcUser, time, appNameTmp, encryptedDataKey, configInfo.getDataId(), configInfo.getGroup(), tenantTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean updateConfigInfo4BetaCas(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        try {
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            return this.jt.update(configInfoBetaMapper.updateConfigInfo4BetaCas(), new Object[]{configInfo.getContent(), md5, betaIps, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, configInfo.getMd5()}) > 0;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfoBetaWrapper findConfigInfo4Beta(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            return (ConfigInfoBetaWrapper)this.jt.queryForObject(configInfoBetaMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "app_name", "content", "beta_ips", "encrypted_data_key"), Arrays.asList("data_id", "group_id", "tenant_id")), new Object[]{dataId, group, tenantTmp}, (RowMapper)RowMapperManager.CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public int configInfoBetaCount() {
        ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
        String sql = configInfoBetaMapper.count(null);
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    @Override
    public Page<ConfigInfoBetaWrapper> findAllConfigInfoBetaForDumpAll(int pageNo, int pageSize) {
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
        String sqlCountRows = configInfoBetaMapper.count(null);
        String sqlFetchRows = configInfoBetaMapper.findAllConfigInfoBetaForDumpAllFetchRows(startRow, pageSize);
        PaginationHelper<ConfigInfoBetaWrapper> helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[0], pageNo, pageSize, RowMapperManager.CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }
}

