/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.tps;

import com.alibaba.nacos.plugin.control.tps.MonitorType;
import com.alibaba.nacos.plugin.control.tps.TpsMetrics;
import com.alibaba.nacos.plugin.control.tps.request.BarrierCheckRequest;
import com.alibaba.nacos.plugin.control.tps.response.TpsCheckResponse;
import com.alibaba.nacos.plugin.control.tps.rule.RuleDetail;
import java.util.concurrent.TimeUnit;

public abstract class RuleBarrier {
    private TimeUnit period;
    private String pointName;
    private long maxCount;
    private String ruleName;
    private String monitorType;

    public RuleBarrier() {
        this.monitorType = MonitorType.MONITOR.type;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getPointName() {
        return this.pointName;
    }

    public void setPointName(String pointName) {
        this.pointName = pointName;
    }

    public TimeUnit getPeriod() {
        return this.period;
    }

    public void setPeriod(TimeUnit period) {
        this.period = period;
    }

    public abstract String getBarrierName();

    public long getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(long maxCount) {
        this.maxCount = maxCount;
    }

    public String getMonitorType() {
        return this.monitorType;
    }

    public void setMonitorType(String monitorType) {
        this.monitorType = monitorType;
    }

    public boolean isMonitorType() {
        return MonitorType.MONITOR.type.equalsIgnoreCase(this.monitorType);
    }

    public String getLimitMsg() {
        return String.format("[Period:%s,MaxCount:%s]", new Object[]{this.period, this.maxCount});
    }

    public abstract TpsCheckResponse applyTps(BarrierCheckRequest var1);

    public abstract void applyRuleDetail(RuleDetail var1);

    public abstract TpsMetrics getMetrics(long var1);

    public void clearLimitRule() {
        this.maxCount = -1L;
        this.monitorType = MonitorType.MONITOR.getType();
    }
}

