/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.tps;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.configs.ControlConfigs;
import com.alibaba.nacos.plugin.control.tps.TpsBarrierCreator;
import com.alibaba.nacos.plugin.control.tps.nacos.DefaultNacosTpsBarrierCreator;
import java.util.Collection;

public class TpsBarrierCreatorProxy {
    static TpsBarrierCreator tpsBarrierCreator;

    public static TpsBarrierCreator getTpsBarrierCreator() {
        return tpsBarrierCreator;
    }

    static {
        String tpsRuleBarrierCreator = null;
        try {
            tpsRuleBarrierCreator = ControlConfigs.getInstance().getTpsRuleBarrierCreator();
            Collection loadedCreators = NacosServiceLoader.load(TpsBarrierCreator.class);
            for (TpsBarrierCreator barrierCreator : loadedCreators) {
                if (!tpsRuleBarrierCreator.equalsIgnoreCase(barrierCreator.getName())) continue;
                Loggers.CONTROL.info("Found tps barrier creator of name : {}", (Object)tpsRuleBarrierCreator);
                tpsBarrierCreator = barrierCreator;
                break;
            }
        }
        catch (Throwable throwable) {
            Loggers.CONTROL.warn("Fail to load tpsRuleBarrierCreator ", throwable);
        }
        if (tpsBarrierCreator == null) {
            Loggers.CONTROL.warn("Fail to found tps barrier creator of name : {},use  default local simple creator", (Object)tpsRuleBarrierCreator);
            tpsBarrierCreator = new DefaultNacosTpsBarrierCreator();
        }
    }
}

