/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.metadata;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.EventPublisherFactory;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.event.client.ClientEvent;
import com.alibaba.nacos.naming.core.v2.event.metadata.MetadataEvent;
import com.alibaba.nacos.naming.core.v2.event.publisher.NamingEventPublisherFactory;
import com.alibaba.nacos.naming.core.v2.metadata.ExpiredMetadataInfo;
import com.alibaba.nacos.naming.core.v2.metadata.InstanceMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.stereotype.Component;

@Component
public class NamingMetadataManager
extends SmartSubscriber {
    private final Set<ExpiredMetadataInfo> expiredMetadataInfos;
    private ConcurrentMap<Service, ServiceMetadata> serviceMetadataMap = new ConcurrentHashMap<Service, ServiceMetadata>(1024);
    private ConcurrentMap<Service, ConcurrentMap<String, InstanceMetadata>> instanceMetadataMap = new ConcurrentHashMap<Service, ConcurrentMap<String, InstanceMetadata>>(1024);
    private static final int INITIAL_CAPACITY = 1;

    public NamingMetadataManager() {
        this.expiredMetadataInfos = new ConcurrentHashSet();
        NotifyCenter.registerSubscriber((Subscriber)this, (EventPublisherFactory)NamingEventPublisherFactory.getInstance());
    }

    public boolean containServiceMetadata(Service service) {
        return this.serviceMetadataMap.containsKey(service);
    }

    public boolean containInstanceMetadata(Service service, String metadataId) {
        return this.instanceMetadataMap.containsKey(service) && ((ConcurrentMap)this.instanceMetadataMap.get(service)).containsKey(metadataId);
    }

    public Optional<ServiceMetadata> getServiceMetadata(Service service) {
        return Optional.ofNullable(this.serviceMetadataMap.get(service));
    }

    public Optional<InstanceMetadata> getInstanceMetadata(Service service, String metadataId) {
        ConcurrentMap instanceMetadataMapForService = (ConcurrentMap)this.instanceMetadataMap.get(service);
        if (null == instanceMetadataMapForService) {
            return Optional.empty();
        }
        return Optional.ofNullable(instanceMetadataMapForService.get(metadataId));
    }

    public void updateServiceMetadata(Service service, ServiceMetadata serviceMetadata) {
        service.incrementRevision();
        this.serviceMetadataMap.put(service, serviceMetadata);
    }

    public void updateInstanceMetadata(Service service, String metadataId, InstanceMetadata instanceMetadata) {
        if (!this.instanceMetadataMap.containsKey(service)) {
            this.instanceMetadataMap.putIfAbsent(service, new ConcurrentHashMap(1));
        }
        ((ConcurrentMap)this.instanceMetadataMap.get(service)).put(metadataId, instanceMetadata);
    }

    public void removeServiceMetadata(Service service) {
        this.serviceMetadataMap.remove(service);
        this.expiredMetadataInfos.remove(ExpiredMetadataInfo.newExpiredServiceMetadata(service));
    }

    public void removeInstanceMetadata(Service service, String metadataId) {
        ConcurrentMap instanceMetadataMapForService = (ConcurrentMap)this.instanceMetadataMap.get(service);
        if (null != instanceMetadataMapForService) {
            instanceMetadataMapForService.remove(metadataId);
            if (instanceMetadataMapForService.isEmpty()) {
                this.serviceMetadataMap.remove(service);
            }
        }
        this.expiredMetadataInfos.remove(ExpiredMetadataInfo.newExpiredInstanceMetadata(service, metadataId));
    }

    public Map<Service, ServiceMetadata> getServiceMetadataSnapshot() {
        ConcurrentHashMap<Service, ServiceMetadata> result = new ConcurrentHashMap<Service, ServiceMetadata>(this.serviceMetadataMap.size());
        result.putAll(this.serviceMetadataMap);
        return result;
    }

    public Map<Service, ConcurrentMap<String, InstanceMetadata>> getInstanceMetadataSnapshot() {
        ConcurrentHashMap<Service, ConcurrentMap<String, InstanceMetadata>> result = new ConcurrentHashMap<Service, ConcurrentMap<String, InstanceMetadata>>(this.instanceMetadataMap.size());
        result.putAll(this.instanceMetadataMap);
        return result;
    }

    public void loadServiceMetadataSnapshot(ConcurrentMap<Service, ServiceMetadata> snapshot) {
        for (Service each : snapshot.keySet()) {
            ServiceManager.getInstance().getSingleton(each);
        }
        ConcurrentMap<Service, ServiceMetadata> oldSnapshot = this.serviceMetadataMap;
        this.serviceMetadataMap = snapshot;
        oldSnapshot.clear();
    }

    public void loadInstanceMetadataSnapshot(ConcurrentMap<Service, ConcurrentMap<String, InstanceMetadata>> snapshot) {
        ConcurrentMap<Service, ConcurrentMap<String, InstanceMetadata>> oldSnapshot = this.instanceMetadataMap;
        this.instanceMetadataMap = snapshot;
        oldSnapshot.clear();
    }

    public Set<ExpiredMetadataInfo> getExpiredMetadataInfos() {
        return this.expiredMetadataInfos;
    }

    public List<Class<? extends Event>> subscribeTypes() {
        LinkedList<Class<? extends Event>> result = new LinkedList<Class<? extends Event>>();
        result.add(MetadataEvent.InstanceMetadataEvent.class);
        result.add(MetadataEvent.ServiceMetadataEvent.class);
        result.add(ClientEvent.ClientDisconnectEvent.class);
        return result;
    }

    public void onEvent(Event event) {
        if (event instanceof MetadataEvent.InstanceMetadataEvent) {
            this.handleInstanceMetadataEvent((MetadataEvent.InstanceMetadataEvent)event);
        } else if (event instanceof MetadataEvent.ServiceMetadataEvent) {
            this.handleServiceMetadataEvent((MetadataEvent.ServiceMetadataEvent)event);
        } else {
            this.handleClientDisconnectEvent((ClientEvent.ClientDisconnectEvent)event);
        }
    }

    private void handleClientDisconnectEvent(ClientEvent.ClientDisconnectEvent event) {
        for (Service each : event.getClient().getAllPublishedService()) {
            String metadataId;
            if (!this.containInstanceMetadata(each, metadataId = event.getClient().getInstancePublishInfo(each).getMetadataId())) continue;
            this.updateExpiredInfo(true, ExpiredMetadataInfo.newExpiredInstanceMetadata(each, metadataId));
        }
    }

    private void handleServiceMetadataEvent(MetadataEvent.ServiceMetadataEvent event) {
        Service service = event.getService();
        if (this.containServiceMetadata(service)) {
            this.updateExpiredInfo(event.isExpired(), ExpiredMetadataInfo.newExpiredServiceMetadata(service));
        }
    }

    private void handleInstanceMetadataEvent(MetadataEvent.InstanceMetadataEvent event) {
        String metadataId;
        Service service = event.getService();
        if (this.containInstanceMetadata(service, metadataId = event.getMetadataId())) {
            this.updateExpiredInfo(event.isExpired(), ExpiredMetadataInfo.newExpiredInstanceMetadata(event.getService(), event.getMetadataId()));
        }
    }

    private void updateExpiredInfo(boolean expired, ExpiredMetadataInfo expiredMetadataInfo) {
        if (expired) {
            this.expiredMetadataInfos.add(expiredMetadataInfo);
        } else {
            this.expiredMetadataInfos.remove(expiredMetadataInfo);
        }
    }
}

