/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.ap.internal.gem.AnnotateWithGem;
import org.mapstruct.ap.internal.gem.AnnotateWithsGem;
import org.mapstruct.ap.internal.gem.DeprecatedGem;
import org.mapstruct.ap.internal.gem.ElementGem;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.annotation.AnnotationElement;
import org.mapstruct.ap.internal.model.annotation.EnumAnnotationElementHolder;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.util.ElementUtils;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.RepeatableAnnotations;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.GemValue;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

public class AdditionalAnnotationsBuilder
extends RepeatableAnnotations<AnnotateWithGem, AnnotateWithsGem, Annotation> {
    private static final String ANNOTATE_WITH_FQN = "org.mapstruct.AnnotateWith";
    private static final String ANNOTATE_WITHS_FQN = "org.mapstruct.AnnotateWiths";
    private TypeFactory typeFactory;
    private FormattingMessager messager;

    public AdditionalAnnotationsBuilder(ElementUtils elementUtils, TypeFactory typeFactory, FormattingMessager messager) {
        super(elementUtils, ANNOTATE_WITH_FQN, ANNOTATE_WITHS_FQN);
        this.typeFactory = typeFactory;
        this.messager = messager;
    }

    @Override
    protected AnnotateWithGem singularInstanceOn(Element element) {
        return AnnotateWithGem.instanceOn(element);
    }

    @Override
    protected AnnotateWithsGem multipleInstanceOn(Element element) {
        return AnnotateWithsGem.instanceOn(element);
    }

    @Override
    protected void addInstance(AnnotateWithGem gem, Element source, Set<Annotation> mappings) {
        this.buildAnnotation(gem, source).ifPresent(t -> this.addAndValidateMapping(mappings, source, gem, (Annotation)t));
    }

    @Override
    protected void addInstances(AnnotateWithsGem gem, Element source, Set<Annotation> mappings) {
        for (AnnotateWithGem annotateWithGem : gem.value().get()) {
            this.buildAnnotation(annotateWithGem, source).ifPresent(t -> this.addAndValidateMapping(mappings, source, annotateWithGem, (Annotation)t));
        }
    }

    @Override
    public Set<Annotation> getProcessedAnnotations(Element source) {
        Set<Annotation> processedAnnotations = super.getProcessedAnnotations(source);
        return this.addDeprecatedAnnotation(source, processedAnnotations);
    }

    private Set<Annotation> addDeprecatedAnnotation(Element source, Set<Annotation> annotations) {
        DeprecatedGem deprecatedGem = DeprecatedGem.instanceOn(source);
        if (deprecatedGem == null) {
            return annotations;
        }
        Type deprecatedType = this.typeFactory.getType(Deprecated.class);
        if (annotations.stream().anyMatch(annotation -> annotation.getType().equals(deprecatedType))) {
            this.messager.printMessage(source, deprecatedGem.mirror(), Message.ANNOTATE_WITH_DUPLICATE, deprecatedType.describe());
            return annotations;
        }
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        if (deprecatedGem.since() != null && deprecatedGem.since().hasValue()) {
            annotationElements.add(new AnnotationElement(AnnotationElement.AnnotationElementType.STRING, "since", Collections.singletonList(deprecatedGem.since().getValue())));
        }
        if (deprecatedGem.forRemoval() != null && deprecatedGem.forRemoval().hasValue()) {
            annotationElements.add(new AnnotationElement(AnnotationElement.AnnotationElementType.BOOLEAN, "forRemoval", Collections.singletonList(deprecatedGem.forRemoval().getValue())));
        }
        annotations.add(new Annotation(deprecatedType, annotationElements));
        return annotations;
    }

    private void addAndValidateMapping(Set<Annotation> mappings, Element source, AnnotateWithGem gem, Annotation anno) {
        if (anno.getType().getTypeElement().getAnnotation(Repeatable.class) == null && mappings.stream().anyMatch(existing -> existing.getType().equals(anno.getType()))) {
            this.messager.printMessage(source, gem.mirror(), Message.ANNOTATE_WITH_ANNOTATION_IS_NOT_REPEATABLE, anno.getType().describe());
            return;
        }
        if (mappings.stream().anyMatch(existing -> existing.getType().equals(anno.getType()) && existing.getProperties().equals(anno.getProperties()))) {
            this.messager.printMessage(source, gem.mirror(), Message.ANNOTATE_WITH_DUPLICATE, anno.getType().describe());
            return;
        }
        mappings.add(anno);
    }

    private Optional<Annotation> buildAnnotation(AnnotateWithGem annotationGem, Element element) {
        List<ElementGem> eleGems;
        Type annotationType = this.typeFactory.getType(this.getTypeMirror(annotationGem.value()));
        if (this.isValid(annotationType, eleGems = annotationGem.elements().get(), element, annotationGem.mirror())) {
            return Optional.of(new Annotation(annotationType, this.convertToProperties(eleGems)));
        }
        return Optional.empty();
    }

    private List<AnnotationElement> convertToProperties(List<ElementGem> eleGems) {
        return eleGems.stream().map(gem -> this.convertToProperty((ElementGem)gem, this.typeFactory)).collect(Collectors.toList());
    }

    private AnnotationElement convertToProperty(ElementGem eleGem, TypeFactory typeFactory) {
        for (ConvertToProperty convertToJava : ConvertToProperty.values()) {
            if (!convertToJava.isUsable(eleGem)) continue;
            return convertToJava.toProperty(eleGem, typeFactory);
        }
        return null;
    }

    private boolean isValid(Type annotationType, List<ElementGem> eleGems, Element element, AnnotationMirror annotationMirror) {
        List<ExecutableElement> annotationElements;
        boolean isValid = true;
        if (!this.annotationIsAllowed(annotationType, element, annotationMirror)) {
            isValid = false;
        }
        if (!this.allRequiredElementsArePresent(annotationType, annotationElements = ElementFilter.methodsIn(annotationType.getTypeElement().getEnclosedElements()), eleGems, element, annotationMirror)) {
            isValid = false;
        }
        if (!this.allElementsAreKnownInAnnotation(annotationType, annotationElements, eleGems, element)) {
            isValid = false;
        }
        if (!this.allElementsAreOfCorrectType(annotationType, annotationElements, eleGems, element)) {
            isValid = false;
        }
        if (!this.enumConstructionIsCorrectlyUsed(eleGems, element)) {
            isValid = false;
        }
        if (!this.allElementsAreUnique(eleGems, element)) {
            isValid = false;
        }
        return isValid;
    }

    private boolean allElementsAreUnique(List<ElementGem> eleGems, Element element) {
        boolean isValid = true;
        ArrayList<String> checkedElements = new ArrayList<String>();
        for (ElementGem elementGem : eleGems) {
            String elementName = elementGem.name().get();
            if (checkedElements.contains(elementName)) {
                isValid = false;
                this.messager.printMessage(element, elementGem.mirror(), Message.ANNOTATE_WITH_DUPLICATE_PARAMETER, elementName);
                continue;
            }
            checkedElements.add(elementName);
        }
        return isValid;
    }

    private boolean enumConstructionIsCorrectlyUsed(List<ElementGem> eleGems, Element element) {
        boolean isValid = true;
        for (ElementGem elementGem : eleGems) {
            if (elementGem.enums().hasValue()) {
                if (elementGem.enumClass().getValue() == null) {
                    isValid = false;
                    this.messager.printMessage(element, elementGem.mirror(), Message.ANNOTATE_WITH_ENUM_CLASS_NOT_DEFINED, new Object[0]);
                    continue;
                }
                Type type = this.typeFactory.getType(this.getTypeMirror(elementGem.enumClass()));
                if (!type.isEnumType()) continue;
                List<String> enumConstants = type.getEnumConstants();
                for (String enumName : elementGem.enums().get()) {
                    if (enumConstants.contains(enumName)) continue;
                    isValid = false;
                    this.messager.printMessage(element, elementGem.mirror(), elementGem.enums().getAnnotationValue(), Message.ANNOTATE_WITH_ENUM_VALUE_DOES_NOT_EXIST, type.describe(), enumName);
                }
                continue;
            }
            if (elementGem.enumClass().getValue() == null) continue;
            isValid = false;
            this.messager.printMessage(element, elementGem.mirror(), Message.ANNOTATE_WITH_ENUMS_NOT_DEFINED, new Object[0]);
        }
        return isValid;
    }

    private boolean annotationIsAllowed(Type annotationType, Element element, AnnotationMirror annotationMirror) {
        Target target = annotationType.getTypeElement().getAnnotation(Target.class);
        if (target == null) {
            return true;
        }
        Set annotationTargets = Stream.of(target.value()).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(ElementType.class)));
        boolean isValid = true;
        if (this.isTypeTarget(element) && !annotationTargets.contains((Object)ElementType.TYPE)) {
            isValid = false;
            this.messager.printMessage(element, annotationMirror, Message.ANNOTATE_WITH_NOT_ALLOWED_ON_CLASS, annotationType.describe());
        }
        if (this.isMethodTarget(element) && !annotationTargets.contains((Object)ElementType.METHOD)) {
            isValid = false;
            this.messager.printMessage(element, annotationMirror, Message.ANNOTATE_WITH_NOT_ALLOWED_ON_METHODS, annotationType.describe());
        }
        return isValid;
    }

    private boolean isTypeTarget(Element element) {
        return element.getKind().isInterface() || element.getKind().isClass();
    }

    private boolean isMethodTarget(Element element) {
        return element.getKind() == ElementKind.METHOD;
    }

    private boolean allElementsAreKnownInAnnotation(Type annotationType, List<ExecutableElement> annotationParameters, List<ElementGem> eleGems, Element element) {
        Set<String> allowedAnnotationParameters = annotationParameters.stream().map(ee -> ee.getSimpleName().toString()).collect(Collectors.toSet());
        boolean isValid = true;
        for (ElementGem eleGem : eleGems) {
            if (!eleGem.name().isValid() || allowedAnnotationParameters.contains(eleGem.name().get())) continue;
            isValid = false;
            this.messager.printMessage(element, eleGem.mirror(), eleGem.name().getAnnotationValue(), Message.ANNOTATE_WITH_UNKNOWN_PARAMETER, eleGem.name().get(), annotationType.describe(), Strings.getMostSimilarWord(eleGem.name().get(), allowedAnnotationParameters));
        }
        return isValid;
    }

    private boolean allRequiredElementsArePresent(Type annotationType, List<ExecutableElement> annotationParameters, List<ElementGem> elements, Element element, AnnotationMirror annotationMirror) {
        boolean valid = true;
        for (ExecutableElement annotationParameter : annotationParameters) {
            if (annotationParameter.getDefaultValue() != null) continue;
            String parameterName = annotationParameter.getSimpleName().toString();
            boolean elementGemDefined = false;
            for (ElementGem elementGem : elements) {
                if (!elementGem.isValid() || !elementGem.name().get().equals(parameterName)) continue;
                elementGemDefined = true;
                break;
            }
            if (elementGemDefined) continue;
            valid = false;
            this.messager.printMessage(element, annotationMirror, Message.ANNOTATE_WITH_MISSING_REQUIRED_PARAMETER, parameterName, annotationType.describe());
        }
        return valid;
    }

    private boolean allElementsAreOfCorrectType(Type annotationType, List<ExecutableElement> annotationParameters, List<ElementGem> elements, Element element) {
        Map<String, ExecutableElement> annotationParametersByName = annotationParameters.stream().collect(Collectors.toMap(ee -> ee.getSimpleName().toString(), Function.identity()));
        boolean isValid = true;
        for (ElementGem eleGem : elements) {
            Type annotationParameterType = this.getAnnotationParameterType(annotationParametersByName, eleGem);
            Type annotationParameterTypeSingular = this.getNonArrayType(annotationParameterType);
            if (annotationParameterTypeSingular == null) continue;
            if (this.hasTooManyDifferentTypes(eleGem)) {
                isValid = false;
                this.messager.printMessage(element, eleGem.mirror(), eleGem.name().getAnnotationValue(), Message.ANNOTATE_WITH_TOO_MANY_VALUE_TYPES, eleGem.name().get(), annotationParameterType.describe(), annotationType.describe());
                continue;
            }
            Map<Type, Integer> elementTypes = this.getParameterTypes(eleGem);
            HashSet<ElementGem> reportedSizeError = new HashSet<ElementGem>();
            for (Type eleGemType : elementTypes.keySet()) {
                if (!this.sameTypeOrAssignableClass(annotationParameterTypeSingular, eleGemType)) {
                    isValid = false;
                    this.messager.printMessage(element, eleGem.mirror(), eleGem.name().getAnnotationValue(), Message.ANNOTATE_WITH_WRONG_PARAMETER, eleGem.name().get(), eleGemType.describe(), annotationParameterType.describe(), annotationType.describe());
                    continue;
                }
                if (annotationParameterType.isArrayType() || elementTypes.get(eleGemType) <= 1 || reportedSizeError.contains(eleGem)) continue;
                isValid = false;
                this.messager.printMessage(element, eleGem.mirror(), Message.ANNOTATE_WITH_PARAMETER_ARRAY_NOT_EXPECTED, eleGem.name().get(), annotationType.describe());
                reportedSizeError.add(eleGem);
            }
        }
        return isValid;
    }

    private boolean hasTooManyDifferentTypes(ElementGem eleGem) {
        return Arrays.stream(ConvertToProperty.values()).filter(anotationElement -> anotationElement.isUsable(eleGem)).count() > 1L;
    }

    private Type getNonArrayType(Type annotationParameterType) {
        if (annotationParameterType == null) {
            return null;
        }
        if (annotationParameterType.isArrayType()) {
            return annotationParameterType.getComponentType();
        }
        return annotationParameterType;
    }

    private boolean sameTypeOrAssignableClass(Type annotationParameterType, Type eleGemType) {
        return annotationParameterType.equals(eleGemType) || eleGemType.isAssignableTo(this.getTypeBound(annotationParameterType));
    }

    private Type getTypeBound(Type annotationParameterType) {
        List<Type> typeParameters = annotationParameterType.getTypeParameters();
        if (typeParameters.size() != 1) {
            return annotationParameterType;
        }
        return typeParameters.get(0).getTypeBound();
    }

    private Map<Type, Integer> getParameterTypes(ElementGem eleGem) {
        HashMap<Type, Integer> suppliedParameterTypes = new HashMap<Type, Integer>();
        if (eleGem.booleans().hasValue()) {
            suppliedParameterTypes.put(this.typeFactory.getType(Boolean.TYPE), eleGem.booleans().get().size());
        }
        if (eleGem.bytes().hasValue()) {
            suppliedParameterTypes.put(this.typeFactory.getType(Byte.TYPE), eleGem.bytes().get().size());
        }
        if (eleGem.chars().hasValue()) {
            suppliedParameterTypes.put(this.typeFactory.getType(Character.TYPE), eleGem.chars().get().size());
        }
        if (eleGem.classes().hasValue()) {
            for (TypeMirror mirror : eleGem.classes().get()) {
                suppliedParameterTypes.put(this.typeFactory.getType(this.typeMirrorFromAnnotation(mirror)), eleGem.classes().get().size());
            }
        }
        if (eleGem.doubles().hasValue()) {
            suppliedParameterTypes.put(this.typeFactory.getType(Double.TYPE), eleGem.doubles().get().size());
        }
        if (eleGem.floats().hasValue()) {
            suppliedParameterTypes.put(this.typeFactory.getType(Float.TYPE), eleGem.floats().get().size());
        }
        if (eleGem.ints().hasValue()) {
            suppliedParameterTypes.put(this.typeFactory.getType(Integer.TYPE), eleGem.ints().get().size());
        }
        if (eleGem.longs().hasValue()) {
            suppliedParameterTypes.put(this.typeFactory.getType(Long.TYPE), eleGem.longs().get().size());
        }
        if (eleGem.shorts().hasValue()) {
            suppliedParameterTypes.put(this.typeFactory.getType(Short.TYPE), eleGem.shorts().get().size());
        }
        if (eleGem.strings().hasValue()) {
            suppliedParameterTypes.put(this.typeFactory.getType(String.class), eleGem.strings().get().size());
        }
        if (eleGem.enums().hasValue() && eleGem.enumClass().hasValue()) {
            suppliedParameterTypes.put(this.typeFactory.getType(this.getTypeMirror(eleGem.enumClass())), eleGem.enums().get().size());
        }
        return suppliedParameterTypes;
    }

    private Type getAnnotationParameterType(Map<String, ExecutableElement> annotationParameters, ElementGem element) {
        if (annotationParameters.containsKey(element.name().get())) {
            return this.typeFactory.getType(annotationParameters.get(element.name().get()).getReturnType());
        }
        return null;
    }

    private TypeMirror getTypeMirror(GemValue<TypeMirror> gemValue) {
        return this.typeMirrorFromAnnotation(gemValue.getValue());
    }

    private TypeMirror typeMirrorFromAnnotation(TypeMirror typeMirror) {
        if (typeMirror == null) {
            throw new TypeHierarchyErroneousException(typeMirror);
        }
        return typeMirror;
    }

    private static enum ConvertToProperty {
        BOOLEAN(AnnotationElement.AnnotationElementType.BOOLEAN, (eleGem, typeFactory) -> eleGem.booleans().get(), eleGem -> eleGem.booleans().hasValue()),
        BYTE(AnnotationElement.AnnotationElementType.BYTE, (eleGem, typeFactory) -> eleGem.bytes().get(), eleGem -> eleGem.bytes().hasValue()),
        CHARACTER(AnnotationElement.AnnotationElementType.CHARACTER, (eleGem, typeFactory) -> eleGem.chars().get(), eleGem -> eleGem.chars().hasValue()),
        CLASSES(AnnotationElement.AnnotationElementType.CLASS, (eleGem, typeFactory) -> eleGem.classes().get().stream().map(typeFactory::getType).collect(Collectors.toList()), eleGem -> eleGem.classes().hasValue()),
        DOUBLE(AnnotationElement.AnnotationElementType.DOUBLE, (eleGem, typeFactory) -> eleGem.doubles().get(), eleGem -> eleGem.doubles().hasValue()),
        ENUM(AnnotationElement.AnnotationElementType.ENUM, (eleGem, typeFactory) -> {
            ArrayList<EnumAnnotationElementHolder> values = new ArrayList<EnumAnnotationElementHolder>();
            for (String enumName : eleGem.enums().get()) {
                Type type = typeFactory.getType(eleGem.enumClass().get());
                values.add(new EnumAnnotationElementHolder(type, enumName));
            }
            return values;
        }, eleGem -> eleGem.enums().hasValue() && eleGem.enumClass().hasValue()),
        FLOAT(AnnotationElement.AnnotationElementType.FLOAT, (eleGem, typeFactory) -> eleGem.floats().get(), eleGem -> eleGem.floats().hasValue()),
        INT(AnnotationElement.AnnotationElementType.INTEGER, (eleGem, typeFactory) -> eleGem.ints().get(), eleGem -> eleGem.ints().hasValue()),
        LONG(AnnotationElement.AnnotationElementType.LONG, (eleGem, typeFactory) -> eleGem.longs().get(), eleGem -> eleGem.longs().hasValue()),
        SHORT(AnnotationElement.AnnotationElementType.SHORT, (eleGem, typeFactory) -> eleGem.shorts().get(), eleGem -> eleGem.shorts().hasValue()),
        STRING(AnnotationElement.AnnotationElementType.STRING, (eleGem, typeFactory) -> eleGem.strings().get(), eleGem -> eleGem.strings().hasValue());

        private final AnnotationElement.AnnotationElementType type;
        private final BiFunction<ElementGem, TypeFactory, List<? extends Object>> factory;
        private final Predicate<ElementGem> usabilityChecker;

        private ConvertToProperty(AnnotationElement.AnnotationElementType type, BiFunction<ElementGem, TypeFactory, List<? extends Object>> factory, Predicate<ElementGem> usabilityChecker) {
            this.type = type;
            this.factory = factory;
            this.usabilityChecker = usabilityChecker;
        }

        AnnotationElement toProperty(ElementGem eleGem, TypeFactory typeFactory) {
            return new AnnotationElement(this.type, eleGem.name().get(), this.factory.apply(eleGem, typeFactory));
        }

        boolean isUsable(ElementGem eleGem) {
            return this.usabilityChecker.test(eleGem);
        }
    }
}

