/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.codec;

import java.nio.ByteBuffer;
import org.smartboot.http.common.codec.h2.codec.Http2Frame;

public class PriorityFrame
extends Http2Frame {
    private int streamDependency;
    private int weight;
    private boolean exclusive;

    public PriorityFrame(int streamId, int flags, int remaining, int streamDependency, int weight, boolean exclusive) {
        super(streamId, flags, remaining);
        this.streamDependency = streamDependency;
        this.weight = weight;
        this.exclusive = exclusive;
    }

    @Override
    public boolean decode(ByteBuffer buffer) {
        if (this.finishDecode()) {
            return true;
        }
        if (buffer.remaining() < 5) {
            return false;
        }
        int value = buffer.getInt();
        this.streamDependency = value & Integer.MAX_VALUE;
        this.exclusive = (value & Integer.MIN_VALUE) != 0;
        this.weight = buffer.get() & 0xFF;
        this.remaining -= 5;
        this.checkEndRemaining();
        return true;
    }

    @Override
    public int type() {
        return 2;
    }

    public int streamDependency() {
        return this.streamDependency;
    }

    public int weight() {
        return this.weight;
    }

    public boolean exclusive() {
        return this.exclusive;
    }
}

