/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.hpack;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.smartboot.http.common.codec.h2.hpack.Huffman;
import org.smartboot.http.common.codec.h2.hpack.ISO_8859_1;
import org.smartboot.http.common.codec.h2.hpack.IntegerWriter;
import org.smartboot.http.common.codec.h2.hpack.QuickHuffman;

final class StringWriter {
    private static final int NEW = 0;
    private static final int CONFIGURED = 1;
    private static final int LENGTH_WRITTEN = 2;
    private static final int DONE = 4;
    private final IntegerWriter intWriter = new IntegerWriter();
    private final Huffman.Writer huffmanWriter = new QuickHuffman.Writer();
    private final ISO_8859_1.Writer plainWriter = new ISO_8859_1.Writer();
    private int state = 0;
    private boolean huffman;

    StringWriter() {
    }

    StringWriter configure(CharSequence input, boolean huffman) {
        return this.configure(input, 0, input.length(), huffman);
    }

    StringWriter configure(CharSequence input, int start, int end, boolean huffman) {
        if (start < 0 || end < 0 || end > input.length() || start > end) {
            throw new IndexOutOfBoundsException(String.format("input.length()=%s, start=%s, end=%s", input.length(), start, end));
        }
        if (!huffman) {
            this.plainWriter.configure(input, start, end);
            this.intWriter.configure(end - start, 7, 0);
        } else {
            this.huffmanWriter.from(input, start, end);
            this.intWriter.configure(this.huffmanWriter.lengthOf(input, start, end), 7, 128);
        }
        this.huffman = huffman;
        this.state = 1;
        return this;
    }

    boolean write(ByteBuffer output) {
        if (this.state == 4) {
            return true;
        }
        if (this.state == 0) {
            throw new IllegalStateException("Configure first");
        }
        if (!output.hasRemaining()) {
            return false;
        }
        if (this.state == 1) {
            if (this.intWriter.write(output)) {
                this.state = 2;
            } else {
                return false;
            }
        }
        if (this.state == 2) {
            boolean written;
            boolean bl = written = this.huffman ? this.huffmanWriter.write(output) : this.plainWriter.write(output);
            if (written) {
                this.state = 4;
                return true;
            }
            return false;
        }
        throw new InternalError(Arrays.toString(new Object[]{this.state, this.huffman}));
    }

    void reset() {
        this.intWriter.reset();
        if (this.huffman) {
            this.huffmanWriter.reset();
        } else {
            this.plainWriter.reset();
        }
        this.state = 0;
    }
}

