/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf3;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.Element;
import org.apache.commons.beanutils.BeanMap;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.annotations.Anonymous;
import org.red5.compatibility.flex.messaging.io.ObjectProxy;
import org.red5.io.amf.AMF;
import org.red5.io.amf3.ByteArray;
import org.red5.io.amf3.DataOutput;
import org.red5.io.amf3.IExternalizable;
import org.red5.io.object.RecordSet;
import org.red5.io.object.Serializer;
import org.red5.io.object.UnsignedInt;
import org.red5.io.utils.HexDump;
import org.red5.io.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Output
extends org.red5.io.amf.Output
implements org.red5.io.object.Output {
    protected static Logger log = LoggerFactory.getLogger(Output.class);
    private int amf3_mode = 0;
    private ConcurrentMap<String, Integer> stringReferences = new ConcurrentHashMap<String, Integer>(8, 0.9f, 2);

    public Output(IoBuffer buf) {
        super(buf);
    }

    public void enforceAMF3() {
        ++this.amf3_mode;
    }

    protected IoBuffer getBuffer() {
        return this.buf;
    }

    protected void writeAMF3() {
        if (this.amf3_mode == 0) {
            this.buf.put((byte)17);
        }
    }

    @Override
    public void writeBoolean(Boolean bol) {
        this.writeAMF3();
        this.buf.put(bol != false ? (byte)3 : 2);
    }

    @Override
    public void writeNull() {
        this.writeAMF3();
        this.buf.put((byte)1);
    }

    protected void putInteger(long value) {
        if (value >= -268435456L && value <= 0xFFFFFFFL) {
            value &= 0x1FFFFFFFL;
        }
        if (value < 128L) {
            this.buf.put((byte)value);
        } else if (value < 16384L) {
            this.buf.put((byte)(value >> 7 & 0x7FL | 0x80L));
            this.buf.put((byte)(value & 0x7FL));
        } else if (value < 0x200000L) {
            this.buf.put((byte)(value >> 14 & 0x7FL | 0x80L));
            this.buf.put((byte)(value >> 7 & 0x7FL | 0x80L));
            this.buf.put((byte)(value & 0x7FL));
        } else if (value < 0x40000000L) {
            this.buf.put((byte)(value >> 22 & 0x7FL | 0x80L));
            this.buf.put((byte)(value >> 15 & 0x7FL | 0x80L));
            this.buf.put((byte)(value >> 8 & 0x7FL | 0x80L));
            this.buf.put((byte)(value & 0xFFL));
        } else {
            log.error("Integer out of range: {}", (Object)value);
        }
    }

    protected static byte[] encodeString(String string) {
        byte[] encoded;
        Element element = Output.getStringCache().get((Serializable)((Object)string));
        byte[] byArray = encoded = element == null ? null : (byte[])element.getObjectValue();
        if (encoded == null) {
            ByteBuffer buf = AMF.CHARSET.encode(string);
            encoded = new byte[buf.limit()];
            buf.get(encoded);
            Output.getStringCache().put(new Element((Serializable)((Object)string), (Serializable)encoded));
        }
        return encoded;
    }

    protected void putString(String str, byte[] encoded) {
        int len = encoded.length;
        Integer pos = (Integer)this.stringReferences.get(str);
        if (pos != null) {
            this.putInteger(pos << 1);
            return;
        }
        this.putInteger(len << 1 | 1);
        this.buf.put(encoded);
        this.stringReferences.put(str, this.stringReferences.size());
    }

    @Override
    public void putString(String string) {
        if ("".equals(string)) {
            this.putInteger(1L);
            return;
        }
        byte[] encoded = Output.encodeString(string);
        this.putString(string, encoded);
    }

    @Override
    public void writeNumber(Number num) {
        this.writeAMF3();
        if (num.longValue() < -268435456L || num.longValue() > 0xFFFFFFFL) {
            this.buf.put((byte)5);
            this.buf.putDouble(num.doubleValue());
        } else if (num instanceof Long || num instanceof Integer || num instanceof Short || num instanceof Byte) {
            this.buf.put((byte)4);
            this.putInteger(num.longValue());
        } else {
            this.buf.put((byte)5);
            this.buf.putDouble(num.doubleValue());
        }
    }

    @Override
    public void writeString(String string) {
        this.writeAMF3();
        this.buf.put((byte)6);
        if ("".equals(string)) {
            this.putInteger(1L);
        } else {
            byte[] encoded = Output.encodeString(string);
            this.putString(string, encoded);
        }
    }

    @Override
    public void writeDate(Date date) {
        this.writeAMF3();
        this.buf.put((byte)8);
        if (this.hasReference(date)) {
            this.putInteger(this.getReferenceId(date) << 1);
            return;
        }
        this.storeReference(date);
        this.putInteger(1L);
        this.buf.putDouble((double)date.getTime());
    }

    @Override
    public void writeArray(Collection<?> array) {
        this.writeAMF3();
        this.buf.put((byte)9);
        if (this.hasReference(array)) {
            this.putInteger(this.getReferenceId(array) << 1);
            return;
        }
        this.storeReference(array);
        ++this.amf3_mode;
        int count = array.size();
        this.putInteger(count << 1 | 1);
        this.putString("");
        for (Object item : array) {
            Serializer.serialize(this, item);
        }
        --this.amf3_mode;
    }

    @Override
    public void writeArray(Object[] array) {
        this.writeAMF3();
        this.buf.put((byte)9);
        if (this.hasReference(array)) {
            this.putInteger(this.getReferenceId(array) << 1);
            return;
        }
        this.storeReference(array);
        ++this.amf3_mode;
        int count = array.length;
        this.putInteger(count << 1 | 1);
        this.putString("");
        for (Object item : array) {
            Serializer.serialize(this, item);
        }
        --this.amf3_mode;
    }

    @Override
    public void writeArray(Object array) {
        this.writeAMF3();
        this.buf.put((byte)9);
        if (this.hasReference(array)) {
            this.putInteger(this.getReferenceId(array) << 1);
            return;
        }
        this.storeReference(array);
        ++this.amf3_mode;
        int count = Array.getLength(array);
        this.putInteger(count << 1 | 1);
        this.putString("");
        for (int i = 0; i < count; ++i) {
            Serializer.serialize(this, Array.get(array, i));
        }
        --this.amf3_mode;
    }

    @Override
    public void writeMap(Map<Object, Object> map) {
        int i;
        this.writeAMF3();
        this.buf.put((byte)9);
        if (this.hasReference(map)) {
            this.putInteger(this.getReferenceId(map) << 1);
            return;
        }
        this.storeReference(map);
        int count = 0;
        for (i = 0; i < map.size(); ++i) {
            try {
                if (!map.containsKey(i)) {
                }
            }
            catch (ClassCastException err) {}
            break;
            ++count;
        }
        ++this.amf3_mode;
        if (count == map.size()) {
            this.putInteger(count << 1 | 1);
            this.putString("");
            for (i = 0; i < count; ++i) {
                Serializer.serialize(this, map.get(i));
            }
            --this.amf3_mode;
            return;
        }
        this.putInteger(count << 1 | 1);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof Number && !(key instanceof Float) && !(key instanceof Double) && ((Number)key).longValue() >= 0L && ((Number)key).longValue() < (long)count) continue;
            this.putString(key.toString());
            Serializer.serialize(this, entry.getValue());
        }
        this.putString("");
        for (int i2 = 0; i2 < count; ++i2) {
            Serializer.serialize(this, map.get(i2));
        }
        --this.amf3_mode;
    }

    @Override
    public void writeMap(Collection<?> array) {
        this.writeAMF3();
        this.buf.put((byte)9);
        if (this.hasReference(array)) {
            this.putInteger(this.getReferenceId(array) << 1);
            return;
        }
        this.storeReference(array);
        ++this.amf3_mode;
        this.putInteger(1L);
        int idx = 0;
        for (Object item : array) {
            if (item != null) {
                this.putString(String.valueOf(idx));
                Serializer.serialize(this, item);
            }
            ++idx;
        }
        --this.amf3_mode;
        this.putString("");
    }

    @Override
    protected void writeArbitraryObject(Object object) {
        log.debug("writeArbitraryObject: {}", object);
        Class<?> objectClass = object.getClass();
        if (!objectClass.isAnnotationPresent(Anonymous.class)) {
            this.putString(Serializer.getClassName(objectClass));
        } else {
            this.putString("");
        }
        ++this.amf3_mode;
        for (Field field : objectClass.getFields()) {
            Object value;
            String fieldName = field.getName();
            log.debug("Field: {} class: {}", (Object)field, objectClass);
            if (!this.serializeField(objectClass, fieldName, field, null)) continue;
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException err) {
                continue;
            }
            this.putString(fieldName);
            Serializer.serialize(this, field, null, object, value);
        }
        --this.amf3_mode;
        this.putString("");
    }

    @Override
    public void writeObject(Object object) {
        log.debug("writeObject: {} {}", (Object)object.getClass().getName(), object);
        this.writeAMF3();
        this.buf.put((byte)10);
        if (this.hasReference(object)) {
            log.debug("Object reference found");
            this.putInteger(this.getReferenceId(object) << 1);
            return;
        }
        log.debug("Storing object reference");
        this.storeReference(object);
        if (object instanceof IExternalizable) {
            log.debug("Object is IExternalizable");
            int type = 3;
            type = object instanceof ObjectProxy ? (type |= 0xC) : (type |= 4);
            this.putInteger(type);
            this.putString(Serializer.getClassName(object.getClass()));
            ++this.amf3_mode;
            ((IExternalizable)object).writeExternal(new DataOutput(this));
            --this.amf3_mode;
            return;
        }
        log.debug("Object is NOT IExternalizable");
        int type = 11;
        this.putInteger(type);
        BeanMap beanMap = new BeanMap(object);
        Set set = beanMap.keySet();
        if (set.size() == 0 || set.size() == 1 && beanMap.containsKey((Object)"class")) {
            this.writeArbitraryObject(object);
            return;
        }
        Class<?> objectClass = object.getClass();
        if (!objectClass.isAnnotationPresent(Anonymous.class)) {
            log.debug("Object is annotated as Anonymous");
            this.putString(Serializer.getClassName(object.getClass()));
        } else {
            this.putString("");
        }
        ++this.amf3_mode;
        for (Object key : set) {
            String fieldName = key.toString();
            log.debug("Field name: {} class: {}", (Object)fieldName, objectClass);
            Field field = this.getField(objectClass, fieldName);
            Method getter = this.getGetter(objectClass, beanMap, fieldName);
            if (!this.serializeField(objectClass, fieldName, field, getter)) continue;
            this.putString(fieldName);
            Serializer.serialize(this, field, getter, object, beanMap.get(key));
        }
        --this.amf3_mode;
        this.putString("");
    }

    @Override
    public void writeObject(Map<Object, Object> map) {
        log.debug("writeObject: {}", map);
        this.writeAMF3();
        this.buf.put((byte)10);
        if (this.hasReference(map)) {
            this.putInteger(this.getReferenceId(map) << 1);
            return;
        }
        this.storeReference(map);
        int type = 11;
        this.putInteger(type);
        this.putString("");
        ++this.amf3_mode;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            this.putString(entry.getKey().toString());
            Serializer.serialize(this, entry.getValue());
        }
        --this.amf3_mode;
        this.putString("");
    }

    @Override
    public void writeRecordSet(RecordSet recordset) {
        this.writeString("Not implemented.");
    }

    @Override
    public void writeXML(Document xml) {
        this.writeAMF3();
        this.buf.put((byte)11);
        if (this.hasReference(xml)) {
            this.putInteger(this.getReferenceId(xml) << 1);
            return;
        }
        byte[] encoded = Output.encodeString(XMLUtils.docToString(xml));
        this.putInteger(encoded.length << 1 | 1);
        this.buf.put(encoded);
        this.storeReference(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeByteArray(ByteArray array) {
        this.writeAMF3();
        this.buf.put((byte)12);
        if (this.hasReference(array)) {
            this.putInteger(this.getReferenceId(array) << 1);
            return;
        }
        this.storeReference(array);
        IoBuffer data = array.getData();
        this.putInteger(data.limit() << 1 | 1);
        byte[] tmp = new byte[data.limit()];
        int old = data.position();
        try {
            data.position(0);
            data.get(tmp);
            this.buf.put(tmp);
        }
        finally {
            data.position(old);
        }
    }

    @Override
    public void writeVectorInt(Vector<Integer> vector) {
        log.debug("writeVectorInt: {}", vector);
        this.writeAMF3();
        this.buf.put((byte)13);
        if (this.hasReference(vector)) {
            this.putInteger(this.getReferenceId(vector) << 1);
            return;
        }
        this.storeReference(vector);
        this.putInteger(vector.size() << 1 | 1);
        this.buf.put((byte)0);
        for (Integer v : vector) {
            this.buf.putInt(v.intValue());
        }
        if (log.isDebugEnabled()) {
            int pos = this.buf.position();
            this.buf.position(0);
            StringBuilder sb = new StringBuilder();
            HexDump.dumpHex(sb, this.buf.array());
            log.debug("\n{}", (Object)sb);
            this.buf.position(pos);
        }
    }

    @Override
    public void writeVectorUInt(Vector<Long> vector) {
        log.debug("writeVectorUInt: {}", vector);
        this.writeAMF3();
        this.buf.put((byte)14);
        if (this.hasReference(vector)) {
            this.putInteger(this.getReferenceId(vector) << 1);
            return;
        }
        this.storeReference(vector);
        this.putInteger(vector.size() << 1 | 1);
        this.buf.put((byte)0);
        for (Long v : vector) {
            UnsignedInt uint = new UnsignedInt(v);
            byte[] arr = uint.getBytes();
            this.buf.put(arr);
        }
    }

    @Override
    public void writeVectorNumber(Vector<Double> vector) {
        log.debug("writeVectorNumber: {}", vector);
        this.buf.put((byte)15);
        if (this.hasReference(vector)) {
            this.putInteger(this.getReferenceId(vector) << 1);
            return;
        }
        this.storeReference(vector);
        this.putInteger(vector.size() << 1 | 1);
        this.putInteger(0L);
        this.buf.put((byte)0);
        for (Double v : vector) {
            this.buf.putDouble(v.doubleValue());
        }
    }

    @Override
    public void writeVectorObject(Vector<Object> vector) {
        log.debug("writeVectorObject: {}", vector);
        this.buf.put((byte)16);
        if (this.hasReference(vector)) {
            this.putInteger(this.getReferenceId(vector) << 1);
            return;
        }
        this.storeReference(vector);
        this.putInteger(vector.size() << 1 | 1);
        this.putInteger(0L);
        this.buf.put((byte)1);
        for (Object v : vector) {
            Serializer.serialize(this, v);
        }
    }
}

