/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.object;

import java.util.Arrays;
import org.red5.io.object.UnsignedNumber;

public final class UnsignedShort
extends UnsignedNumber {
    static final long serialVersionUID = 1L;
    private int value;

    public UnsignedShort(byte c) {
        this.value = c;
    }

    public UnsignedShort(short c) {
        this.value = c;
    }

    public UnsignedShort(int c) {
        this.value = c & 0xFFFF;
    }

    public UnsignedShort(long c) {
        this.value = (int)(c & 0xFFFFL);
    }

    private UnsignedShort() {
        this.value = 0;
    }

    public static UnsignedShort fromBytes(byte[] c) {
        return UnsignedShort.fromBytes(c, 0);
    }

    public static UnsignedShort fromBytes(byte[] c, int idx) {
        UnsignedShort number = new UnsignedShort();
        if (c.length - idx < 2) {
            throw new IllegalArgumentException("An UnsignedShort number is composed of 2 bytes.");
        }
        number.value = c[0] << 8 | c[1] & 0xFFFF;
        return number;
    }

    public static UnsignedShort fromString(String c) {
        return UnsignedShort.fromString(c, 10);
    }

    public static UnsignedShort fromString(String c, int radix) {
        UnsignedShort number = new UnsignedShort();
        long v = Integer.parseInt(c, radix);
        number.value = (int)(v & 0xFFFFL);
        return number;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)(this.value & 0xFFFF);
    }

    @Override
    public int intValue() {
        return this.value & 0xFFFF;
    }

    @Override
    public long longValue() {
        return (long)this.value & 0xFFFFL;
    }

    @Override
    public byte[] getBytes() {
        return new byte[]{(byte)(this.value >> 8 & 0xFF), (byte)(this.value & 0xFF)};
    }

    @Override
    public int compareTo(UnsignedNumber other) {
        int otherValue = other.intValue();
        if (this.value > otherValue) {
            return 1;
        }
        if (this.value < otherValue) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Number) {
            return Arrays.equals(this.getBytes(), ((UnsignedNumber)other).getBytes());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public void shiftRight(int nBits) {
        if (Math.abs(nBits) > 16) {
            throw new IllegalArgumentException("Cannot right shift " + nBits + " an UnsignedShort.");
        }
        this.value >>>= nBits;
    }

    @Override
    public void shiftLeft(int nBits) {
        if (Math.abs(nBits) > 16) {
            throw new IllegalArgumentException("Cannot left shift " + nBits + " an UnsignedShort.");
        }
        this.value <<= nBits;
    }
}

