/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc;

import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.simpleflatmapper.jdbc.ConnectedCrud;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.impl.CrudFactory;
import org.simpleflatmapper.jdbc.impl.CrudMeta;
import org.simpleflatmapper.jdbc.impl.DataSourceTransactionTemplate;
import org.simpleflatmapper.jdbc.impl.LazyCrud;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.meta.AliasProviderService;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.DefaultPropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.Table;
import org.simpleflatmapper.util.TypeHelper;

public class CrudDSL<T, K> {
    private final ClassMeta<T> target;
    private final ClassMeta<K> keyTarget;
    private final JdbcMapperFactory jdbcMapperFactory;

    public CrudDSL(ClassMeta<T> target, ClassMeta<K> keyTarget, JdbcMapperFactory jdbcMapperFactory) {
        this.target = target;
        this.keyTarget = keyTarget;
        this.jdbcMapperFactory = jdbcMapperFactory;
    }

    public Crud<T, K> crud() {
        return new LazyCrud(this, null);
    }

    public Crud<T, K> table(String table) {
        return new LazyCrud(this, table);
    }

    public Crud<T, K> table(Connection connection, String table) throws SQLException {
        CrudMeta crudMeta = CrudMeta.of(connection, table, (ColumnDefinitionProvider<FieldMapperColumnDefinition<JdbcColumnKey>, JdbcColumnKey>)this.jdbcMapperFactory.columnDefinitions());
        return CrudFactory.newInstance(this.target, this.keyTarget, crudMeta, this.jdbcMapperFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectedCrud<T, K> table(DataSource dataSource, String table) throws SQLException {
        Connection connection = dataSource.getConnection();
        try {
            ConnectedCrud<T, K> connectedCrud = new ConnectedCrud<T, K>(new DataSourceTransactionTemplate(dataSource), this.table(connection, table));
            return connectedCrud;
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectedCrud<T, K> to(DataSource dataSource) throws SQLException {
        Connection connection = dataSource.getConnection();
        try {
            ConnectedCrud<T, K> connectedCrud = new ConnectedCrud<T, K>(new DataSourceTransactionTemplate(dataSource), this.to(connection));
            return connectedCrud;
        }
        finally {
            connection.close();
        }
    }

    public Crud<T, K> to(Connection connection) throws SQLException {
        return this.table(connection, this.getTable(connection, this.target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTable(Connection connection, ClassMeta<T> target) throws SQLException {
        Class targetClass = TypeHelper.toClass((Type)target.getType());
        Table table = AliasProviderService.getAliasProvider().getTable(targetClass);
        StringBuilder sb = new StringBuilder();
        if (table.schema() != null && table.schema().length() > 0) {
            sb.append(table.schema()).append(".");
        }
        if (table.table() == null) {
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet tables = this.getTables(connection, metaData);
            String className = TypeHelper.toClass((Type)targetClass).getSimpleName();
            try {
                while (tables.next()) {
                    String tableName = tables.getString("TABLE_NAME");
                    if (!DefaultPropertyNameMatcher.of((String)tableName).matches((CharSequence)className)) continue;
                    sb.append(tableName);
                    String string = sb.toString();
                    return string;
                }
            }
            finally {
                tables.close();
            }
            throw new IllegalArgumentException("Type " + target.getType() + " has no table mapping");
        }
        sb.append(table.table());
        return sb.toString();
    }

    private ResultSet getTables(Connection connection, DatabaseMetaData metaData) throws SQLException {
        try {
            return metaData.getTables(connection.getCatalog(), null, null, null);
        }
        catch (SQLException e) {
            if ("S1009".equals(e.getSQLState())) {
                return metaData.getTables(connection.getCatalog(), null, "", null);
            }
            throw e;
        }
    }
}

