/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.SqlTypeColumnProperty;
import org.simpleflatmapper.jdbc.impl.ColumnMeta;
import org.simpleflatmapper.jdbc.impl.DatabaseMeta;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.property.AutoGeneratedProperty;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.map.property.IgnoreAutoGeneratedProperty;
import org.simpleflatmapper.map.property.KeyProperty;

public class CrudMeta {
    private final DatabaseMeta databaseMeta;
    private final String table;
    private final ColumnMeta[] columnMetas;

    public CrudMeta(DatabaseMeta databaseMeta, String table, ColumnMeta[] columnMetas) {
        this.databaseMeta = databaseMeta;
        this.table = table;
        this.columnMetas = columnMetas;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public String getTable() {
        return this.table;
    }

    public ColumnMeta[] getColumnMetas() {
        return this.columnMetas;
    }

    public boolean hasGeneratedKeys() {
        for (ColumnMeta cm : this.columnMetas) {
            if (!cm.isKey() || !cm.isGenerated()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CrudMeta of(Connection connection, String table, ColumnDefinitionProvider<FieldMapperColumnDefinition<JdbcColumnKey>, JdbcColumnKey> columnDefinitionProvider) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            CrudMeta crudMeta;
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + table + " WHERE 1 = 2");
            try {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                DatabaseMetaData metaData = connection.getMetaData();
                DatabaseMeta databaseMeta = new DatabaseMeta(metaData.getDatabaseProductName(), metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion());
                ColumnMeta[] columnMetas = new ColumnMeta[resultSetMetaData.getColumnCount()];
                List<String> primaryKeys = CrudMeta.getPrimaryKeys(connection, resultSetMetaData, columnDefinitionProvider);
                for (int i = 0; i < columnMetas.length; ++i) {
                    String columnName = resultSetMetaData.getColumnName(i + 1);
                    FieldMapperColumnDefinition columnDefinition = (FieldMapperColumnDefinition)columnDefinitionProvider.getColumnDefinition((FieldKey)JdbcColumnKey.of(resultSetMetaData, i + 1));
                    AutoGeneratedProperty autoGeneratedProperty = (AutoGeneratedProperty)columnDefinition.lookFor(AutoGeneratedProperty.class);
                    if (autoGeneratedProperty == null && resultSetMetaData.isAutoIncrement(i + 1) && !columnDefinition.has(IgnoreAutoGeneratedProperty.class)) {
                        autoGeneratedProperty = AutoGeneratedProperty.DEFAULT;
                    }
                    columnMetas[i] = new ColumnMeta(columnName, resultSetMetaData.getColumnType(i + 1), primaryKeys.contains(columnName), autoGeneratedProperty);
                }
                crudMeta = new CrudMeta(databaseMeta, table, columnMetas);
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return crudMeta;
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getPrimaryKeys(Connection connection, ResultSetMetaData resultSetMetaData, ColumnDefinitionProvider<FieldMapperColumnDefinition<JdbcColumnKey>, JdbcColumnKey> columnDefinitionProvider) throws SQLException {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            JdbcColumnKey key = JdbcColumnKey.of(resultSetMetaData, i);
            if (!((FieldMapperColumnDefinition)columnDefinitionProvider.getColumnDefinition((FieldKey)key)).has(KeyProperty.class)) continue;
            primaryKeys.add(key.getName());
        }
        if (!primaryKeys.isEmpty()) {
            return primaryKeys;
        }
        ResultSet set = connection.getMetaData().getPrimaryKeys(resultSetMetaData.getCatalogName(1), resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1));
        try {
            while (set.next()) {
                primaryKeys.add(set.getString("COLUMN_NAME"));
            }
        }
        finally {
            set.close();
        }
        return primaryKeys;
    }

    public void addColumnProperties(JdbcMapperFactory mapperFactory) {
        for (ColumnMeta columnMeta : this.columnMetas) {
            mapperFactory.addColumnProperty(columnMeta.getColumn(), new Object[]{SqlTypeColumnProperty.of(columnMeta.getSqlType())});
            if (!columnMeta.isKey()) continue;
            mapperFactory.addColumnProperty(columnMeta.getColumn(), new Object[]{KeyProperty.DEFAULT});
        }
    }
}

