/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import org.elasticsearch.index.VersionType;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.support.PersistentEntityInformation;

public class MappingElasticsearchEntityInformation<T, ID>
extends PersistentEntityInformation<T, ID>
implements ElasticsearchEntityInformation<T, ID> {
    private final ElasticsearchPersistentEntity<T> entityMetadata;
    private final IndexCoordinates indexCoordinates;
    private final VersionType versionType;

    public MappingElasticsearchEntityInformation(ElasticsearchPersistentEntity<T> entity) {
        this(entity, entity.getIndexCoordinates(), entity.getVersionType());
    }

    public MappingElasticsearchEntityInformation(ElasticsearchPersistentEntity<T> entity, IndexCoordinates indexCoordinates, VersionType versionType) {
        super(entity);
        this.entityMetadata = entity;
        this.indexCoordinates = indexCoordinates;
        this.versionType = versionType;
    }

    @Override
    public String getIdAttribute() {
        return ((ElasticsearchPersistentProperty)this.entityMetadata.getRequiredIdProperty()).getFieldName();
    }

    @Override
    public IndexCoordinates getIndexCoordinates() {
        return this.indexCoordinates;
    }

    @Override
    public Long getVersion(T entity) {
        ElasticsearchPersistentProperty versionProperty = this.entityMetadata.getVersionProperty();
        try {
            return versionProperty != null ? (Long)this.entityMetadata.getPropertyAccessor(entity).getProperty((PersistentProperty)versionProperty) : null;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to load version field", e);
        }
    }

    @Override
    public VersionType getVersionType() {
        return this.versionType;
    }

    @Override
    public String getParentId(T entity) {
        ElasticsearchPersistentProperty parentProperty = this.entityMetadata.getParentIdProperty();
        try {
            return parentProperty != null ? (String)this.entityMetadata.getPropertyAccessor(entity).getProperty((PersistentProperty)parentProperty) : null;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to load parent ID: " + e, e);
        }
    }
}

