/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.jdbc.core.DataAccessStrategy;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.Interpreter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;

class DefaultJdbcInterpreter
implements Interpreter {
    private final RelationalMappingContext context;
    private final DataAccessStrategy accessStrategy;

    @Override
    public <T> void interpret(DbAction.Insert<T> insert) {
        Object id = this.accessStrategy.insert(insert.getEntity(), insert.getEntityType(), this.createAdditionalColumnValues(insert));
        insert.setGeneratedId(id);
    }

    @Override
    public <T> void interpret(DbAction.InsertRoot<T> insert) {
        Object id = this.accessStrategy.insert(insert.getEntity(), insert.getEntityType(), Collections.emptyMap());
        insert.setGeneratedId(id);
    }

    @Override
    public <T> void interpret(DbAction.Update<T> update) {
        this.accessStrategy.update(update.getEntity(), update.getEntityType());
    }

    @Override
    public <T> void interpret(DbAction.UpdateRoot<T> update) {
        this.accessStrategy.update(update.getEntity(), update.getEntityType());
    }

    @Override
    public <T> void interpret(DbAction.Merge<T> merge) {
        if (!this.accessStrategy.update(merge.getEntity(), merge.getEntityType())) {
            this.accessStrategy.insert(merge.getEntity(), merge.getEntityType(), this.createAdditionalColumnValues(merge));
        }
    }

    @Override
    public <T> void interpret(DbAction.Delete<T> delete) {
        this.accessStrategy.delete(delete.getRootId(), delete.getPropertyPath());
    }

    @Override
    public <T> void interpret(DbAction.DeleteRoot<T> delete) {
        this.accessStrategy.delete(delete.getRootId(), delete.getEntityType());
    }

    @Override
    public <T> void interpret(DbAction.DeleteAll<T> delete) {
        this.accessStrategy.deleteAll(delete.getPropertyPath());
    }

    @Override
    public <T> void interpret(DbAction.DeleteAllRoot<T> deleteAllRoot) {
        this.accessStrategy.deleteAll(deleteAllRoot.getEntityType());
    }

    private <T> Map<String, Object> createAdditionalColumnValues(DbAction.WithDependingOn<T> action) {
        HashMap<String, Object> additionalColumnValues = new HashMap<String, Object>();
        this.addDependingOnInformation(action, additionalColumnValues);
        additionalColumnValues.putAll(action.getAdditionalValues());
        return additionalColumnValues;
    }

    private <T> void addDependingOnInformation(DbAction.WithDependingOn<T> action, Map<String, Object> additionalColumnValues) {
        DbAction.WithEntity<?> dependingOn = action.getDependingOn();
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(dependingOn.getEntityType());
        String columnName = this.getColumnNameForReverseColumn(action);
        Object identifier = this.getIdFromEntityDependingOn(dependingOn, persistentEntity);
        additionalColumnValues.put(columnName, identifier);
    }

    @Nullable
    private Object getIdFromEntityDependingOn(DbAction.WithEntity<?> dependingOn, RelationalPersistentEntity<?> persistentEntity) {
        Object generatedId;
        Object entity = dependingOn.getEntity();
        if (dependingOn instanceof DbAction.WithGeneratedId && (generatedId = ((DbAction.WithGeneratedId)dependingOn).getGeneratedId()) != null) {
            return generatedId;
        }
        return persistentEntity.getIdentifierAccessor(entity).getIdentifier();
    }

    private String getColumnNameForReverseColumn(DbAction.WithPropertyPath<?> action) {
        PersistentPropertyPath<RelationalPersistentProperty> path = action.getPropertyPath();
        return ((RelationalPersistentProperty)path.getRequiredLeafProperty()).getReverseColumnName();
    }

    public DefaultJdbcInterpreter(RelationalMappingContext context, DataAccessStrategy accessStrategy) {
        this.context = context;
        this.accessStrategy = accessStrategy;
    }
}

