/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.pagination;

import graphql.TrivialDataFetcher;
import graphql.relay.Connection;
import graphql.relay.ConnectionCursor;
import graphql.relay.DefaultConnection;
import graphql.relay.DefaultConnectionCursor;
import graphql.relay.DefaultEdge;
import graphql.relay.DefaultPageInfo;
import graphql.relay.Edge;
import graphql.relay.PageInfo;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.graphql.data.pagination.ConnectionAdapter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class ConnectionFieldTypeVisitor
extends GraphQLTypeVisitorStub {
    private static Log logger = LogFactory.getLog(ConnectionFieldTypeVisitor.class);
    private final ConnectionAdapter adapter;

    private ConnectionFieldTypeVisitor(ConnectionAdapter adapter) {
        Assert.notNull((Object)adapter, (String)"ConnectionAdapter is required");
        this.adapter = adapter;
    }

    public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition fieldDefinition, TraverserContext<GraphQLSchemaElement> context) {
        GraphQLCodeRegistry.Builder codeRegistry = (GraphQLCodeRegistry.Builder)context.getVarFromParents(GraphQLCodeRegistry.Builder.class);
        GraphQLFieldsContainer parent = (GraphQLFieldsContainer)context.getParentNode();
        DataFetcher dataFetcher = codeRegistry.getDataFetcher(parent, fieldDefinition);
        if (parent.getName().equalsIgnoreCase("mutation") || parent.getName().equalsIgnoreCase("subscription")) {
            return TraversalControl.ABORT;
        }
        if (ConnectionFieldTypeVisitor.isConnectionField(fieldDefinition)) {
            if (dataFetcher instanceof TrivialDataFetcher) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Connection field '" + parent.getName() + ":" + fieldDefinition.getName() + "' is mapped to trivial data fetcher: " + dataFetcher.getClass().getName()));
                }
            } else {
                codeRegistry.dataFetcher(parent, fieldDefinition, (DataFetcher)new ConnectionDataFetcher(dataFetcher, this.adapter));
            }
        }
        return TraversalControl.CONTINUE;
    }

    private static boolean isConnectionField(GraphQLFieldDefinition fieldDefinition) {
        GraphQLObjectType objectType;
        GraphQLOutputType returnType = fieldDefinition.getType();
        if (returnType instanceof GraphQLNonNull) {
            GraphQLNonNull nonNullType = (GraphQLNonNull)returnType;
            returnType = nonNullType.getWrappedType();
        }
        return returnType instanceof GraphQLObjectType && (objectType = (GraphQLObjectType)returnType).getName().endsWith("Connection") && objectType.getField("pageInfo") != null;
    }

    public static ConnectionFieldTypeVisitor create(List<ConnectionAdapter> adapters) {
        Assert.notEmpty(adapters, (String)"Expected at least one ConnectionAdapter");
        return new ConnectionFieldTypeVisitor(ConnectionAdapter.from(adapters));
    }

    private record ConnectionDataFetcher(DataFetcher<?> delegate, ConnectionAdapter adapter) implements DataFetcher<Object>
    {
        private static final Connection<?> EMPTY_CONNECTION = new DefaultConnection(Collections.emptyList(), (PageInfo)new DefaultPageInfo(null, null, false, false));

        private ConnectionDataFetcher {
            Assert.notNull(delegate, (String)"DataFetcher delegate is required");
            Assert.notNull((Object)adapter, (String)"ConnectionAdapter is required");
        }

        public Object get(DataFetchingEnvironment environment) throws Exception {
            Object result = this.delegate.get(environment);
            if (result instanceof Mono) {
                Mono mono = (Mono)result;
                return mono.map(this::adapt);
            }
            if (result instanceof CompletionStage) {
                CompletionStage stage = (CompletionStage)result;
                return stage.thenApply(this::adapt);
            }
            return this.adapt(result);
        }

        private <T> Connection<T> adapt(@Nullable Object container) {
            List nodes;
            if (container instanceof Connection) {
                Connection connection = (Connection)container;
                return connection;
            }
            Collection<Object> collection = nodes = container != null ? this.adapter.getContent(container) : Collections.emptyList();
            if (nodes.isEmpty()) {
                return EMPTY_CONNECTION;
            }
            int index = 0;
            ArrayList<DefaultEdge> edges = new ArrayList<DefaultEdge>(nodes.size());
            for (Object node : nodes) {
                String cursor = this.adapter.cursorAt(container, index++);
                edges.add(new DefaultEdge(node, (ConnectionCursor)new DefaultConnectionCursor(cursor)));
            }
            DefaultPageInfo pageInfo = new DefaultPageInfo(((Edge)edges.get(0)).getCursor(), ((Edge)edges.get(edges.size() - 1)).getCursor(), this.adapter.hasPrevious(container), this.adapter.hasNext(container));
            return new DefaultConnection(edges, (PageInfo)pageInfo);
        }
    }
}

