/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.core;

import java.util.Arrays;
import java.util.Properties;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.integration.mqtt.core.ConsumerStopAction;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.util.Assert;

public class DefaultMqttPahoClientFactory
implements MqttPahoClientFactory {
    private volatile Boolean cleanSession;
    private volatile Integer connectionTimeout;
    private volatile Integer keepAliveInterval;
    private volatile String password;
    private volatile SocketFactory socketFactory;
    private volatile Properties sslProperties;
    private volatile String userName;
    private volatile MqttClientPersistence persistence;
    private volatile Will will;
    private volatile String[] serverURIs;
    private volatile ConsumerStopAction consumerStopAction = ConsumerStopAction.UNSUBSCRIBE_CLEAN;

    public void setCleanSession(Boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setKeepAliveInterval(Integer keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setSslProperties(Properties sslProperties) {
        this.sslProperties = sslProperties;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setWill(Will will) {
        this.will = will;
    }

    public void setPersistence(MqttClientPersistence persistence) {
        this.persistence = persistence;
    }

    public void setServerURIs(String ... serverURIs) {
        Assert.notNull((Object)serverURIs, (String)"'serverURIs' must not be null.");
        this.serverURIs = Arrays.copyOf(serverURIs, serverURIs.length);
    }

    @Override
    public ConsumerStopAction getConsumerStopAction() {
        return this.consumerStopAction;
    }

    public void setConsumerStopAction(ConsumerStopAction consumerStopAction) {
        this.consumerStopAction = consumerStopAction;
    }

    @Override
    public IMqttClient getClientInstance(String uri, String clientId) throws MqttException {
        return new MqttClient(uri == null ? "tcp://NO_URL_PROVIDED" : uri, clientId, this.persistence);
    }

    @Override
    public IMqttAsyncClient getAsyncClientInstance(String uri, String clientId) throws MqttException {
        return new MqttAsyncClient(uri == null ? "tcp://NO_URL_PROVIDED" : uri, clientId, this.persistence);
    }

    @Override
    public MqttConnectOptions getConnectionOptions() {
        MqttConnectOptions options = new MqttConnectOptions();
        if (this.cleanSession != null) {
            options.setCleanSession(this.cleanSession.booleanValue());
        }
        if (this.connectionTimeout != null) {
            options.setConnectionTimeout(this.connectionTimeout.intValue());
        }
        if (this.keepAliveInterval != null) {
            options.setKeepAliveInterval(this.keepAliveInterval.intValue());
        }
        if (this.password != null) {
            options.setPassword(this.password.toCharArray());
        }
        if (this.socketFactory != null) {
            options.setSocketFactory(this.socketFactory);
        }
        if (this.sslProperties != null) {
            options.setSSLProperties(this.sslProperties);
        }
        if (this.userName != null) {
            options.setUserName(this.userName);
        }
        if (this.will != null) {
            options.setWill(this.will.getTopic(), this.will.getPayload(), this.will.getQos(), this.will.isRetained());
        }
        if (this.serverURIs != null) {
            options.setServerURIs(this.serverURIs);
        }
        return options;
    }

    public static class Will {
        private final String topic;
        private final byte[] payload;
        private final int qos;
        private final boolean retained;

        public Will(String topic, byte[] payload, int qos, boolean retained) {
            this.topic = topic;
            this.payload = payload;
            this.qos = qos;
            this.retained = retained;
        }

        protected String getTopic() {
            return this.topic;
        }

        protected byte[] getPayload() {
            return this.payload;
        }

        protected int getQos() {
            return this.qos;
        }

        protected boolean isRetained() {
            return this.retained;
        }
    }
}

