/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.converter;

import java.lang.reflect.Type;
import org.unidal.converter.Converter;
import org.unidal.converter.ConverterPriority;
import org.unidal.converter.ConverterRegistry;
import org.unidal.converter.TypeUtil;
import org.unidal.converter.advanced.ConstructorConverter;
import org.unidal.converter.basic.BooleanConverter;
import org.unidal.converter.basic.ByteConverter;
import org.unidal.converter.basic.CharConverter;
import org.unidal.converter.basic.DoubleConverter;
import org.unidal.converter.basic.EnumConverter;
import org.unidal.converter.basic.FloatConverter;
import org.unidal.converter.basic.IntegerConverter;
import org.unidal.converter.basic.LongConverter;
import org.unidal.converter.basic.ObjectConverter;
import org.unidal.converter.basic.ShortConverter;
import org.unidal.converter.basic.StringConverter;
import org.unidal.converter.collection.ArrayConverter;
import org.unidal.converter.collection.ListConverter;
import org.unidal.converter.dom.NodeArrayConverter;
import org.unidal.converter.dom.NodeConverter;
import org.unidal.converter.dom.NodeListConverter;
import org.unidal.converter.dom.NodeValueConverter;

public class ConverterManager {
    private static final ConverterManager s_instance = new ConverterManager();
    private ConverterRegistry m_registry = new ConverterRegistry();

    private ConverterManager() {
        this.registerConverters();
    }

    private void registerConverters() {
        this.m_registry.registerConverter(new BooleanConverter());
        this.m_registry.registerConverter(new ByteConverter());
        this.m_registry.registerConverter(new CharConverter());
        this.m_registry.registerConverter(new DoubleConverter());
        this.m_registry.registerConverter(new EnumConverter());
        this.m_registry.registerConverter(new FloatConverter());
        this.m_registry.registerConverter(new IntegerConverter());
        this.m_registry.registerConverter(new LongConverter());
        this.m_registry.registerConverter(new ObjectConverter(), ConverterPriority.VERY_LOW.getValue());
        this.m_registry.registerConverter(new StringConverter(), ConverterPriority.LOW.getValue());
        this.m_registry.registerConverter(new ShortConverter());
        this.m_registry.registerConverter(new ArrayConverter());
        this.m_registry.registerConverter(new ListConverter());
        this.m_registry.registerConverter(new ConstructorConverter(), ConverterPriority.HIGH.getValue());
        this.m_registry.registerConverter(new NodeConverter());
        this.m_registry.registerConverter(new NodeArrayConverter(), ConverterPriority.HIGH.getValue());
        this.m_registry.registerConverter(new NodeListConverter(), ConverterPriority.HIGH.getValue());
        this.m_registry.registerConverter(new NodeValueConverter(), ConverterPriority.HIGH.getValue());
    }

    public static final ConverterManager getInstance() {
        return s_instance;
    }

    public Object convert(Object from, Type targetType) {
        Class<?> rawType = TypeUtil.getRawType(targetType);
        if (rawType.isAssignableFrom(from.getClass())) {
            return from;
        }
        Converter<?> converter = this.m_registry.findConverter(from.getClass(), targetType);
        return converter.convert(from, targetType);
    }

    public ConverterRegistry getRegistry() {
        return this.m_registry;
    }
}

