/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.net.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.unidal.net.transport.TransportHub;

public abstract class AbstractTransportHub<T>
implements TransportHub {
    protected abstract T decode(ByteBuf var1);

    protected abstract void encode(ByteBuf var1, T var2);

    @Override
    public boolean fill(ByteBuf buf) {
        T message = this.nextMessage();
        if (message != null) {
            buf.writeByte(202);
            buf.writeByte(254);
            buf.writeInt(0);
            this.encode(buf, message);
            buf.setInt(2, buf.readableBytes() - 6);
            return true;
        }
        return false;
    }

    protected abstract void handle(T var1, Channel var2);

    protected abstract T nextMessage();

    @Override
    public void onMessage(ByteBuf buf, Channel channel) {
        T message = this.decode(buf);
        this.handle(message, channel);
    }
}

