/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.net.transport;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;
import org.unidal.net.ServerTransport;
import org.unidal.net.transport.ServerTransportDescriptor;
import org.unidal.net.transport.ServerTransportHandler;
import org.unidal.net.transport.TransportHub;

@Named(type=ServerTransport.class, instantiationStrategy="per-lookup")
public class DefaultServerTransport
implements ServerTransport {
    @Inject
    private ServerTransportHandler m_handler;
    private ServerTransportDescriptor m_desc = new ServerTransportDescriptor();

    @Override
    public ServerTransport bind(int port) {
        this.m_desc.setLocalAddress(new InetSocketAddress(port));
        return this;
    }

    @Override
    public ServerTransport handler(String name, ChannelHandler handler) {
        this.m_desc.addHandler(name, handler);
        return this;
    }

    @Override
    public ServerTransport name(String name) {
        this.m_desc.setName(name);
        return this;
    }

    @Override
    public <T> ServerTransport option(ChannelOption<T> option, T value) {
        this.m_desc.getOptions().put(option, value);
        return this;
    }

    @Override
    public ServerTransport start(TransportHub hub) {
        this.m_desc.setHub(hub);
        this.m_desc.validate();
        this.m_handler.setDescriptor(this.m_desc);
        Threads.forGroup(this.m_desc.getName()).start(this.m_handler);
        try {
            this.m_handler.awaitWarmup();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public void stop(int timeout, TimeUnit unit) throws InterruptedException {
        this.m_handler.shutdown();
        this.m_handler.awaitTermination(timeout, unit);
    }

    @Override
    public ServerTransport withBossThreads(int bossThreads) {
        this.m_desc.setBossThreads(bossThreads);
        return this;
    }

    @Override
    public ServerTransport withWorkerThreads(int workerThreads) {
        this.m_desc.setWorkerThreads(workerThreads);
        return this;
    }
}

