/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.middleware.db.router;

import cn.bugstack.middleware.db.router.DBRouterConfig;
import cn.bugstack.middleware.db.router.annotation.DBRouter;
import cn.bugstack.middleware.db.router.strategy.IDBRouterStrategy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class DBRouterJoinPoint {
    private Logger logger = LoggerFactory.getLogger(DBRouterJoinPoint.class);
    private DBRouterConfig dbRouterConfig;
    private IDBRouterStrategy dbRouterStrategy;

    public DBRouterJoinPoint(DBRouterConfig dbRouterConfig, IDBRouterStrategy dbRouterStrategy) {
        this.dbRouterConfig = dbRouterConfig;
        this.dbRouterStrategy = dbRouterStrategy;
    }

    @Pointcut(value="@annotation(cn.bugstack.middleware.db.router.annotation.DBRouter)")
    public void aopPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="aopPoint() && @annotation(dbRouter)")
    public Object doRouter(ProceedingJoinPoint jp, DBRouter dbRouter) throws Throwable {
        String dbKey = dbRouter.key();
        if (StringUtils.isBlank((String)dbKey) && StringUtils.isBlank((String)this.dbRouterConfig.getRouterKey())) {
            throw new RuntimeException("annotation DBRouter key is null\uff01");
        }
        dbKey = StringUtils.isNotBlank((String)dbKey) ? dbKey : this.dbRouterConfig.getRouterKey();
        String dbKeyAttr = this.getAttrValue(dbKey, jp.getArgs());
        this.dbRouterStrategy.doRouter(dbKeyAttr);
        try {
            Object object = jp.proceed();
            return object;
        }
        finally {
            this.dbRouterStrategy.clear();
        }
    }

    private Method getMethod(JoinPoint jp) throws NoSuchMethodException {
        Signature sig = jp.getSignature();
        MethodSignature methodSignature = (MethodSignature)sig;
        return jp.getTarget().getClass().getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
    }

    public String getAttrValue(String attr, Object[] args) {
        Object arg;
        if (1 == args.length && (arg = args[0]) instanceof String) {
            return arg.toString();
        }
        String filedValue = null;
        for (Object arg2 : args) {
            try {
                if (StringUtils.isNotBlank(filedValue)) break;
                filedValue = String.valueOf(this.getValueByName(arg2, attr));
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u8def\u7531\u5c5e\u6027\u503c\u5931\u8d25 attr\uff1a{}", (Object)attr, (Object)e);
            }
        }
        return filedValue;
    }

    private Object getValueByName(Object item, String name) {
        try {
            Field field = this.getFieldByName(item, name);
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            Object o = field.get(item);
            field.setAccessible(false);
            return o;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private Field getFieldByName(Object item, String name) {
        try {
            Field field;
            try {
                field = item.getClass().getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                field = item.getClass().getSuperclass().getDeclaredField(name);
            }
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }
}

