/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.utils.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingPongUtils {
    private static final Logger log = LoggerFactory.getLogger(PingPongUtils.class);
    static final String PING = "ping";
    static final String PONG = "pong";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkConnectivity(String targetIp, int targetPort) {
        try (Socket s = new Socket(targetIp, targetPort);
             InputStream is = s.getInputStream();
             OutputStream os = s.getOutputStream();
             BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            os.write(PING.getBytes(StandardCharsets.UTF_8));
            os.flush();
            String content = br.readLine();
            if (!PONG.equalsIgnoreCase(content)) return false;
            boolean bl = true;
            return bl;
        }
        catch (UnknownHostException e) {
            log.warn("[SocketConnectivityUtils] unknown host: {}:{}", (Object)targetIp, (Object)targetPort);
            return false;
        }
        catch (IOException e) {
            log.warn("[SocketConnectivityUtils] IOException: {}:{}, msg: {}", new Object[]{targetIp, targetPort, ExceptionUtils.getMessage((Throwable)e)});
            return false;
        }
        catch (Exception e) {
            log.error("[SocketConnectivityUtils] unknown exception for check ip: {}:{}", new Object[]{targetIp, targetPort, e});
        }
        return false;
    }
}

