/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.common.constants;

import com.google.common.collect.Sets;
import java.util.Set;

public enum TaskStatus {
    WAITING_DISPATCH(1, "\u7b49\u5f85\u8c03\u5ea6\u5668\u8c03\u5ea6", "dispatching"),
    DISPATCH_SUCCESS_WORKER_UNCHECK(2, "\u8c03\u5ea6\u6210\u529f\uff08\u4f46\u4e0d\u4fdd\u8bc1worker\u6536\u5230\uff09", "unreceived"),
    WORKER_RECEIVED(3, "worker\u63a5\u6536\u6210\u529f\uff0c\u4f46\u672a\u5f00\u59cb\u6267\u884c", "received"),
    WORKER_PROCESSING(4, "worker\u6b63\u5728\u6267\u884c", "running"),
    WORKER_PROCESS_FAILED(5, "worker\u6267\u884c\u5931\u8d25", "failed"),
    WORKER_PROCESS_SUCCESS(6, "worker\u6267\u884c\u6210\u529f", "succeed");

    public static final Set<Integer> FINISHED_STATUS;
    private final int value;
    private final String des;
    private final String simplyDesc;

    public static TaskStatus of(int v) {
        for (TaskStatus taskStatus : TaskStatus.values()) {
            if (v != taskStatus.value) continue;
            return taskStatus;
        }
        throw new IllegalArgumentException("no TaskStatus match the value of " + v);
    }

    public int getValue() {
        return this.value;
    }

    public String getDes() {
        return this.des;
    }

    public String getSimplyDesc() {
        return this.simplyDesc;
    }

    private TaskStatus(int value, String des, String simplyDesc) {
        this.value = value;
        this.des = des;
        this.simplyDesc = simplyDesc;
    }

    static {
        FINISHED_STATUS = Sets.newHashSet((Object[])new Integer[]{TaskStatus.WORKER_PROCESS_FAILED.value, TaskStatus.WORKER_PROCESS_SUCCESS.value});
    }
}

