/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.core.processor.sdk;

import java.util.List;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.core.processor.TaskResult;
import tech.powerjob.worker.core.processor.sdk.BasicProcessor;

public interface BroadcastProcessor
extends BasicProcessor {
    default public ProcessResult preProcess(TaskContext context) throws Exception {
        return new ProcessResult(true);
    }

    default public ProcessResult postProcess(TaskContext context, List<TaskResult> taskResults) throws Exception {
        return BroadcastProcessor.defaultResult(taskResults);
    }

    public static ProcessResult defaultResult(List<TaskResult> taskResults) {
        long succeed = 0L;
        long failed = 0L;
        for (TaskResult ts : taskResults) {
            if (ts.isSuccess()) {
                ++succeed;
                continue;
            }
            ++failed;
        }
        return new ProcessResult(failed == 0L, String.format("succeed:%d, failed:%d", succeed, failed));
    }
}

