/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.encode;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import ws.schild.jave.encode.ArgType;
import ws.schild.jave.encode.EncodingArgument;
import ws.schild.jave.encode.EncodingAttributes;

public class ValueArgument
implements EncodingArgument {
    private final ArgType argumentType;
    private final String argumentName;
    private final Function<EncodingAttributes, Optional<String>> valueGetter;

    public ValueArgument(ArgType argType, String argumentName, Function<EncodingAttributes, Optional<String>> valueGetter) {
        this.argumentType = argType;
        this.argumentName = argumentName;
        this.valueGetter = valueGetter;
    }

    protected Boolean isPresent(EncodingAttributes context) {
        return this.getValue(context).isPresent();
    }

    @Override
    public Stream<String> getArguments(EncodingAttributes context) {
        return this.getValue(context).map(value -> Stream.of(this.getName(), value)).orElseGet(Stream::empty);
    }

    private String getName() {
        return this.argumentName;
    }

    private Optional<String> getValue(EncodingAttributes context) {
        return this.valueGetter.apply(context);
    }

    @Override
    public ArgType getArgType() {
        return this.argumentType;
    }
}

