/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.domain.config;

import cn.com.pg.paas.monitor.domain.properties.StreamApiProperties;
import cn.com.pg.paas.monitor.domain.services.ICustomApiMetric;
import cn.com.pg.paas.monitor.infrastructure.CustomMetric;
import cn.com.pg.paas.monitor.infrastructure.HttpUtil;
import cn.com.pg.paas.monitor.infrastructure.JsonUtil;
import cn.com.pg.paas.monitor.infrastructure.LogPoint;
import cn.com.pg.paas.monitor.infrastructure.LoggerUtil;
import cn.com.pg.paas.monitor.infrastructure.ServiceInfoUtil;
import cn.com.pg.paas.monitor.infrastructure.SignUtil;
import cn.com.pg.paas.monitor.infrastructure.StreamingUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class LogActionAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(LogActionAutoConfiguration.class);
    @Value(value="${monitor.sendevent.maxpoolSize:120}")
    private int maxPoolSize;
    @Value(value="${monitor.sendevent.corepoolSize:100}")
    private int corePoolSize;
    @Value(value="${monitor.sendevent.queueCapacity:999}")
    private int queueCapacity;

    @Bean
    public Executor sendEventHubExecutor() {
        logger.info("init SendEventHubExecutor");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.corePoolSize);
        executor.setMaxPoolSize(this.maxPoolSize);
        executor.setQueueCapacity(this.queueCapacity);
        executor.setThreadNamePrefix("monitor-send");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        logger.info("finish SendEventHubExecutor,maxPoolSize\uff1a{}", (Object)this.maxPoolSize);
        return executor;
    }

    @Bean
    public ServiceInfoUtil serviceInfoUtil() {
        return new ServiceInfoUtil();
    }

    @Bean
    public LoggerUtil loggerUtil() {
        return new LoggerUtil();
    }

    @Bean
    public JsonUtil jsonUtil() {
        return new JsonUtil();
    }

    @Bean
    public HttpUtil httpUtil() {
        return new HttpUtil();
    }

    @Bean
    public LogPoint logPoint() {
        return new LogPoint();
    }

    @Bean
    public SignUtil signUtil() {
        return new SignUtil();
    }

    @Bean
    public StreamingUtil missStreamingUtil() {
        return new StreamingUtil();
    }

    @Bean
    public StreamApiProperties streamApiProperties() {
        StreamApiProperties streamApiProperties = new StreamApiProperties();
        streamApiProperties.setApiMetricEventTypeId("0f724400f1594161bc33d9073f98eaac");
        streamApiProperties.setKpiMetricEventTypeId("5bd46688fc2c4b49b9436b9cbc96a781");
        streamApiProperties.setUrl("https://transitsharedqaapim0.azure-api.cn/stream-api/message/");
        streamApiProperties.setSubscriptionKey("fe9b251860ea4ae29414d7b921745db3");
        streamApiProperties.setApiKey("1fee5e58");
        streamApiProperties.setSecret("db085ea897884fe3aaa3df3e9eb30e96");
        return streamApiProperties;
    }

    @Bean
    @Profile(value={"prod"})
    public StreamApiProperties createStreamApiPropertiesProd() {
        StreamApiProperties streamApiProperties = new StreamApiProperties();
        streamApiProperties.setApiMetricEventTypeId("0f724400f1594161bc33d9073f98eaac");
        streamApiProperties.setKpiMetricEventTypeId("5bd46688fc2c4b49b9436b9cbc96a781");
        streamApiProperties.setUrl("https://transitsharedprdapim0.azure-api.cn/stream-api/message/");
        streamApiProperties.setSubscriptionKey("fe9b251860ea4ae29414d7b921745db3");
        streamApiProperties.setApiKey("1fee5e58");
        streamApiProperties.setSecret("db085ea897884fe3aaa3df3e9eb30e96");
        return streamApiProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ICustomApiMetric customApiMetric() {
        return new CustomMetric();
    }
}

