/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.infrastructure;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

public class ApiHealthMetric {
    @Value(value="${health.aggregate.restart-item:}")
    private String[] restartItem = new String[0];
    private CollectorRegistry registry;
    private static final Gauge NOLABELS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("health_status")).labelNames(new String[]{"components"})).help("Health status of microservice applications")).register();

    public ApiHealthMetric(CollectorRegistry collectorRegistry) {
        this.registry = collectorRegistry;
        NOLABELS.register(this.registry);
    }

    public String myEndpoint(Set<String> unhealthyAgg) throws IOException {
        NOLABELS.clear();
        StringWriter writer = new StringWriter();
        if (unhealthyAgg.size() == 0) {
            ((Gauge.Child)NOLABELS.labels(new String[]{""})).set(0.0);
        } else {
            ((Gauge.Child)NOLABELS.labels(new String[]{StringUtils.join(unhealthyAgg, (String)",")})).set(1.0);
        }
        TextFormat.write004((Writer)writer, (Enumeration)this.registry.metricFamilySamples());
        return writer.toString();
    }

    public List<String> appStatus(Set<String> unhealthyAgg) throws IOException {
        List<String> attentionUnHealthItems = unhealthyAgg.stream().filter(item -> ArrayUtils.contains((Object[])this.restartItem, (Object)item)).collect(Collectors.toList());
        return attentionUnHealthItems;
    }

    public Set<String> attentionAggHealth(Health health) {
        HashSet<String> unhealthyAgg = new HashSet<String>();
        for (Map.Entry entry : health.getDetails().entrySet()) {
            if (!(entry.getValue() instanceof Health)) continue;
            unhealthyAgg.addAll(this.aggregateUnHealthyAgg((String)entry.getKey(), (Health)entry.getValue()));
        }
        return unhealthyAgg;
    }

    public final Set<String> aggregateUnHealthyAgg(String name, Health health) {
        HashSet<String> unhealthyAgg = new HashSet<String>();
        if (health.getStatus() == Status.DOWN || health.getStatus() == Status.OUT_OF_SERVICE) {
            unhealthyAgg.add(name);
        }
        if (health.getDetails() == null) {
            return unhealthyAgg;
        }
        for (Map.Entry entry : health.getDetails().entrySet()) {
            if (!(entry.getValue() instanceof Health)) continue;
            Health childHealth = (Health)entry.getValue();
            if (childHealth.getStatus() == Status.DOWN || childHealth.getStatus() == Status.OUT_OF_SERVICE) {
                unhealthyAgg.add((String)entry.getKey());
            }
            unhealthyAgg.addAll(this.aggregateUnHealthyAgg((String)entry.getKey(), childHealth));
        }
        return unhealthyAgg;
    }
}

